/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.engines.blind.eval;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.actf.visualization.engines.blind.eval.PageEvaluation;
import org.eclipse.actf.visualization.eval.EvaluationResultImpl;
import org.eclipse.actf.visualization.eval.guideline.GuidelineHolder;
import org.eclipse.actf.visualization.eval.html.HtmlTagUtil;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluationResultBlind
extends EvaluationResultImpl {
    private int count = 0;
    private PageEvaluation pageEvaluation = null;

    public void addProblemItems(Collection<IProblemItem> c) {
        this.stripProblem(c);
        super.addProblemItems(c);
    }

    public void setProblemList(List<IProblemItem> problemList) {
        this.count = 0;
        this.stripProblem(problemList);
        super.setProblemList(problemList);
    }

    private void stripProblem(Collection<IProblemItem> c) {
        GuidelineHolder holder = GuidelineHolder.getInstance();
        Iterator<IProblemItem> i = c.iterator();
        while (i.hasNext()) {
            try {
                IProblemItem tmpItem = i.next();
                if (holder.isMatchedCheckItem(tmpItem.getEvaluationItem())) {
                    tmpItem.setSerialNumber(this.count);
                    if (tmpItem.isCanHighlight() && tmpItem.getTargetNode() != null && HtmlTagUtil.hasAncestor((Node)tmpItem.getTargetNode(), (String)"script")) {
                        tmpItem.setCanHighlight(false);
                    }
                    ++this.count;
                    continue;
                }
                i.remove();
            }
            catch (Exception exception) {
                i.remove();
            }
        }
    }

    public PageEvaluation getPageEvaluation() {
        return this.pageEvaluation;
    }

    public void setPageEvaluation(PageEvaluation pageEvaluation) {
        this.pageEvaluation = pageEvaluation;
    }
}

