/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.engines.blind;

import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.actf.visualization.engines.blind.TextCheckResult;
import org.eclipse.actf.visualization.internal.engines.blind.BlindVizEnginePlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextChecker {
    private static final String NULL_STRING = "";
    private static final String KIGOU = "(\\p{InMathematicalOperators}|\\p{InGeometricShapes}|\\p{InMiscellaneousSymbols}|\\p{InBoxDrawing}|\\p{InGeneralPunctuation}|\\p{InCJKSymbolsandPunctuation}|\\p{InArrows})";
    private static final String NIHONGO = "(\\p{InCJKUnifiedIdeographs}|\\p{InHiragana}|\\p{InKatakana})";
    private static final String KANJI = "(\\p{InCJKUnifiedIdeographs})";
    private static final String ALT_TEXT_PROPERTIES_FILE = "altText.properties";
    private static final String INAPP_ALT = "blindViz.inappropriateAlt_";
    private static final String POSSIBLE_INAPP_ALT = "blindViz.possible_inappAlt_";
    private static TextChecker INSTANCE;
    private Set<String> ngwordset = new TreeSet<String>();
    private Set<String> ngwordset2 = new TreeSet<String>();
    private Set<String> ngPatterns = new HashSet<String>();
    private IPreferenceStore pref = BlindVizEnginePlugin.getDefault().getPreferenceStore();

    private TextChecker() {
        if (!this.pref.getBoolean("blindViz.not_first_time")) {
            Properties prop = new Properties();
            try {
                InputStream prefIS = FileLocator.openStream((Bundle)Platform.getBundle((String)"org.eclipse.actf.visualization.engines.blind"), (IPath)new Path("config/altText.properties"), (boolean)false);
                if (prefIS != null) {
                    prop.load(prefIS);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            for (Object key : prop.keySet()) {
                String value;
                String keyS = (String)key;
                if (keyS.startsWith(INAPP_ALT)) {
                    value = prop.getProperty(keyS);
                    if (value.length() <= 0) continue;
                    this.ngwordset.add(value);
                    continue;
                }
                if (!keyS.startsWith(POSSIBLE_INAPP_ALT) || (value = prop.getProperty(keyS)).length() <= 0) continue;
                this.ngwordset2.add(value);
            }
            this.resetPreferences();
        } else {
            String value;
            int i = 0;
            while (this.pref.contains(INAPP_ALT + i)) {
                value = this.pref.getString(INAPP_ALT + i);
                if (value.length() > 0) {
                    this.ngwordset.add(value);
                }
                ++i;
            }
            i = 0;
            while (this.pref.contains(POSSIBLE_INAPP_ALT + i)) {
                value = this.pref.getString(POSSIBLE_INAPP_ALT + i);
                if (value.length() > 0) {
                    this.ngwordset2.add(value);
                }
                ++i;
            }
        }
        this.ngPatterns.add("\u753b\u50cf\\s*\\d+");
    }

    public static synchronized TextChecker getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TextChecker();
        }
        return INSTANCE;
    }

    public boolean isRedundantText(String prevText, String curText) {
        if (prevText != null && prevText.length() > 1 && curText.length() > 1) {
            String prevText2 = prevText.replaceAll("\\[|\\]|\\.|\\!|\\>", NULL_STRING);
            prevText2 = prevText2.trim();
            String curText2 = curText.replaceAll("\\[|\\]|\\.|\\!|\\>", NULL_STRING);
            if ((curText2 = curText2.trim()).equalsIgnoreCase(prevText2)) {
                return true;
            }
        }
        return false;
    }

    public boolean isInappropriateAlt(String alt) {
        String tmpAlt = alt.trim();
        return this.ngwordset.contains(tmpAlt = tmpAlt.toLowerCase()) || this.isEndWithImageExt(tmpAlt);
    }

    public int checkInappropriateAlt(String alt) {
        String[] tmpSA = alt.toLowerCase().split("((\\p{InMathematicalOperators}|\\p{InGeometricShapes}|\\p{InMiscellaneousSymbols}|\\p{InBoxDrawing}|\\p{InGeneralPunctuation}|\\p{InCJKSymbolsandPunctuation}|\\p{InArrows})|\\p{Punct}|\\p{Space})");
        int count = 0;
        int all = 0;
        int charLength = 0;
        int i = 0;
        while (i < tmpSA.length) {
            if (tmpSA[i].length() > 0) {
                ++all;
            }
            charLength += tmpSA[i].length();
            if (this.ngwordset2.contains(tmpSA[i])) {
                ++count;
            }
            ++i;
        }
        int org = alt.length();
        if (org > 0 && alt.matches(".*(\\p{Alpha}\\p{Space}){3,}.*")) {
            return 3;
        }
        if (org > 0 && (double)charLength / (double)org < 0.5 && !alt.matches("\\p{Space}*")) {
            return 1;
        }
        if ((double)count / (double)all > 0.6) {
            return 2;
        }
        if ((double)count / (double)all > 0.3) {
            return 1;
        }
        return 0;
    }

    private boolean isEndWithImageExt(String alt) {
        String tmpS = alt.trim().toLowerCase();
        String regexp3 = "\\p{Print}*\\.(jpg|jpeg|gif|png|bmp|tiff)";
        return tmpS.matches(regexp3);
    }

    public boolean isSeparatedJapaneseChars(String target) {
        String regexp2;
        String tmpS = target.trim();
        return (tmpS = tmpS.toLowerCase()).matches(regexp2 = ".*\\b(\\p{InCJKUnifiedIdeographs}|\\p{InHiragana}|\\p{InKatakana})[\\p{Space}\u3000\u00a0]+(\\p{InCJKUnifiedIdeographs}|\\p{InHiragana}|\\p{InKatakana})\\b.*");
    }

    public Set<String> getInappropriateALTSet() {
        HashSet<String> tmpSet = new HashSet<String>();
        tmpSet.addAll(this.ngwordset);
        return tmpSet;
    }

    private void resetPreferences() {
        int i = 0;
        for (String value : this.ngwordset) {
            this.pref.setValue(INAPP_ALT + i, value);
            ++i;
        }
        int j = i;
        while (this.pref.contains(INAPP_ALT + j)) {
            this.pref.setValue(INAPP_ALT + j, NULL_STRING);
            ++j;
        }
        i = 0;
        for (String value : this.ngwordset2) {
            this.pref.setValue(POSSIBLE_INAPP_ALT + i, value);
            ++i;
        }
        j = i;
        while (this.pref.contains(POSSIBLE_INAPP_ALT + j)) {
            this.pref.setValue(POSSIBLE_INAPP_ALT + j, NULL_STRING);
            ++j;
        }
    }

    public void setInappropriateAltSet(Set<String> inappAltSet) {
        if (inappAltSet != null) {
            this.ngwordset = inappAltSet;
        }
        this.resetPreferences();
    }

    public TextCheckResult checkAlt(String alt) {
        return this.checkAlt(alt, null, new TreeSet<String>());
    }

    public TextCheckResult checkAlt(String alt, String src) {
        return this.checkAlt(alt, src, new TreeSet<String>());
    }

    public TextCheckResult checkAlt(String alt, Set<String> ngWords) {
        return this.checkAlt(alt, null, ngWords);
    }

    public TextCheckResult checkAlt(String alt, String src, Set<String> ngWords) {
        String fileName;
        Matcher m;
        String origAlt = alt;
        int origLength = alt.length();
        if ((alt = alt.toLowerCase()).equals(NULL_STRING)) {
            return TextCheckResult.NULL;
        }
        assert (origLength > 0);
        if (alt.matches("[\\p{Space}\\u3000\\u00A0]+")) {
            if (alt.matches(".*\\u00A0.*")) {
                return TextCheckResult.BLANK_NBSP;
            }
            return TextCheckResult.BLANK;
        }
        if (this.ngwordset.contains(alt = alt.trim()) || ngWords.contains(alt)) {
            return TextCheckResult.NG_WORD;
        }
        for (String patterns : this.ngPatterns) {
            if (!alt.matches(patterns)) continue;
            return TextCheckResult.NG_WORD;
        }
        if (src != null && (m = Pattern.compile(".*?([^/]+)").matcher(src.toLowerCase())).matches() && alt.equals(fileName = m.group(1))) {
            return TextCheckResult.SAME_AS_SRC;
        }
        if (this.isEndWithImageExt(alt)) {
            return TextCheckResult.IMG_EXT;
        }
        if (alt.matches(".*(\\p{Alpha}\\p{Space}){3,}.*")) {
            return TextCheckResult.SPACE_SEPARATED;
        }
        if (this.isSeparatedJapaneseChars(alt)) {
            return TextCheckResult.SPACE_SEPARATED_JP;
        }
        List<String> wordList = Arrays.asList(alt.toLowerCase().split("((\\p{InMathematicalOperators}|\\p{InGeometricShapes}|\\p{InMiscellaneousSymbols}|\\p{InBoxDrawing}|\\p{InGeneralPunctuation}|\\p{InCJKSymbolsandPunctuation}|\\p{InArrows})|\\p{Punct}|\\p{Space})"));
        int wordCountNG = 0;
        int wordCountAll = 0;
        for (String word : wordList) {
            word.length();
            if (word.length() > 0) {
                ++wordCountAll;
            }
            if (!this.ngwordset2.contains(word)) continue;
            ++wordCountNG;
        }
        if (this.isAsciiArtString(origAlt)) {
            return TextCheckResult.ASCII_ART;
        }
        if ((double)wordCountNG / (double)wordCountAll > 0.6) {
            return TextCheckResult.INCLUDING_MANY_NG_WORD;
        }
        if ((double)wordCountNG / (double)wordCountAll > 0.3) {
            return TextCheckResult.INCLUDING_NG_WORD;
        }
        return TextCheckResult.OK;
    }

    public boolean isAsciiArtString(String str) {
        int origLength = str.length();
        str = str.toLowerCase();
        List<String> wordList = Arrays.asList(str.toLowerCase().split("((\\p{InMathematicalOperators}|\\p{InGeometricShapes}|\\p{InMiscellaneousSymbols}|\\p{InBoxDrawing}|\\p{InGeneralPunctuation}|\\p{InCJKSymbolsandPunctuation}|\\p{InArrows})|\\p{Punct}|\\p{Space})"));
        int charLength = 0;
        for (String word : wordList) {
            charLength += word.length();
        }
        boolean isBlank = str.matches("[\\p{Space}\\u3000\\u00A0]*");
        return origLength > 0 && (double)charLength / (double)origLength < 0.5 && !isBlank;
    }
}

