/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.eclipse.actf.core.runtime.RuntimeContextFactory;
import org.eclipse.actf.util.resources.EclipseResourceLocator;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class PathGenerationUtil {
    public String getJarPathsFromBundle(String bundleName) {
        StringBuffer buffer = new StringBuffer();
        Platform.getInstallLocation().getURL().getPath();
        Bundle bundle = Platform.getBundle((String)bundleName);
        EclipseResourceLocator locator = (EclipseResourceLocator)RuntimeContextFactory.getInstance().getRuntimeContext().getResourceLocator();
        if (bundle != null) {
            Enumeration en = bundle.findEntries("/", "*.jar", true);
            while (en != null && en.hasMoreElements()) {
                try {
                    URL url = FileLocator.resolve((URL)((URL)en.nextElement()));
                    String urlPath = url.getPath();
                    String jarPath = null;
                    int bang = urlPath.indexOf(33);
                    jarPath = bang > 0 ? urlPath.substring(1, bang) : urlPath.substring(1);
                    if (buffer.length() > 0) {
                        buffer.append(File.pathSeparator);
                    }
                    buffer.append(jarPath);
                }
                catch (IOException iOException) {}
            }
            if (en == null && bundle != null) {
                if (buffer.length() > 0) {
                    buffer.append(File.pathSeparator);
                }
                buffer.append(locator.getPathToBundle(bundleName));
            }
        }
        return buffer.toString();
    }

    public String getJarPathFromBundle(String jarName, String bundleName) {
        new StringBuffer();
        Bundle aBundle = Platform.getBundle((String)bundleName);
        URL url = aBundle.getEntry(jarName);
        String jarPath = null;
        try {
            jarPath = Platform.resolve((URL)url).getPath();
        }
        catch (IOException iOException) {}
        return jarPath;
    }

    public String getJarPathFromJarBundle(String bundleName) {
        String platformLoc = Platform.getInstallLocation().getURL().getPath();
        String pluginLoc = String.valueOf(platformLoc) + "plugins/";
        StringBuffer buffer = new StringBuffer();
        File dir = new File(pluginLoc);
        String[] plugins = dir.list();
        int j = 0;
        while (j < plugins.length) {
            File file = new File(plugins[j]);
            if (!file.isDirectory() && plugins[j].endsWith(".jar") && plugins[j].startsWith(bundleName)) {
                if (buffer.length() > 0) {
                    buffer.append(File.pathSeparator);
                }
                buffer.append(String.valueOf(pluginLoc) + plugins[j]);
            }
            ++j;
        }
        return buffer.toString();
    }
}

