/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.flash.proxy;

import com.ibm.icu.text.MessageFormat;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.actf.model.flash.bridge.IWaXcoding;
import org.eclipse.actf.model.flash.bridge.WaXcodingFactory;
import org.eclipse.actf.model.flash.proxy.internal.INTERNET_PER_CONN_OPTION_LIST;
import org.eclipse.actf.model.flash.proxy.internal.WSTR;
import org.eclipse.actf.model.flash.proxy.internal.WinInet;
import org.eclipse.actf.model.internal.flash.proxy.ProxyPlugin;
import org.eclipse.actf.model.internal.flash.proxy.logs.ProxyLogHandler;
import org.eclipse.actf.util.win32.MemoryUtil;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;

public class ProxyManager {
    public static boolean initLogger = false;
    public static boolean forceProxy = false;
    private static String noProxy = "";
    private INTERNET_PER_CONN_OPTION_LIST savedList = new INTERNET_PER_CONN_OPTION_LIST(4);
    private int savedAddress;
    private int hSession;
    private boolean needRestore = false;
    private int currentPort = 0;
    private static String PROTCOL_HTTP;
    private static String PROTCOL_HTTPS;
    private static String PROTCOL_FTP;
    private static String PROTCOL_GOPHER;

    static {
        String[] temp = Platform.getApplicationArgs();
        int i = 0;
        while (i < temp.length) {
            String nextArg;
            if ("-initLogger".equals(temp[i])) {
                initLogger = true;
            } else if ("-forceProxy".equals(temp[i])) {
                forceProxy = true;
            } else if ("-noProxy".equals(temp[i]) && i < temp.length - 1 && (nextArg = temp[i + 1]).startsWith("|") && nextArg.endsWith("|")) {
                noProxy = nextArg;
            }
            ++i;
        }
        if (Platform.inDebugMode()) {
            System.out.println("initLogger = " + initLogger);
            System.out.println("forceProxy = " + forceProxy);
            System.out.println("noProxy = " + noProxy);
        }
        PROTCOL_HTTP = "http";
        PROTCOL_HTTPS = "https";
        PROTCOL_FTP = "ftp";
        PROTCOL_GOPHER = "gopher";
    }

    public ProxyManager() {
        this.savedList.perConnOptions[0].dwOption = 1;
        this.savedList.perConnOptions[1].dwOption = 2;
        this.savedList.perConnOptions[2].dwOption = 3;
        this.savedList.perConnOptions[3].dwOption = 4;
        this.savedAddress = MemoryUtil.GlobalAlloc((int)20);
        this.savedList.getData(this.savedAddress);
        int[] pInt = new int[]{20};
        WinInet.InternetQueryOptionW(0, 75, this.savedAddress, pInt);
        this.savedList.setData(this.savedAddress);
        WSTR wsAgent = new WSTR("Agent");
        this.hSession = WinInet.InternetOpenW(wsAgent.getAddress(), 1, 0, 0, 0);
        wsAgent.dispose();
    }

    public void startProxy(int port, int swfVersion, int timeout, boolean swfBootloader, boolean swfTranscoder) {
        int pos;
        IWaXcoding waXcoding = this.getIWaXcoding();
        waXcoding.setPort(port);
        waXcoding.setSWFTranscodingMinimumVersion(swfVersion);
        waXcoding.setTimeout(timeout);
        waXcoding.setExternalProxyFlag(false);
        waXcoding.setSWFBootloaderFlag(swfBootloader);
        waXcoding.setSWFTranscodingFlag(swfTranscoder);
        String extProxy = this.getDefaultProxy(PROTCOL_HTTP);
        if (extProxy != null && -1 != (pos = extProxy.indexOf(58))) {
            try {
                String extHost = extProxy.substring(0, pos);
                String portStr = extProxy.substring(pos + 1);
                int extPort = Integer.parseInt(portStr);
                waXcoding.setExternalProxyFlag(true);
                waXcoding.setExternalProxy(extHost, extPort);
                if (Platform.inDebugMode()) {
                    System.out.println("Using external proxy " + extHost + ":" + extPort);
                }
            }
            catch (Exception exception) {}
        }
        ProxyLogHandler.configure();
        waXcoding.start(initLogger);
        if (!initLogger) {
            ProxyLogHandler.resetLogLevel();
        }
        this.currentPort = waXcoding.getPort();
    }

    public void stopProxy() {
        if (this.currentPort != 0) {
            this.getIWaXcoding().stop();
            this.currentPort = 0;
        }
    }

    public void setInternetOptions(boolean isGlobal) {
        if (this.savedAddress != 0) {
            if (this.currentPort == 0) {
                this.invokeSetOption(this.hSession, this.savedAddress);
                this.invokeSetOption(0, this.savedAddress);
                this.needRestore = false;
            } else {
                INTERNET_PER_CONN_OPTION_LIST list = new INTERNET_PER_CONN_OPTION_LIST(2);
                list.perConnOptions[0].dwOption = 1;
                list.perConnOptions[0].dwValue = 5;
                list.perConnOptions[1].dwOption = 4;
                list.perConnOptions[1].strValue.setString(this.getAutoConfigURL(isGlobal || forceProxy));
                int address = MemoryUtil.GlobalAlloc((int)20);
                list.getData(address);
                this.invokeSetOption(this.hSession, address);
                this.invokeSetOption(0, isGlobal ? address : this.savedAddress);
                this.needRestore = isGlobal;
                MemoryUtil.GlobalFree((int)address);
                list.dispose();
            }
        }
    }

    public void dispose() {
        ProxyLogHandler.removeHandler();
        this.stopProxy();
        if (this.hSession != 0) {
            WinInet.InternetCloseHandle(this.hSession);
        }
        if (this.savedAddress != 0) {
            if (this.needRestore) {
                WinInet.InternetSetOptionW(0, 75, this.savedAddress, 20);
            }
            MemoryUtil.GlobalFree((int)this.savedAddress);
            this.savedList.dispose();
        }
    }

    private void invokeSetOption(int handle, int address) {
        WinInet.InternetSetOptionW(handle, 75, address, 20);
        WinInet.InternetSetOptionW(handle, 39, 0, 0);
        WinInet.InternetSetOptionW(handle, 37, 0, 0);
    }

    private String getDefaultProxy(String protocol) {
        String defaultProxy;
        if ((this.savedList.perConnOptions[0].dwValue & 2) != 0 && (defaultProxy = this.savedList.perConnOptions[1].strValue.getString()) != null) {
            String s;
            if (-1 == defaultProxy.indexOf(61)) {
                return defaultProxy;
            }
            Matcher m = Pattern.compile(String.valueOf(protocol) + "=(.+)").matcher(defaultProxy);
            if (m.find() && (s = m.group(1)) != null) {
                int sep = s.indexOf(59);
                return -1 == sep ? s : s.substring(0, sep);
            }
        }
        return null;
    }

    private IWaXcoding getIWaXcoding() {
        return WaXcodingFactory.getWaXcoding();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getAutoConfigURL(boolean disableAutoProxy) {
        String pac = ProxyManager.readPluginFile("templates/proxy.pac");
        if (pac == null) return null;
        String httpProxy = ProxyManager.getProxyString("localhost:" + this.currentPort);
        pac = pac.replaceAll("\\$NOPROXY_EXTS\\$", disableAutoProxy ? "" : noProxy).replaceAll("\\$HTTP_PROXY\\$", httpProxy).replaceAll("\\$HTTP_DIRECT\\$", ProxyManager.getProxyString(this.getDefaultProxy(PROTCOL_HTTP))).replaceAll("\\$HTTPS_DIRECT\\$", ProxyManager.getProxyString(this.getDefaultProxy(PROTCOL_HTTPS))).replaceAll("\\$FTP_DIRECT\\$", ProxyManager.getProxyString(this.getDefaultProxy(PROTCOL_FTP))).replaceAll("\\$GOPHER_DIRECT\\$", ProxyManager.getProxyString(this.getDefaultProxy(PROTCOL_GOPHER)));
        OutputStream os = null;
        IPath pacPath = ProxyPlugin.getDefault().getStateLocation().append("proxy.pac");
        os = new FileOutputStream(pacPath.toFile());
        OutputStreamWriter writer = new OutputStreamWriter(os, "utf-8");
        writer.write(pac);
        writer.close();
        String string = "file://" + pacPath.toString();
        if (os == null) return string;
        try {
            os.close();
            return string;
        }
        catch (IOException iOException) {}
        return string;
        catch (Exception e) {
            try {
                e.printStackTrace();
                if (os == null) return null;
            }
            catch (Throwable throwable) {
                if (os == null) throw throwable;
                try {
                    os.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                os.close();
                return null;
            }
            catch (IOException iOException) {}
            return null;
        }
    }

    private static String getProxyString(String defaultProxy) {
        return defaultProxy != null ? MessageFormat.format((String)"PROXY {0}; DIRECT", (Object[])new Object[]{defaultProxy}) : "DIRECT";
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String readPluginFile(String path) {
        int result;
        InputStream is = null;
        URL url = FileLocator.resolve((URL)ProxyPlugin.getDefault().getBundle().getEntry(path));
        is = url.openStream();
        InputStreamReader reader = new InputStreamReader(is);
        StringBuffer sb = new StringBuffer();
        char[] buff = new char[4096];
        while (-1 != (result = reader.read(buff))) {
            sb.append(buff, 0, result);
        }
        String string = sb.toString();
        if (is == null) return string;
        try {
            is.close();
            return string;
        }
        catch (IOException iOException) {}
        return string;
        catch (Exception e) {
            try {
                e.printStackTrace();
                if (is == null) return null;
            }
            catch (Throwable throwable) {
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                is.close();
                return null;
            }
            catch (IOException iOException) {}
            return null;
        }
    }
}

