/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import org.eclipse.actf.util.httpproxy.core.IHTTPResponseMessage;
import org.eclipse.actf.util.httpproxy.core.IMessageBody;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPMessage;

public abstract class HTTPResponseMessage
extends HTTPMessage
implements IHTTPResponseMessage {
    private static final byte[] STATUS_NO_CONTENT_A = "204".getBytes();
    private static final byte[] STATUS_NOT_MODIFIED_A = "304".getBytes();
    private static final int WRITEBODY_DEFAULT_WAIT_DENOM = 10;

    protected HTTPResponseMessage(long serial) {
        super(serial);
    }

    protected boolean isBodyEmpty() {
        byte[] statCode = this.getStatusCodeAsBytes();
        return Arrays.equals(statCode, STATUS_NO_CONTENT_A) || Arrays.equals(statCode, STATUS_NOT_MODIFIED_A);
    }

    public abstract String getStatusCodeAsString();

    public abstract byte[] getStatusCodeAsBytes();

    public abstract String getReasonPhraseAsString();

    public abstract byte[] getReasonPhraseAsBytes();

    protected void writeBodyWithoutContentLength(long timeout, IMessageBody msgBody, OutputStream out) throws IOException {
        if (this.isConnectionToBeClosed()) {
            int b;
            InputStream body = msgBody.getMessageBodyInputStream();
            while ((b = body.read()) >= 0) {
                out.write(b);
            }
        } else {
            InputStream body = msgBody.getMessageBodyTimeoutInputStream();
            long keepAliveTimeout = timeout / 10L;
            if (LOGGER.isDebugEnabled()) {
                StringBuffer sb = new StringBuffer();
                sb.append("keepAliveTimeout=" + keepAliveTimeout + " ms");
                LOGGER.debug(sb.toString());
                System.out.println(sb.toString());
            }
            long start = System.currentTimeMillis();
            long before = System.currentTimeMillis();
            while (System.currentTimeMillis() - before < keepAliveTimeout) {
                int b;
                try {
                    b = body.read();
                    if (b < 0) break;
                    before = System.currentTimeMillis();
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    continue;
                }
                out.write(b);
            }
            if (LOGGER.isDebugEnabled()) {
                StringBuffer sb = new StringBuffer();
                sb.append("elapsed " + (System.currentTimeMillis() - start) + " ms");
                LOGGER.debug(sb.toString());
                System.out.println(sb.toString());
            }
        }
    }
}

