/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.font.FontRenderContext;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class RadarChart {
    private static final int MIN_VALUE = 0;
    private static final int MAX_VALUE = 100;
    private static final int IMAGE_WIDTH = 260;
    private static final int IMAGE_HEIGHT = 150;
    private static final Color IMAGE_BGCOLOR = Color.WHITE;
    private static final double CIRCLE_CENTER_X = 130.0;
    private static final double CIRCLE_CENTER_Y = 75.0;
    private static final Point2D CIRCLE_CENTER = new Point2D.Double(130.0, 75.0);
    private static final double CIRCLE_RADIUS = 40.0;
    private static final Color CIRCLE_COLOR = Color.BLACK;
    private static final Color BAR_COLOR = Color.BLACK;
    private static final Color POLYGON_COLOR = new Color(102, 102, 255);
    private static final Color NAMES_COLOR = Color.RED;
    private static final Font NAMES_FONT = new Font("Default", 0, 16);
    private static final FontRenderContext NAMES_FONT_RENDER_CONTEXT = new FontRenderContext(null, true, true);
    private static final int NAMES_MARGIN = 5;
    private BufferedImage bufImage;
    private Graphics2D g2d;
    private int numItems;
    private String[] names;
    private int[] values;
    private Point2D[] valueFullPoints;
    private double[] valueTheta;
    private Point2D[] valuePoints;
    private static final int NUM_GRAD = 4;
    private static final double GRAD_LENGTH = 5.0;
    private boolean smoothing = true;

    public RadarChart(String[] _names, int[] _values) throws Exception {
        this.names = _names;
        this.values = _values;
        this.numItems = this.values.length;
        if (this.numItems != this.names.length) {
            throw new Exception("The numbers of names and values are different with each other.");
        }
        if (this.numItems < 3) {
            throw new Exception("At least three items are needed.");
        }
        int i = 0;
        while (i < this.numItems) {
            if (this.isOutOfRange(this.values[i])) {
                throw new Exception("The " + i + "-th value is out of range: " + this.values[i]);
            }
            ++i;
        }
        this.createChart();
    }

    private boolean isOutOfRange(int _value) {
        return _value < 0 || 100 < _value;
    }

    private Point2D calcPointPolar(double _x, double _y, double _radius, double _theta) {
        double x = _x + _radius * Math.cos(_theta);
        double y = _y - _radius * Math.sin(_theta);
        return new Point2D.Double(x, y);
    }

    private Point2D calcPointPolar(Point2D _p, double _radius, double _theta) {
        return this.calcPointPolar(_p.getX(), _p.getY(), _radius, _theta);
    }

    private void createChart() {
        this.makePoints();
        this.bufImage = new BufferedImage(260, 150, 1);
        this.g2d = this.bufImage.createGraphics();
        this.g2d.setBackground(IMAGE_BGCOLOR);
        if (this.smoothing) {
            BufferedImage sandImage = new BufferedImage(this.bufImage.getWidth() * 2, this.bufImage.getHeight() * 2, 1);
            Graphics2D sandG = sandImage.createGraphics();
            Point2D[] enlargedValuePoints = new Point2D[this.numItems];
            Point2D[] enlargedValueFullPoints = new Point2D[this.numItems];
            int i = 0;
            while (i < this.numItems) {
                Point2D curPoint = this.valuePoints[i];
                enlargedValuePoints[i] = new Point2D.Double(curPoint.getX() * 2.0, curPoint.getY() * 2.0);
                curPoint = this.valueFullPoints[i];
                enlargedValueFullPoints[i] = new Point2D.Double(curPoint.getX() * 2.0, curPoint.getY() * 2.0);
                ++i;
            }
            Point2D.Double enlargedCircleCenter = new Point2D.Double(260.0, 150.0);
            this.fillBackground(sandImage, sandG, IMAGE_BGCOLOR);
            this.drawEllipse(sandG, CIRCLE_COLOR, enlargedCircleCenter, 80.0);
            this.fillPolygon(sandG, POLYGON_COLOR, BAR_COLOR, enlargedValuePoints);
            this.drawBars(sandG, BAR_COLOR, enlargedValueFullPoints, enlargedCircleCenter);
            WritableRaster srcRaster = sandImage.copyData(null);
            DataBufferInt srcBufInt = (DataBufferInt)srcRaster.getDataBuffer();
            int[] srcArray = srcBufInt.getData();
            WritableRaster destRaster = this.bufImage.copyData(null);
            DataBufferInt destBufInt = (DataBufferInt)destRaster.getDataBuffer();
            int[] destArray = destBufInt.getData();
            float[][] fImageR = new float[151][261];
            float[][] fImageG = new float[151][261];
            float[][] fImageB = new float[151][261];
            int j = 0;
            while (j < 150) {
                int i2 = 0;
                while (i2 < 260) {
                    int nwIndex = 4 * j * 260 + i2 * 2;
                    int nw = srcArray[nwIndex];
                    int nwR = nw >> 16 & 0xFF;
                    int nwG = nw >> 8 & 0xFF;
                    int nwB = nw & 0xFF;
                    int ne = srcArray[nwIndex + 1];
                    int neR = ne >> 16 & 0xFF;
                    int neG = ne >> 8 & 0xFF;
                    int neB = ne & 0xFF;
                    int sw = srcArray[nwIndex + 520];
                    int swR = sw >> 16 & 0xFF;
                    int swG = sw >> 8 & 0xFF;
                    int swB = sw & 0xFF;
                    int se = srcArray[nwIndex + 520 + 1];
                    int seR = se >> 16 & 0xFF;
                    int seG = se >> 8 & 0xFF;
                    int seB = se & 0xFF;
                    fImageR[j][i2] = (float)(nwR + neR + swR + seR) / 4.0f;
                    fImageG[j][i2] = (float)(nwG + neG + swG + seG) / 4.0f;
                    fImageB[j][i2] = (float)(nwB + neB + swB + seB) / 4.0f;
                    ++i2;
                }
                ++j;
            }
            int k = 0;
            int j2 = 0;
            while (j2 < 150) {
                int i3 = 0;
                while (i3 < 260) {
                    int newR = Math.round(fImageR[j2][i3]);
                    if (newR < 0) {
                        newR = 0;
                    } else if (255 < newR) {
                        newR = 255;
                    }
                    float errR = fImageR[j2][i3] - (float)newR;
                    float[] fArray = fImageR[j2];
                    int n = i3 + 1;
                    fArray[n] = fArray[n] + errR * 0.375f;
                    float[] fArray2 = fImageR[j2 + 1];
                    int n2 = i3;
                    fArray2[n2] = fArray2[n2] + errR * 0.375f;
                    float[] fArray3 = fImageR[j2 + 1];
                    int n3 = i3 + 1;
                    fArray3[n3] = fArray3[n3] + errR * 0.25f;
                    int newG = Math.round(fImageG[j2][i3]);
                    if (newG < 0) {
                        newG = 0;
                    } else if (255 < newG) {
                        newG = 255;
                    }
                    float errG = fImageG[j2][i3] - (float)newG;
                    float[] fArray4 = fImageG[j2];
                    int n4 = i3 + 1;
                    fArray4[n4] = fArray4[n4] + errG * 0.375f;
                    float[] fArray5 = fImageG[j2 + 1];
                    int n5 = i3;
                    fArray5[n5] = fArray5[n5] + errG * 0.375f;
                    float[] fArray6 = fImageG[j2 + 1];
                    int n6 = i3 + 1;
                    fArray6[n6] = fArray6[n6] + errG * 0.25f;
                    int newB = Math.round(fImageB[j2][i3]);
                    if (newB < 0) {
                        newB = 0;
                    } else if (255 < newB) {
                        newB = 255;
                    }
                    float errB = fImageB[j2][i3] - (float)newB;
                    float[] fArray7 = fImageB[j2];
                    int n7 = i3 + 1;
                    fArray7[n7] = fArray7[n7] + errB * 0.375f;
                    float[] fArray8 = fImageB[j2 + 1];
                    int n8 = i3;
                    fArray8[n8] = fArray8[n8] + errB * 0.375f;
                    float[] fArray9 = fImageB[j2 + 1];
                    int n9 = i3 + 1;
                    fArray9[n9] = fArray9[n9] + errB * 0.25f;
                    destArray[k] = newR << 16 | newG << 8 | newB;
                    ++k;
                    ++i3;
                }
                ++j2;
            }
            this.bufImage.setData(destRaster);
        } else {
            this.fillBackground(this.bufImage, this.g2d, IMAGE_BGCOLOR);
            this.drawEllipse(this.g2d, CIRCLE_COLOR, CIRCLE_CENTER, 40.0);
            this.fillPolygon(this.g2d, POLYGON_COLOR, BAR_COLOR, this.valuePoints);
            this.drawBars(this.g2d, BAR_COLOR, this.valueFullPoints, CIRCLE_CENTER);
        }
        this.drawNames(this.g2d, NAMES_COLOR);
    }

    private void makePoints() {
        this.valueFullPoints = new Point2D[this.numItems];
        this.valueTheta = new double[this.numItems];
        this.valuePoints = new Point2D[this.numItems];
        double theta = Math.PI * 2 / (double)this.numItems;
        double startTheta = 1.5707963267948966;
        int i = 0;
        while (i < this.numItems) {
            this.valueTheta[i] = startTheta + (double)i * theta;
            this.valueFullPoints[i] = this.calcPointPolar(130.0, 75.0, 40.0, this.valueTheta[i]);
            double ratio = (double)this.values[i] / 100.0;
            this.valuePoints[i] = new Point2D.Double(130.0 * (1.0 - ratio) + this.valueFullPoints[i].getX() * ratio, 75.0 * (1.0 - ratio) + this.valueFullPoints[i].getY() * ratio);
            ++i;
        }
    }

    private void fillBackground(BufferedImage _bufIm, Graphics2D _g2d, Color _c) {
        Paint curPaint = _g2d.getPaint();
        _g2d.setPaint(_c);
        Rectangle2D.Double r2d = new Rectangle2D.Double(0.0, 0.0, _bufIm.getWidth(), _bufIm.getHeight());
        _g2d.fill(r2d);
        _g2d.setPaint(curPaint);
    }

    private void drawEllipse(Graphics2D _g2d, Color _c, Point2D _center, double _r) {
        Paint curPaint = _g2d.getPaint();
        _g2d.setPaint(_c);
        double boundaryX = _center.getX() - _r;
        double boundaryY = _center.getY() - _r;
        double boundaryW = _r * 2.0;
        Ellipse2D.Double e2d = new Ellipse2D.Double(boundaryX, boundaryY, boundaryW, boundaryW);
        _g2d.draw(e2d);
        _g2d.setPaint(curPaint);
    }

    private void fillPolygon(Graphics2D _g2d, Color _fill, Color _contour, Point2D[] _points) {
        Paint curPaint = _g2d.getPaint();
        int[] xpoints = new int[this.numItems];
        int[] ypoints = new int[this.numItems];
        int i = 0;
        while (i < this.numItems) {
            xpoints[i] = (int)_points[i].getX();
            ypoints[i] = (int)_points[i].getY();
            ++i;
        }
        Polygon pol = new Polygon(xpoints, ypoints, this.numItems);
        _g2d.setPaint(_fill);
        _g2d.fill(pol);
        _g2d.setPaint(_contour);
        Line2D.Double l2d = new Line2D.Double(_points[this.numItems - 1], _points[0]);
        _g2d.draw(l2d);
        int i2 = 0;
        while (i2 < this.numItems - 1) {
            l2d = new Line2D.Double(_points[i2], _points[i2 + 1]);
            _g2d.draw(l2d);
            ++i2;
        }
        _g2d.setPaint(curPaint);
    }

    private void drawBars(Graphics2D _g2d, Color _c, Point2D[] _points, Point2D _circleCenter) {
        double circleCenterX = _circleCenter.getX();
        double circleCenterY = _circleCenter.getY();
        Paint curPaint = _g2d.getPaint();
        _g2d.setPaint(_c);
        int i = 0;
        while (i < this.numItems) {
            double fullX = _points[i].getX();
            double fullY = _points[i].getY();
            Line2D.Double l2d = new Line2D.Double(circleCenterX, circleCenterY, fullX, fullY);
            _g2d.draw(l2d);
            int j = 1;
            while (j < 4) {
                double ratio = (double)j / 4.0;
                Point2D.Double gradCenter = new Point2D.Double(circleCenterX * (1.0 - ratio) + fullX * ratio, circleCenterY * (1.0 - ratio) + fullY * ratio);
                Point2D grad0 = this.calcPointPolar(gradCenter, 5.0, this.valueTheta[i] + 1.5707963267948966);
                Point2D grad1 = this.calcPointPolar(gradCenter, 5.0, this.valueTheta[i] - 1.5707963267948966);
                l2d = new Line2D.Double(grad0, grad1);
                _g2d.draw(l2d);
                ++j;
            }
            ++i;
        }
        _g2d.setPaint(curPaint);
    }

    private void drawNames(Graphics2D _g2d, Color _c) {
        Paint curPaint = _g2d.getPaint();
        _g2d.setPaint(_c);
        _g2d.setFont(NAMES_FONT);
        int i = 0;
        while (i < this.numItems) {
            Rectangle2D boundaryBox = NAMES_FONT.getStringBounds(this.names[i], NAMES_FONT_RENDER_CONTEXT);
            double stringWidth = boundaryBox.getWidth();
            double stringHeight = boundaryBox.getHeight();
            double fullX = this.valueFullPoints[i].getX();
            double fullY = this.valueFullPoints[i].getY();
            float x = 0.0f;
            float y = 0.0f;
            if (fullX < 130.0) {
                x = (float)(fullX - stringWidth - 5.0);
                y = (float)(fullY + stringHeight / 2.0);
            } else if (130.0 < fullX) {
                x = (float)(fullX + 5.0);
                y = (float)(fullY + stringHeight / 2.0);
            } else {
                x = (float)(fullX - stringWidth / 2.0);
                y = fullY < 75.0 ? (float)(fullY - 5.0) : (float)(fullY + stringHeight + 5.0);
            }
            _g2d.drawString(this.names[i], x, y);
            ++i;
        }
        _g2d.setPaint(curPaint);
    }

    public BufferedImage getBufferedImage() {
        return this.bufImage;
    }

    public void writeToPNG(File target) throws IOException {
        ImageIO.write((RenderedImage)this.bufImage, "PNG", target);
    }
}

