/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.util;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Display;

public class ImageOverlayUtil {
    public static final PaletteData PALETTE = new PaletteData(255, 65280, 0xFF0000);

    public static boolean overlay(Image base, Image overlay) {
        GC gc;
        block3: {
            try {
                gc = new GC((Drawable)base);
                if (overlay != null && !overlay.isDisposed()) break block3;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        gc.drawImage(overlay, 0, 0);
        gc.dispose();
        return true;
    }

    public static boolean overlay(Image base, int[][] pixels, int alpha) {
        try {
            int width = pixels[0].length;
            int height = pixels.length;
            ImageData overlayData = new ImageData(width, height, 24, PALETTE);
            overlayData.alpha = alpha;
            int y = 0;
            while (y < height) {
                overlayData.setPixels(0, y, width, pixels[y], 0);
                ++y;
            }
            Image overlayImage = new Image((Device)Display.getDefault(), overlayData);
            boolean result = ImageOverlayUtil.overlay(base, overlayImage);
            overlayImage.dispose();
            return result;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean overlay(Image base, int width, int[] pixels, int alpha) {
        try {
            int height = pixels.length / width;
            ImageData overlayData = new ImageData(width, height, 24, PALETTE);
            overlayData.alpha = alpha;
            int y = 0;
            while (y < height) {
                overlayData.setPixels(0, y, width, pixels, width * y);
                ++y;
            }
            Image overlayImage = new Image((Device)Display.getDefault(), overlayData);
            boolean result = ImageOverlayUtil.overlay(base, overlayImage);
            overlayImage.dispose();
            return result;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

