/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.lowvision.util;

import org.eclipse.actf.visualization.engines.lowvision.LowVisionType;
import org.eclipse.actf.visualization.lowvision.ui.internal.Messages;

public class ParamLowVision {
    private static ParamLowVision INSTANCE;
    private boolean oEyeSight = true;
    private int iCurEyeSightValue = (int)Math.rint(50.0);
    private boolean oColorVision = true;
    private int iCurColorVisionValue = 2;
    private boolean oColorFilter = true;
    private int iCurColorFilterValue = (int)Math.rint(80.0);
    private LowVisionType lowVisionType = new LowVisionType();
    private static final double DEFAULT_EYESIGHT_DEGREE = 0.5;
    private static final int DEFAULT_CVD_TYPE = 2;
    private static final double DEFAULT_COLOR_FILTER = 0.8;

    public static ParamLowVision getDefaultInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ParamLowVision();
        }
        return INSTANCE;
    }

    public LowVisionType getLowVisionType() {
        try {
            this.lowVisionType.setEyesight(this.oEyeSight);
            if (this.oEyeSight) {
                float fEyeSight = (float)this.iCurEyeSightValue / 100.0f;
                this.lowVisionType.setEyesightDegree(fEyeSight);
            }
            this.lowVisionType.setCVD(this.oColorVision);
            if (this.oColorVision) {
                this.lowVisionType.setCVDType(this.iCurColorVisionValue);
            }
            this.lowVisionType.setColorFilter(this.oColorFilter);
            if (this.oColorFilter) {
                this.lowVisionType.setColorFilterDegree((float)this.iCurColorFilterValue / 100.0f);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.lowVisionType;
    }

    public Object clone() {
        ParamLowVision tmpParam = new ParamLowVision();
        tmpParam.setColorFilterValue(this.iCurColorFilterValue);
        tmpParam.setColorVisionValue(this.iCurColorVisionValue);
        tmpParam.setEyeSightValue(this.iCurEyeSightValue);
        tmpParam.setColorFilter(this.oColorFilter);
        tmpParam.setColorVision(this.oColorVision);
        tmpParam.setEyeSight(this.oEyeSight);
        return tmpParam;
    }

    public int getColorFilterValue() {
        return this.iCurColorFilterValue;
    }

    public int getColorVisionValue() {
        return this.iCurColorVisionValue;
    }

    public int getEyeSightValue() {
        return this.iCurEyeSightValue;
    }

    public boolean useColorFilter() {
        return this.oColorFilter;
    }

    public boolean useColorVision() {
        return this.oColorVision;
    }

    public boolean useEyeSight() {
        return this.oEyeSight;
    }

    public void setColorFilterValue(int i) {
        this.iCurColorFilterValue = i;
    }

    public void setColorVisionValue(int i) {
        this.iCurColorVisionValue = i;
    }

    public void setEyeSightValue(int i) {
        this.iCurEyeSightValue = i;
    }

    public void setColorFilter(boolean b) {
        this.oColorFilter = b;
    }

    public void setColorVision(boolean b) {
        this.oColorVision = b;
    }

    public void setEyeSight(boolean b) {
        this.oEyeSight = b;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(" ");
        if (this.useEyeSight()) {
            result.append(String.valueOf(Messages.ParamLowVision_1) + " " + (float)this.getEyeSightValue() / 100.0f + "  ");
        }
        if (this.useColorVision()) {
            result.append(String.valueOf(Messages.ParamLowVision_4) + " " + this.getColorVisionValue() + "  ");
        }
        if (this.useColorFilter()) {
            result.append(String.valueOf(Messages.ParamLowVision_7) + " " + (float)this.getColorFilterValue() / 100.0f + "  ");
        }
        return result.toString();
    }
}

