/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.sgml.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.actf.model.dom.html.IErrorHandler;
import org.eclipse.actf.model.internal.dom.sgml.util.IErrorHandlerTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorHandlerTableImpl
extends Hashtable<URL, IErrorHandler[]>
implements IErrorHandlerTable {
    private static final long serialVersionUID = -5122037603773966517L;
    private String[] errorHandlerNameArray = new String[128];

    public ErrorHandlerTableImpl() {
        this.init();
    }

    private void init() {
        Properties prop = new Properties();
        try {
            prop.load(this.getClass().getResourceAsStream("errorhandlers.properties"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Enumeration<Object> e = prop.keys();
        while (e.hasMoreElements()) {
            URL url;
            String urlStr = (String)e.nextElement();
            try {
                url = new URL(urlStr);
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
                continue;
            }
            this.put(url, this.createErrorHandlers((String)prop.get(urlStr)));
        }
    }

    private IErrorHandler[] createErrorHandlers(String errorHandlerNames) {
        int lastComma = 0;
        int errorHandlerNum = 0;
        int i = 0;
        while (i < errorHandlerNames.length()) {
            if (errorHandlerNames.charAt(i) == ',') {
                this.errorHandlerNameArray[errorHandlerNum++] = errorHandlerNames.substring(lastComma, i);
                lastComma = i + 1;
            }
            ++i;
        }
        this.errorHandlerNameArray[errorHandlerNum++] = errorHandlerNames.substring(lastComma);
        IErrorHandler[] ret = new IErrorHandler[errorHandlerNum];
        int i2 = 0;
        while (i2 < errorHandlerNum) {
            try {
                Class<?> errorHandlerClass = Class.forName(this.errorHandlerNameArray[i2]);
                ret[i2] = (IErrorHandler)errorHandlerClass.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i2;
        }
        return ret;
    }

    @Override
    public IErrorHandler[] getErrorHandlers(URL url) {
        return (IErrorHandler[])this.get(url);
    }
}

