/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.sgml.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import org.eclipse.actf.model.dom.html.ParseException;
import org.eclipse.actf.model.internal.dom.sgml.ISGMLConstants;

abstract class SGMLTokenizer
implements ISGMLConstants {
    protected LineNumberReader reader;
    public String sval;
    public int ttype;
    protected int state = 0;
    protected boolean pushBacked;
    protected int[] charBuffer = new int[1024];
    public static final int BUF_SIZ = 1024;
    protected int index = 0;

    public BufferedReader getReader() {
        return this.reader;
    }

    public SGMLTokenizer(Reader reader) {
        this(reader, 0);
    }

    SGMLTokenizer(Reader reader, int state) {
        this.reader = reader instanceof LineNumberReader ? (LineNumberReader)reader : new LineNumberReader(reader);
        this.state = state;
        this.pushBacked = false;
    }

    protected abstract int defaultState() throws IOException, ParseException;

    public final int getCurrentLine() {
        return this.reader.getLineNumber() + 1;
    }

    public final int nextToken() throws IOException, ParseException {
        if (this.pushBacked) {
            this.pushBacked = false;
            return this.ttype;
        }
        switch (this.state) {
            case 0: {
                return this.defaultState();
            }
            case 1: {
                return this.tag();
            }
        }
        return -1;
    }

    public final void pushBack() {
        this.pushBacked = true;
    }

    protected final int read() throws IOException {
        if (this.index > 0) {
            return this.charBuffer[--this.index];
        }
        return this.reader.read();
    }

    protected final void unread(int ch) {
        this.charBuffer[this.index++] = ch;
    }

    final void switchTo(int state) {
        this.state = state;
    }

    protected abstract int tag() throws ParseException, IOException;

    final void close() throws IOException {
        this.reader.close();
    }
}

