/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.sgml.impl;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.actf.model.dom.html.ParseException;
import org.eclipse.actf.model.internal.dom.sgml.ISGMLConstants;
import org.eclipse.actf.model.internal.dom.sgml.impl.AttributeDefinition;
import org.eclipse.actf.model.internal.dom.sgml.impl.ElementDefinition;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLParser;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

class InsTokenizer
implements ISGMLConstants,
Locator {
    private boolean extractChar = true;
    private boolean extractNum = true;
    private int state;
    private boolean pushBacked;
    public String sval;
    public int ttype;
    private Reader reader;
    private SGMLParser parser;
    private int etagStartIndex;
    private int[] entityBuf = new int[64];
    private int entityBufIndex;
    private char[] endTagBuffer = new char[64];
    private int endTagBufferIndex = 0;
    private char[] attrValBuffer = new char[8192];
    private boolean prsvWS = false;
    private int index = 0;
    private char[] charBuffer = new char[8192];
    public static final int INITIAL_BUF_SIZ = 8192;
    public static final int READ_UNIT = 1024;
    private int bufLimit = 0;
    private char[] miscBuffer = new char[8192];
    private int miscIndex = 0;
    private boolean skipLF;
    private int lastLFindex = -1;
    private int lineNumber = 0;

    void extractCharEntity(boolean b) {
        this.extractChar = b;
    }

    void extractNumEntity(boolean b) {
        this.extractNum = b;
    }

    public InsTokenizer(Reader reader, SGMLParser parser) {
        this(reader, 0, parser);
    }

    InsTokenizer(Reader reader, int state, SGMLParser parser) {
        this.reader = reader;
        this.state = state;
        this.parser = parser;
        this.pushBacked = false;
    }

    private boolean forward(String str, boolean ignoreCase) throws IOException {
        int i;
        int[] buf = new int[str.length()];
        boolean ret = true;
        if (!ignoreCase) {
            i = 0;
            while (i < buf.length) {
                buf[i] = this.read();
                if (buf[i] != str.charAt(i)) {
                    ret = false;
                    ++i;
                    break;
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < buf.length) {
                buf[i] = this.read();
                if (Character.toUpperCase((char)buf[i]) != Character.toUpperCase(str.charAt(i)) && Character.toLowerCase((char)buf[i]) != Character.toLowerCase(str.charAt(i))) {
                    ret = false;
                    ++i;
                    break;
                }
                ++i;
            }
        }
        while (i > 0) {
            this.unread(buf[--i]);
        }
        return ret;
    }

    private int eatComment() throws IOException, ParseException {
        this.miscIndex = 0;
        int ch = this.read();
        if (ch == 45) {
            ch = this.read();
            if (ch == 45) {
                while (true) {
                    if ((ch = this.read()) != 45 && ch != -1) {
                        this.setCharToMiscBuffer(this.miscIndex, (char)ch);
                        ++this.miscIndex;
                        continue;
                    }
                    ch = this.read();
                    if (ch == 45) {
                        ch = this.read();
                        if (ch == 45) {
                            if (this.miscBuffer.length <= this.miscIndex + 2) {
                                this.expandMiscBuffer();
                            }
                            this.miscBuffer[this.miscIndex + 2] = 45;
                            this.miscBuffer[this.miscIndex + 1] = 45;
                            this.miscBuffer[this.miscIndex] = 45;
                            this.miscIndex += 3;
                            this.storeUntil('>');
                            if (Character.isWhitespace(this.miscBuffer[this.miscIndex - 1]) || this.miscBuffer[this.miscIndex - 1] == '-' || this.miscBuffer[this.miscIndex - 1] == '!') {
                                if (this.miscBuffer[this.miscIndex - 2] == '-' && this.miscBuffer[this.miscIndex - 1] == '-') {
                                    this.miscIndex -= 2;
                                }
                                this.state = 0;
                                this.sval = new String(this.miscBuffer, 0, this.miscIndex);
                                this.parser.setCharacter(this.miscBuffer, 0, this.miscIndex);
                                this.ttype = 13;
                                return 13;
                            }
                            this.setCharToMiscBuffer(this.miscIndex, '>');
                            ++this.miscIndex;
                            continue;
                        }
                        if (ch == 33) {
                            ch = this.read();
                            if (ch == 62) {
                                this.state = 0;
                                this.sval = new String(this.miscBuffer, 0, this.miscIndex);
                                this.parser.setCharacter(this.miscBuffer, 0, this.miscIndex);
                                this.ttype = 13;
                                return 13;
                            }
                            if (this.miscBuffer.length <= this.miscIndex + 2) {
                                this.expandMiscBuffer();
                            }
                            this.miscBuffer[this.miscIndex + 1] = 45;
                            this.miscBuffer[this.miscIndex] = 45;
                            this.miscBuffer[this.miscIndex + 2] = 33;
                            this.miscIndex += 3;
                            this.unread(ch);
                            continue;
                        }
                        int wsIndex = 0;
                        char[] ws = null;
                        if (Character.isWhitespace((char)ch)) {
                            ws = new char[256];
                            ws[0] = (char)ch;
                            ws[1] = '\u0001';
                            while (Character.isWhitespace((char)ch)) {
                                if (ch == ws[wsIndex]) {
                                    int n = wsIndex + 1;
                                    ws[n] = (char)(ws[n] + '\u0001');
                                } else {
                                    ws[wsIndex += 2] = (char)ch;
                                    ws[wsIndex + 1] = '\u0001';
                                }
                                ch = this.read();
                            }
                        }
                        if (ch == 62) {
                            this.state = 0;
                            this.sval = new String(this.miscBuffer, 0, this.miscIndex);
                            this.parser.setCharacter(this.miscBuffer, 0, this.miscIndex);
                            this.ttype = 13;
                            return 13;
                        }
                        if (this.miscBuffer.length <= this.miscIndex + 2) {
                            this.expandMiscBuffer();
                        }
                        this.miscBuffer[this.miscIndex + 1] = 45;
                        this.miscBuffer[this.miscIndex] = 45;
                        this.miscIndex += 2;
                        int i = 0;
                        while (i < wsIndex) {
                            int j = 0;
                            while (j < ws[i + 1]) {
                                this.setCharToMiscBuffer(this.miscIndex, ws[i]);
                                ++j;
                            }
                            ++this.miscIndex;
                            i += 2;
                        }
                        this.unread(ch);
                        continue;
                    }
                    if (ch == -1) {
                        this.parser.error(10, "Unexpected EOF in comment.");
                        int i = 0;
                        while (i < this.miscBuffer.length) {
                            if (this.miscBuffer[i] == '>') {
                                this.unread(this.miscBuffer, i + 1, this.miscIndex - i - 1);
                                this.state = 0;
                                this.sval = new String(this.miscBuffer, 0, i);
                                this.parser.setCharacter(this.miscBuffer, 0, this.miscIndex);
                                this.ttype = 13;
                                return 13;
                            }
                            ++i;
                        }
                        throw new ParseException("Unexpected EOF in comment.");
                    }
                    this.setCharToMiscBuffer(this.miscIndex, '-');
                    ++this.miscIndex;
                    this.setCharToMiscBuffer(this.miscIndex, (char)ch);
                    ++this.miscIndex;
                }
            }
            this.sval = "-" + (char)ch + this.eatUntil('>');
            char[] svalChar = this.sval.toCharArray();
            this.parser.setCharacter(svalChar, 0, svalChar.length);
            this.ttype = 13;
            return 13;
        }
        if ((ch == 68 || ch == 100) && this.forward("OCTYPE", true)) {
            this.unread(ch);
            this.state = 1;
            this.ttype = 1;
            return 1;
        }
        this.sval = String.valueOf((char)ch) + this.eatUntil('>');
        char[] svalChar = this.sval.toCharArray();
        this.parser.setCharacter(svalChar, 0, svalChar.length);
        this.ttype = 13;
        return 13;
    }

    private int defaultState() throws IOException, ParseException, SAXException {
        this.miscIndex = 0;
        int ch = this.read();
        while (Character.isWhitespace((char)ch)) {
            this.addCharToMiscBuffer((char)ch);
            ch = this.read();
        }
        if (this.miscIndex > 0 && this.prsvWS) {
            this.unread(ch);
            this.sval = new String(this.miscBuffer, 0, this.miscIndex);
            this.parser.setCharacter(this.miscBuffer, 0, this.miscIndex);
            this.ttype = 15;
            return 15;
        }
        switch (ch) {
            case 60: {
                DocumentHandler docHandler;
                if (this.miscIndex > 0 && !this.prsvWS && (docHandler = this.parser.getDocumentHandler()) != null) {
                    this.unread(ch);
                    docHandler.ignorableWhitespace(this.miscBuffer, 0, this.miscIndex);
                    this.read();
                }
                this.miscIndex = 0;
                ch = this.read();
                if (ch == 47) {
                    ch = this.read();
                    if (Character.isLowerCase((char)ch) || Character.isUpperCase((char)ch)) {
                        this.unread(ch);
                        this.state = 2;
                        this.etagStartIndex = this.miscIndex;
                        this.addCharToMiscBuffer('<');
                        this.addCharToMiscBuffer('/');
                        this.ttype = 8;
                        return 8;
                    }
                    this.addCharToMiscBuffer('<');
                    this.addCharToMiscBuffer('/');
                    return this.readPCDATA(ch);
                }
                if (ch == 63) {
                    this.miscIndex = 0;
                    while ((ch = this.read()) != 62 && ch != -1) {
                        this.addCharToMiscBuffer((char)ch);
                    }
                    this.sval = new String(this.miscBuffer, 0, this.miscIndex);
                    this.ttype = 17;
                    return 17;
                }
                if (ch == 33) {
                    return this.eatComment();
                }
                if (Character.isLowerCase((char)ch) || Character.isUpperCase((char)ch)) {
                    this.unread(ch);
                    this.state = 1;
                    this.ttype = 60;
                    return 60;
                }
                this.addCharToMiscBuffer('<');
                return this.readPCDATA(ch);
            }
            case -1: {
                this.ttype = -1;
                return -1;
            }
        }
        return this.readPCDATA(ch);
    }

    private int rslvCharEnt() throws IOException, ParseException, SAXException {
        this.entityBufIndex = 0;
        this.entityBuf[this.entityBufIndex++] = this.read();
        int ch = this.entityBuf[this.entityBufIndex++];
        if (ch == 35) {
            int k;
            int n = this.read();
            this.entityBuf[this.entityBufIndex++] = n;
            ch = n;
            int radix = 10;
            if (ch == 120 || ch == 88) {
                radix = 16;
                int n2 = this.read();
                this.entityBuf[this.entityBufIndex++] = n2;
                ch = n2;
            }
            if ((k = Character.digit((char)ch, radix)) >= 0) {
                int num = k;
                int n3 = this.read();
                this.entityBuf[this.entityBufIndex++] = n3;
                ch = n3;
                while ((k = Character.digit((char)ch, radix)) >= 0) {
                    num = num * radix + k;
                    int n4 = this.read();
                    this.entityBuf[this.entityBufIndex++] = n4;
                    ch = n4;
                }
                if (ch == 59) {
                    char[] orig = new char[this.entityBufIndex - 1];
                    int i = 0;
                    while (i < this.entityBufIndex - 1) {
                        orig[i] = (char)this.entityBuf[i];
                        ++i;
                    }
                    this.parser.putCharNumEntity(new Character((char)num), new String(orig));
                    return num;
                }
            }
        } else if (Character.isLowerCase((char)ch) || Character.isUpperCase((char)ch)) {
            while (Character.isLowerCase((char)(ch = (this.entityBuf[this.entityBufIndex++] = this.read()))) || Character.isUpperCase((char)ch)) {
            }
            if (ch == 59) {
                char[] orig = new char[this.entityBufIndex - 1];
                int i = 0;
                while (i < this.entityBufIndex - 1) {
                    orig[i] = (char)this.entityBuf[i];
                    ++i;
                }
                String orgStr = new String(orig);
                int charEntity = this.parser.getCharEntity(orgStr);
                if (charEntity != -1) {
                    this.parser.putCharNumEntity(new Character((char)charEntity), orgStr);
                    return charEntity;
                }
            }
        }
        int i = this.entityBufIndex - 1;
        while (i >= 0) {
            this.unread(this.entityBuf[i]);
            --i;
        }
        return -1;
    }

    private void setCharToMiscBuffer(int miscIndex, char c) {
        if (this.miscBuffer.length <= miscIndex) {
            this.expandMiscBuffer();
        }
        this.miscBuffer[miscIndex] = c;
    }

    private void addCharToMiscBuffer(char c) {
        if (this.miscBuffer.length <= this.miscIndex) {
            this.expandMiscBuffer();
        }
        this.miscBuffer[this.miscIndex++] = c;
    }

    private int readPCDATA(int cur) throws IOException, ParseException, SAXException {
        int succeeding;
        int firstLFindex = this.lastLFindex;
        if (!this.extractChar && !this.extractNum) {
            this.setCharToMiscBuffer(this.miscIndex, (char)cur);
            ++this.miscIndex;
            while (!((cur = this.read()) == 60 && (Character.isLowerCase((char)(succeeding = this.sence())) || Character.isUpperCase((char)succeeding) || succeeding == 33 || succeeding == 63 || succeeding == 47 && (Character.isLowerCase((char)(succeeding = this.sence(1))) || Character.isUpperCase((char)succeeding))) || cur == -1)) {
                this.setCharToMiscBuffer(this.miscIndex, (char)cur);
                if (this.miscBuffer[this.miscIndex - 1] == '\n' && cur != 10) {
                    firstLFindex = this.index - 1;
                }
                ++this.miscIndex;
            }
        } else if (cur != -1) {
            do {
                if (cur == 38) {
                    int charEntity;
                    if (!this.extractNum) {
                        cur = this.read();
                        if (cur == 35) {
                            this.addCharToMiscBuffer('&');
                            this.addCharToMiscBuffer('#');
                            continue;
                        }
                        this.unread(cur);
                    }
                    if ((charEntity = this.rslvCharEnt()) == -1) {
                        this.addCharToMiscBuffer('&');
                        continue;
                    }
                    this.addCharToMiscBuffer((char)charEntity);
                    continue;
                }
                this.setCharToMiscBuffer(this.miscIndex, (char)cur);
                if (this.miscIndex > 0 && this.miscBuffer[this.miscIndex - 1] == '\n' && cur != 10) {
                    firstLFindex = this.index - 2;
                }
                ++this.miscIndex;
            } while (((cur = this.read()) != 60 || !Character.isLowerCase((char)(succeeding = this.sence())) && !Character.isUpperCase((char)succeeding) && succeeding != 33 && succeeding != 63 && (succeeding != 47 || !Character.isLowerCase((char)(succeeding = this.sence(1))) && !Character.isUpperCase((char)succeeding))) && cur != -1);
        }
        if (cur != -1) {
            this.unread(cur);
        }
        if (!this.prsvWS) {
            int begin = 0;
            while ((cur = this.miscBuffer[begin]) == 13 || cur == 10) {
                ++begin;
            }
            int end = this.miscIndex - 1;
            try {
                while ((cur = this.miscBuffer[end]) == 13 || cur == 10) {
                    --end;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.sval = new String(this.miscBuffer, 0, this.miscIndex);
                this.parser.setCharacter(this.miscBuffer, 0, this.miscIndex);
                this.ttype = 14;
                return 14;
            }
            int len = end + 1 - begin;
            this.sval = new String(this.miscBuffer, begin, len);
            this.parser.setCharacter(this.miscBuffer, begin, len);
            if (end != this.miscIndex - 1) {
                this.unread(this.miscBuffer, end + 1, this.miscIndex - end - 1);
                this.lastLFindex = firstLFindex;
            }
        } else {
            this.sval = new String(this.miscBuffer, 0, this.miscIndex);
            this.parser.setCharacter(this.miscBuffer, 0, this.miscIndex);
            this.ttype = 15;
            return 15;
        }
        this.ttype = 14;
        return 14;
    }

    final String rawText(String end) throws IOException, ParseException {
        char[] endTagArray = end.toUpperCase().toCharArray();
        this.miscIndex = 0;
        int limitCandidate = 0;
        boolean inComment = false;
        block0: while (true) {
            int ch = this.read();
            if (!inComment && ch == 60) {
                ch = this.read();
                if (ch == 47) {
                    if (limitCandidate == 0) {
                        limitCandidate = this.miscIndex;
                    }
                    this.endTagBufferIndex = 0;
                    int i = 0;
                    while (i < end.length()) {
                        this.endTagBuffer[this.endTagBufferIndex] = (char)this.read();
                        if ((this.endTagBuffer[this.endTagBufferIndex] & 0xFFDF) == endTagArray[this.endTagBufferIndex]) {
                            ++this.endTagBufferIndex;
                        } else {
                            ++this.endTagBufferIndex;
                            this.addCharToMiscBuffer('<');
                            this.addCharToMiscBuffer('/');
                            int j = 0;
                            while (true) {
                                if (j >= this.endTagBufferIndex) continue block0;
                                this.addCharToMiscBuffer(this.endTagBuffer[j]);
                                ++j;
                            }
                        }
                        ++i;
                    }
                    while (Character.isWhitespace((char)(ch = this.read()))) {
                        this.endTagBuffer[this.endTagBufferIndex++] = (char)ch;
                    }
                    if (ch == 62) {
                        this.endTagBufferIndex += 3;
                        this.unread(this.endTagBuffer, 0, this.endTagBufferIndex);
                        return new String(this.miscBuffer, 0, this.miscIndex);
                    }
                    this.endTagBuffer[this.endTagBufferIndex++] = (char)ch;
                    this.addCharToMiscBuffer('<');
                    this.addCharToMiscBuffer('/');
                    i = 0;
                    while (true) {
                        if (i >= this.endTagBufferIndex) continue block0;
                        this.addCharToMiscBuffer(this.endTagBuffer[i]);
                        ++i;
                    }
                }
                if (ch == 33) {
                    this.addCharToMiscBuffer('<');
                    this.addCharToMiscBuffer((char)ch);
                    ch = this.read();
                    this.addCharToMiscBuffer((char)ch);
                    if (ch != 45) continue;
                    ch = this.read();
                    this.addCharToMiscBuffer((char)ch);
                    if (ch != 45) continue;
                    inComment = true;
                    continue;
                }
                this.addCharToMiscBuffer('<');
                this.addCharToMiscBuffer((char)ch);
                continue;
            }
            if (ch == -1) {
                this.parser.error(10, "Unexpected EOF in CDATA after " + end);
                this.endTagBufferIndex = 0;
                if (limitCandidate != 0) {
                    this.unread(this.miscBuffer, limitCandidate, this.miscIndex - limitCandidate);
                    return new String(this.miscBuffer, 0, limitCandidate);
                }
                return new String(this.miscBuffer, 0, this.miscIndex);
            }
            if (inComment && ch == 45) {
                this.addCharToMiscBuffer((char)ch);
                ch = this.read();
                this.addCharToMiscBuffer((char)ch);
                if (ch != 45) continue;
                ch = this.read();
                this.addCharToMiscBuffer((char)ch);
                if (ch != 62) continue;
                inComment = false;
                continue;
            }
            this.addCharToMiscBuffer((char)ch);
        }
    }

    void eatCDATAEndTag() throws IOException {
        int i = this.endTagBufferIndex;
        while (i > 0) {
            this.read();
            --i;
        }
    }

    private static boolean includeAngleBracket(char[] chars, int begin, int end) {
        while (begin < end) {
            char ch;
            if ((ch = chars[begin++]) != '>' && ch != '<') continue;
            return true;
        }
        return false;
    }

    private void checkAttrValBuffer(int index) {
        int curSize = this.attrValBuffer.length;
        if (curSize < index + 128) {
            char[] tmpBuffer = new char[curSize + 8192];
            System.arraycopy(this.attrValBuffer, 0, tmpBuffer, 0, curSize);
            this.attrValBuffer = tmpBuffer;
        }
    }

    final String readAttributeValue(AttributeDefinition ad, ElementDefinition ed) throws IOException, ParseException, SAXException {
        int ch;
        while (Character.isWhitespace((char)(ch = this.read()))) {
        }
        this.miscIndex = 0;
        int attrValBufferIndex = 0;
        this.addCharToMiscBuffer((char)ch);
        if (ch == 39 || ch == 34) {
            int endChar = ch;
            while ((ch = this.read()) != -1 && ch != endChar) {
                this.checkAttrValBuffer(attrValBufferIndex);
                this.setCharToMiscBuffer(this.miscIndex, (char)ch);
                ++this.miscIndex;
                if (ch == 38 && (this.extractChar || this.extractNum)) {
                    int charEntity;
                    if (!this.extractNum) {
                        ch = this.read();
                        if (ch == 35) {
                            this.attrValBuffer[attrValBufferIndex++] = 38;
                            this.attrValBuffer[attrValBufferIndex++] = 35;
                            continue;
                        }
                        this.unread(ch);
                    }
                    if ((charEntity = this.rslvCharEnt()) == -1) {
                        this.attrValBuffer[attrValBufferIndex++] = 38;
                        continue;
                    }
                    this.attrValBuffer[attrValBufferIndex++] = (char)charEntity;
                    int i = 0;
                    while (i < this.entityBufIndex) {
                        this.addCharToMiscBuffer((char)this.entityBuf[i]);
                        ++i;
                    }
                    continue;
                }
                try {
                    this.attrValBuffer[attrValBufferIndex] = (char)ch;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    char[] newAttrValBuffer = new char[this.attrValBuffer.length * 2];
                    System.arraycopy(this.attrValBuffer, 0, newAttrValBuffer, 0, attrValBufferIndex);
                    this.attrValBuffer = newAttrValBuffer;
                }
                ++attrValBufferIndex;
            }
            if (ch != -1) {
                this.addCharToMiscBuffer((char)ch);
            } else {
                this.parser.error(11, "EOF in attribute value.");
            }
            if (this.miscIndex > 1 && (InsTokenizer.includeAngleBracket(this.miscBuffer, 1, this.miscIndex - 1) || this.miscBuffer[this.miscIndex - 2] == '=') && this.parser.handleError(11, new String(this.miscBuffer, 0, this.miscIndex))) {
                return this.readAttributeValue(ad, ed);
            }
        } else {
            if (ch == 62) {
                this.unread(ch);
                return "";
            }
            int ch1 = -1;
            if (!this.isUnquotedChar((char)ch) && (ch1 = this.sence()) == 34 || ch1 == 39 || Character.isWhitespace((char)ch1)) {
                return this.readAttributeValue(ad, ed);
            }
            this.attrValBuffer[attrValBufferIndex++] = (char)ch;
            while ((ch = this.read()) != -1 && ch != 62 && !Character.isWhitespace((char)ch)) {
                this.checkAttrValBuffer(attrValBufferIndex);
                if (ch == 38 && (this.extractChar || this.extractNum)) {
                    int charEntity;
                    if (!this.extractNum) {
                        ch = this.read();
                        if (ch == 35) {
                            this.attrValBuffer[attrValBufferIndex++] = 38;
                            this.attrValBuffer[attrValBufferIndex++] = 35;
                            continue;
                        }
                        this.unread(ch);
                    }
                    if ((charEntity = this.rslvCharEnt()) == -1) {
                        this.attrValBuffer[attrValBufferIndex++] = 38;
                        continue;
                    }
                    this.attrValBuffer[attrValBufferIndex++] = (char)charEntity;
                    continue;
                }
                this.attrValBuffer[attrValBufferIndex++] = (char)ch;
            }
            if (ch == 62) {
                this.unread(ch);
            }
        }
        ch = this.read();
        String ret = new String(this.attrValBuffer, 0, attrValBufferIndex);
        if (ch == 34 || ch == 39) {
            if (!this.parser.handleError(12, "\"")) {
                this.parser.error(9, "requires attribute name after \"" + ret + '\"');
            }
        } else {
            this.unread(ch);
        }
        return ret;
    }

    private int sence(int forward) throws IOException {
        switch (forward) {
            case 0: {
                int ch = this.read();
                this.unread(ch);
                return ch;
            }
            case 1: {
                int ch0 = this.read();
                int ch = this.read();
                this.unread(ch);
                this.unread(ch0);
                return ch;
            }
        }
        int[] buf = new int[forward];
        int i = 0;
        while (i < forward) {
            buf[i] = this.read();
            ++i;
        }
        i = forward - 1;
        while (i >= 0) {
            this.unread(buf[i]);
            --i;
        }
        return buf[forward - 1];
    }

    private int sence() throws IOException {
        int ch = this.read();
        this.unread(ch);
        return ch;
    }

    private boolean isUnquotedChar(char ch) {
        return Character.isLowerCase(ch) || Character.isUpperCase(ch) || Character.isDigit(ch) || ch == '-' || ch == '.';
    }

    private int etag() throws ParseException, IOException {
        int ch;
        while (Character.isWhitespace((char)(ch = this.read()))) {
            this.addCharToMiscBuffer((char)ch);
        }
        this.addCharToMiscBuffer((char)ch);
        if (ch == 62) {
            this.state = 0;
            this.sval = ">";
            this.parser.setCharacter(this.miscBuffer, this.etagStartIndex, this.miscIndex - this.etagStartIndex);
            this.ttype = 62;
            return 62;
        }
        if (ch == -1) {
            this.state = 0;
            this.sval = "";
            this.ttype = -1;
            return -1;
        }
        if (Character.isLowerCase((char)ch) || Character.isUpperCase((char)ch)) {
            int startIndex = this.miscIndex - 1;
            do {
                ch = this.read();
                this.setCharToMiscBuffer(this.miscIndex, (char)ch);
                ++this.miscIndex;
            } while (Character.isLowerCase((char)ch) || Character.isUpperCase((char)ch) || Character.isDigit((char)ch) || ch == 46 || ch == 45 || ch == 58 || ch == 35);
            this.unread(ch);
            --this.miscIndex;
            this.sval = new String(this.miscBuffer, startIndex, this.miscIndex - startIndex);
            this.ttype = 11;
            return 11;
        }
        return this.etag();
    }

    private int tag() throws ParseException, IOException {
        int ch;
        this.miscIndex = 0;
        while (Character.isWhitespace((char)(ch = this.read()))) {
        }
        if (ch == 33) {
            System.out.println("comment between DOCTYPE and HTML !!!");
            return this.eatComment();
        }
        if (ch == 62) {
            this.state = 0;
            this.sval = ">";
            this.ttype = 62;
            return 62;
        }
        if (ch == -1) {
            this.state = 0;
            this.sval = "";
            this.ttype = -1;
            return -1;
        }
        if (Character.isLowerCase((char)ch) || Character.isUpperCase((char)ch)) {
            do {
                this.setCharToMiscBuffer(this.miscIndex, (char)ch);
                ++this.miscIndex;
            } while (Character.isLowerCase((char)(ch = this.read())) || Character.isUpperCase((char)ch) || Character.isDigit((char)ch) || ch == 46 || ch == 45 || ch == 58 || ch == 35);
            this.unread(ch);
            this.sval = new String(this.miscBuffer, 0, this.miscIndex);
            this.ttype = 11;
            return 11;
        }
        if (Character.isDigit((char)ch)) {
            do {
                this.addCharToMiscBuffer((char)ch);
            } while (Character.isDigit((char)(ch = this.read())));
            if (ch == 37) {
                this.addCharToMiscBuffer((char)ch);
            } else {
                this.unread(ch);
            }
            this.sval = new String(this.miscBuffer, 0, this.miscIndex);
            this.ttype = 12;
            return 12;
        }
        if (ch == 60) {
            ch = this.read();
            if (ch == 47) {
                this.sval = "</";
                this.miscBuffer[0] = 60;
                this.miscBuffer[1] = 47;
                this.etagStartIndex = 0;
                this.state = 8;
                this.ttype = 8;
                return 8;
            }
            this.unread(ch);
            this.sval = "<";
            this.ttype = 60;
            return 60;
        }
        this.ttype = ch;
        return this.ttype;
    }

    final void consumeUntil(char limit) throws IOException {
        while (limit != this.read()) {
        }
    }

    void setPreserveWhitespace(boolean preserv) {
        this.prsvWS = preserv;
    }

    private void expandBuffer(int increase) {
        if (this.bufLimit != this.index) {
            increase += this.index < this.bufLimit ? this.bufLimit + this.index : this.charBuffer.length - this.index + this.bufLimit;
        }
        int length = this.charBuffer.length * 2;
        while (length < increase) {
            length *= 2;
        }
        char[] newBuffer = new char[length];
        if (this.index < this.bufLimit) {
            System.arraycopy(this.charBuffer, this.index, newBuffer, this.index, this.bufLimit - this.index);
        } else if (this.index != this.bufLimit) {
            System.arraycopy(this.charBuffer, 0, newBuffer, 0, this.bufLimit);
            System.arraycopy(this.charBuffer, this.index, newBuffer, length - this.charBuffer.length + this.index, this.charBuffer.length - this.index);
            this.index = length - this.charBuffer.length + this.index;
        }
        this.charBuffer = newBuffer;
    }

    private void expandMiscBuffer() {
        char[] newBuffer = this.miscBuffer.length < 32768 ? new char[this.miscBuffer.length * 2] : new char[this.miscBuffer.length + 32768];
        System.arraycopy(this.miscBuffer, 0, newBuffer, 0, this.miscIndex);
        this.miscBuffer = newBuffer;
    }

    private void storeUntil(char limit) throws IOException {
        int ch = this.read();
        while (ch != limit && ch != -1) {
            this.setCharToMiscBuffer(this.miscIndex, (char)ch);
            ++this.miscIndex;
            ch = this.read();
        }
    }

    final String eatUntil(char limit) throws IOException {
        this.miscIndex = 0;
        int ch = this.read();
        while (ch != limit && ch != -1) {
            this.setCharToMiscBuffer(this.miscIndex, (char)ch);
            ++this.miscIndex;
            ch = this.read();
        }
        return new String(this.miscBuffer, 0, this.miscIndex);
    }

    private boolean fillBuffer() throws IOException {
        if (this.bufLimit == this.charBuffer.length) {
            this.index = 0;
            this.bufLimit = this.reader.read(this.charBuffer, 0, 1024);
            if (this.bufLimit == -1) {
                return false;
            }
        } else if (this.bufLimit + 1024 < this.charBuffer.length) {
            int count = this.reader.read(this.charBuffer, this.bufLimit, 1024);
            if (count == -1) {
                return false;
            }
            this.bufLimit += count;
        } else {
            int count = this.reader.read(this.charBuffer, this.bufLimit, this.charBuffer.length - this.bufLimit);
            if (count == -1) {
                return false;
            }
            this.bufLimit += count;
        }
        return true;
    }

    private int read() throws IOException {
        if (this.bufLimit == this.index) {
            if (!this.fillBuffer()) {
                return -1;
            }
        } else if (this.index == this.charBuffer.length) {
            this.index = 0;
        }
        char ret = this.charBuffer[this.index++];
        if (this.skipLF) {
            if (ret == '\n') {
                if (this.bufLimit == this.index) {
                    if (!this.fillBuffer()) {
                        return -1;
                    }
                } else if (this.index == this.charBuffer.length) {
                    this.index = 0;
                }
                ++this.lastLFindex;
                ret = this.charBuffer[this.index++];
            }
            this.skipLF = false;
        }
        switch (ret) {
            case '\r': {
                this.skipLF = true;
            }
            case '\n': {
                ++this.lineNumber;
                this.lastLFindex = this.index - 1;
                return 10;
            }
        }
        return ret;
    }

    private void unread(int ch) throws IOException {
        if (ch == 10) {
            --this.lineNumber;
        }
        if (this.index == 0) {
            this.index = this.charBuffer.length - 1;
            this.charBuffer[this.index] = (char)ch;
        } else {
            this.charBuffer[--this.index] = (char)ch;
        }
    }

    void unread(String str) throws IOException {
        this.unread(str.toCharArray());
    }

    private void unread(char[] str, int begin, int len) {
        if (this.bufLimit >= this.index) {
            if (this.charBuffer.length - (this.bufLimit - this.index) < len) {
                this.expandBuffer(len);
            }
        } else if (this.index - this.bufLimit < len) {
            this.expandBuffer(len);
        }
        if (this.index < len) {
            int i = begin + len - 1;
            int j = this.index - 1;
            while (j >= 0) {
                if ((this.charBuffer[j] = str[i--]) == '\n') {
                    --this.lineNumber;
                }
                --j;
            }
            j = this.charBuffer.length - 1;
            while (i >= begin) {
                if ((this.charBuffer[j] = str[i--]) == '\n') {
                    --this.lineNumber;
                }
                --j;
            }
            this.index = j + 1;
        } else {
            int i = begin + len - 1;
            while (i >= begin) {
                this.charBuffer[--this.index] = str[i];
                if (this.charBuffer[--this.index] == '\n') {
                    --this.lineNumber;
                }
                --i;
            }
        }
    }

    private void unread(char[] str) {
        this.unread(str, 0, str.length);
    }

    final int nextToken() throws IOException, ParseException, SAXException {
        if (this.pushBacked) {
            this.pushBacked = false;
            return this.ttype;
        }
        switch (this.state) {
            case 0: {
                return this.defaultState();
            }
            case 1: {
                return this.tag();
            }
            case 2: {
                return this.etag();
            }
        }
        this.ttype = -1;
        return -1;
    }

    final void pushBack() {
        this.pushBacked = true;
    }

    final int getCurrentLine() {
        return this.lineNumber + 1;
    }

    final int getCurrentCol() {
        return this.getColumnNumber();
    }

    final void switchTo(int state) {
        this.state = state;
    }

    final void close() throws IOException {
        this.reader.close();
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return null;
    }

    public int getLineNumber() {
        return this.lineNumber + 1;
    }

    public int getColumnNumber() {
        int ret = this.index >= this.lastLFindex ? this.index - this.lastLFindex : this.charBuffer.length - this.lastLFindex + this.index;
        return ret;
    }
}

