/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.sgml.impl;

import java.io.IOException;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import org.eclipse.actf.model.dom.html.ParseException;
import org.eclipse.actf.model.internal.dom.sgml.ISGMLConstants;
import org.eclipse.actf.model.internal.dom.sgml.impl.AttributeDefinition;
import org.eclipse.actf.model.internal.dom.sgml.impl.DTDParseException;
import org.eclipse.actf.model.internal.dom.sgml.impl.DTDTokenizer;
import org.eclipse.actf.model.internal.dom.sgml.impl.ElementDefinition;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLDocTypeDef;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLEntityDeclaration;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLEntityReference;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLParser;
import org.eclipse.actf.model.internal.dom.sgml.modelgroup.AndModelGroup;
import org.eclipse.actf.model.internal.dom.sgml.modelgroup.IModelGroup;
import org.eclipse.actf.model.internal.dom.sgml.modelgroup.OptModelGroup;
import org.eclipse.actf.model.internal.dom.sgml.modelgroup.OrModelGroup;
import org.eclipse.actf.model.internal.dom.sgml.modelgroup.PlusModelGroup;
import org.eclipse.actf.model.internal.dom.sgml.modelgroup.RepModelGroup;
import org.eclipse.actf.model.internal.dom.sgml.modelgroup.SeqModelGroup;

class DTDParser
implements ISGMLConstants {
    private DTDTokenizer tokenizer;
    private Stack<DTDTokenizer> tokenizerStack = new Stack();
    private SGMLDocTypeDef dtd;

    DTDParser(DTDTokenizer tokenizer, SGMLDocTypeDef dtd) {
        this.tokenizer = tokenizer;
        this.dtd = dtd;
    }

    /*
     * Unable to fully structure code
     */
    final ElementDefinition readDTD() throws ParseException, IOException {
        block22: {
            lastDef = null;
            block8: while (true) {
                if (this.tokenizer.nextToken() != -1) ** GOTO lbl7
                break block22;
lbl-1000:
                // 1 sources

                {
                    this.tokenizer.nextToken();
lbl7:
                    // 2 sources

                    ** while (this.tokenizer.ttype == 13)
                }
lbl8:
                // 1 sources

                switch (this.tokenizer.ttype) {
                    case 1: {
                        switch (this.tokenizer.nextToken()) {
                            case 11: {
                                str = this.tokenizer.sval;
                                if (str.equalsIgnoreCase("ELEMENT")) {
                                    lastDef = this.readElementDefinition();
                                } else if (str.equalsIgnoreCase("ATTLIST")) {
                                    this.readAttributeList();
                                } else if (str.equalsIgnoreCase("ENTITY")) {
                                    this.readEntity();
                                } else {
                                    throw new DTDParseException("Unknown Declaration: " + str);
                                }
                                while (this.tokenizer.nextToken() != 62) {
                                }
                                continue block8;
                            }
                            case 91: {
                                if (this.mark()) {
                                    if (this.tokenizer.nextToken() == 91) {
                                        this.tokenizer.switchTo(0);
                                        lastDef = this.readDTD();
                                        this.tokenizer.switchTo(1);
                                        if (this.tokenizer.nextToken() == 93 && this.tokenizer.nextToken() == 93 && this.tokenizer.nextToken() == 62) {
                                            continue block8;
                                        }
                                    }
                                } else if (this.tokenizer.nextToken() == 91) {
                                    this.tokenizer.skipToDSC();
                                    if (this.tokenizer.nextToken() == 93 && this.tokenizer.nextToken() == 62) continue block8;
                                }
                                throw new DTDParseException("invalid mark region.");
                            }
                        }
                        throw new DTDParseException("invalid declaration");
                    }
                    case 37: {
                        this.tokenizer.pushBack();
                        ref = this.readEntityReference();
                        ed = ref.getEntityDeclaration();
                        if (ed == null) continue block8;
                        this.tokenizerStack.push(this.tokenizer);
                        this.tokenizer = new DTDTokenizer(ed.getReplacementReader());
                        this.readDTD();
                        this.tokenizer = this.tokenizerStack.pop();
                        continue block8;
                    }
                }
                break;
            }
            this.tokenizer.pushBack();
        }
        return lastDef;
    }

    private ElementDefinition readElementDefinition() throws ParseException, IOException {
        boolean notXHTML;
        ElementDefinition[] defs = this.readElementType();
        boolean start = false;
        boolean end = false;
        boolean bl = notXHTML = this.dtd.toString().indexOf("XHTML") < 0;
        if (notXHTML) {
            start = this.omit();
            end = this.omit();
        }
        IModelGroup content = this.exp();
        if (!notXHTML && content.toString().equalsIgnoreCase("EMPTY")) {
            end = true;
        }
        int i = 0;
        while (i < defs.length) {
            defs[i].setStartTag(start);
            defs[i].setEndTag(end);
            defs[i].setContentModel(content);
            ++i;
        }
        if (this.tokenizer.nextToken() == 3) {
            ElementDefinition[] exceptions = this.inclusion();
            i = 0;
            while (i < defs.length) {
                defs[i].setInclusion(exceptions);
                ++i;
            }
        } else if (this.tokenizer.ttype == 4) {
            ElementDefinition[] exceptions = this.inclusion();
            i = 0;
            while (i < defs.length) {
                defs[i].setExclusion(exceptions);
                ++i;
            }
        } else {
            this.tokenizer.pushBack();
        }
        return defs[0];
    }

    private ElementDefinition[] readElementType() throws ParseException, IOException {
        if (this.tokenizer.nextToken() == 40) {
            Vector<ElementDefinition[]> tmpVector = new Vector<ElementDefinition[]>();
            tmpVector.addElement(this.makeElementArray(this.atom()));
            while (this.tokenizer.nextToken() == 124) {
                tmpVector.addElement(this.makeElementArray(this.atom()));
            }
            if (this.tokenizer.ttype != 41) {
                throw new DTDParseException("invalid ELEMENT type");
            }
            int size = 0;
            Enumeration e = tmpVector.elements();
            while (e.hasMoreElements()) {
                size += ((ElementDefinition[])e.nextElement()).length;
            }
            ElementDefinition[] ret = new ElementDefinition[size];
            int i = 0;
            Enumeration e2 = tmpVector.elements();
            while (e2.hasMoreElements()) {
                ElementDefinition[] defs = (ElementDefinition[])e2.nextElement();
                int j = 0;
                while (j < defs.length) {
                    ret[i++] = defs[j];
                    ++j;
                }
            }
            return ret;
        }
        this.tokenizer.pushBack();
        return this.makeElementArray(this.atom());
    }

    private void readEntity() throws ParseException, IOException {
        if (this.tokenizer.nextToken() != 37) {
            if (this.tokenizer.ttype == 11) {
                String entityName = this.tokenizer.sval;
                int next = this.tokenizer.nextToken();
                if (next == 11 && this.tokenizer.sval.equalsIgnoreCase("CDATA")) {
                    if (this.tokenizer.nextToken() == 5) {
                        this.dtd.putEntityDeclaration(entityName, this.tokenizer.sval);
                        return;
                    }
                } else if (next == 5) {
                    this.dtd.putEntityDeclaration(entityName, this.tokenizer.sval);
                    return;
                }
            }
            throw new DTDParseException("invalid entity");
        }
        if (this.tokenizer.nextToken() == 11) {
            String entityName = this.tokenizer.sval;
            if (this.tokenizer.nextToken() != 5) {
                if (this.tokenizer.ttype == 11 && this.tokenizer.sval.equalsIgnoreCase("PUBLIC") && this.tokenizer.nextToken() == 5) {
                    String publicID = this.tokenizer.sval;
                    String entityFileName = SGMLParser.pubEntityMap.get(publicID);
                    if (entityFileName == null) {
                        System.out.println(String.valueOf(entityName) + " : " + publicID + " : " + entityFileName);
                        throw new DTDParseException("invalid entity");
                    }
                    this.dtd.putPublicEntity(entityName, publicID, entityFileName);
                    if (this.tokenizer.nextToken() == 62) {
                        this.tokenizer.pushBack();
                        return;
                    }
                    if (this.tokenizer.ttype == 5) {
                        return;
                    }
                }
            } else {
                this.dtd.putEntityDeclaration(entityName, this.tokenizer.sval);
                return;
            }
        }
        throw new DTDParseException("invalid entity");
    }

    private SGMLEntityReference readEntityReference() throws ParseException, IOException {
        if (this.tokenizer.nextToken() == 37 && (this.tokenizer.nextToken() == 11 || this.tokenizer.ttype == 14)) {
            String str = this.tokenizer.sval;
            if (this.tokenizer.nextToken() != 59) {
                this.tokenizer.pushBack();
            }
            return this.dtd.getEntityReference(str);
        }
        throw new DTDParseException("invalid entity reference");
    }

    private void readToken(AttributeDefinition attr) throws ParseException, IOException {
        if (this.tokenizer.nextToken() == 11 || this.tokenizer.ttype == 12) {
            attr.addNameToken(this.tokenizer.sval);
        } else if (this.tokenizer.ttype == 37) {
            this.tokenizer.pushBack();
            SGMLEntityReference er = this.readEntityReference();
            SGMLEntityDeclaration ed = er.getEntityDeclaration();
            this.tokenizerStack.push(this.tokenizer);
            this.tokenizer = new DTDTokenizer(ed.getReplacementReader(), 1);
            this.readTokenGroup(attr);
            this.tokenizer = this.tokenizerStack.pop();
        } else {
            throw new DTDParseException("invalid token");
        }
    }

    private void readTokenGroup(AttributeDefinition attr) throws ParseException, IOException {
        this.readToken(attr);
        while (this.tokenizer.nextToken() != 41 && this.tokenizer.ttype != -1) {
            if (this.tokenizer.ttype != 124) {
                throw new DTDParseException("invalid token group");
            }
            this.readToken(attr);
        }
    }

    private IModelGroup exp() throws ParseException, IOException {
        IModelGroup ret = this.term();
        int tmpC = this.tokenizer.nextToken();
        switch (tmpC) {
            case 44: {
                SeqModelGroup seq = new SeqModelGroup(ret);
                seq.add(this.term());
                while (this.tokenizer.nextToken() == 44) {
                    seq.add(this.term());
                }
                this.tokenizer.pushBack();
                if (seq.getChildLength() > this.dtd.maxSeqLength) {
                    this.dtd.maxSeqLength = seq.getChildLength();
                }
                return seq;
            }
            case 124: {
                ret = new OrModelGroup(ret);
                ((OrModelGroup)ret).add(this.term());
                while (this.tokenizer.nextToken() == 124) {
                    ((OrModelGroup)ret).add(this.term());
                }
                this.tokenizer.pushBack();
                return ret;
            }
            case 38: {
                ret = new AndModelGroup(ret);
                ((AndModelGroup)ret).add(this.term());
                while (this.tokenizer.nextToken() == 38) {
                    ((AndModelGroup)ret).add(this.term());
                }
                this.tokenizer.pushBack();
                return ret;
            }
        }
        this.tokenizer.pushBack();
        return ret;
    }

    private IModelGroup term() throws ParseException, IOException {
        IModelGroup ret = this.factor();
        int tmpC = this.tokenizer.nextToken();
        switch (tmpC) {
            case 63: {
                ret = new OptModelGroup(ret);
                break;
            }
            case 43: {
                ret = new PlusModelGroup(ret);
                break;
            }
            case 42: {
                ret = new RepModelGroup(ret);
                break;
            }
            default: {
                this.tokenizer.pushBack();
            }
        }
        return ret;
    }

    private IModelGroup factor() throws ParseException, IOException {
        switch (this.tokenizer.nextToken()) {
            case 40: {
                IModelGroup ret = this.exp();
                if (this.tokenizer.nextToken() != 41) {
                    throw new DTDParseException("ret: " + ret.toString() + " sval: " + this.tokenizer.sval + " ttype: " + this.tokenizer.ttype);
                }
                return ret;
            }
            case 2: {
                return SGMLParser.cdata;
            }
            case 12: {
                if (this.tokenizer.sval.equalsIgnoreCase("#PCDATA")) {
                    return SGMLParser.pcdata;
                }
                throw new DTDParseException("sval: " + this.tokenizer.sval + " ttype: " + this.tokenizer.ttype);
            }
        }
        if (this.tokenizer.ttype == 11 && this.tokenizer.sval.equalsIgnoreCase("EMPTY")) {
            return SGMLParser.empty;
        }
        if (this.tokenizer.ttype == 11 && this.tokenizer.sval.equalsIgnoreCase("CDATA")) {
            return SGMLParser.cdata;
        }
        this.tokenizer.pushBack();
        return this.atom();
    }

    private IModelGroup atom() throws ParseException, IOException {
        if (this.tokenizer.nextToken() == 11) {
            return this.dtd.createElementDefinition(this.tokenizer.sval);
        }
        if (this.tokenizer.ttype == 37) {
            this.tokenizer.pushBack();
            SGMLEntityReference er = this.readEntityReference();
            SGMLEntityDeclaration ed = er.getEntityDeclaration();
            IModelGroup ret = ed.getReplacementSubtree();
            if (ret == null) {
                this.tokenizerStack.push(this.tokenizer);
                this.tokenizer = new DTDTokenizer(ed.getReplacementReader(), 1);
                ret = this.exp();
                ed.setReplacementSubtree(ret);
                this.tokenizer = this.tokenizerStack.pop();
            }
            return ret;
        }
        throw new DTDParseException("sval: " + this.tokenizer.sval + " ttype: " + this.tokenizer.ttype);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void declaredValue(AttributeDefinition attr) throws ParseException, IOException {
        if (this.tokenizer.nextToken() == 11) {
            String str = this.tokenizer.sval;
            if (str.equalsIgnoreCase("CDATA")) {
                attr.setDeclaredType(1);
                return;
            } else if (str.equalsIgnoreCase("ID")) {
                attr.setDeclaredType(2);
                return;
            } else if (str.equalsIgnoreCase("IDREF")) {
                attr.setDeclaredType(3);
                return;
            } else if (str.equalsIgnoreCase("IDREFS")) {
                attr.setDeclaredType(4);
                return;
            } else if (str.equalsIgnoreCase("NAME")) {
                attr.setDeclaredType(6);
                return;
            } else if (str.equalsIgnoreCase("NUMBER")) {
                attr.setDeclaredType(5);
                return;
            } else if (str.equalsIgnoreCase("NMTOKEN")) {
                attr.setDeclaredType(8);
                return;
            } else {
                if (!str.equalsIgnoreCase("NAMES")) throw new DTDParseException(String.valueOf(this.tokenizer.getCurrentLine()) + ": unknown declared value " + str);
                attr.setDeclaredType(9);
            }
            return;
        } else if (this.tokenizer.ttype == 40) {
            attr.setDeclaredType(7);
            this.readTokenGroup(attr);
            return;
        } else {
            if (this.tokenizer.ttype != 37) throw new DTDParseException("at " + this.tokenizer);
            this.tokenizer.pushBack();
            SGMLEntityReference er = this.readEntityReference();
            SGMLEntityDeclaration ed = er.getEntityDeclaration();
            this.tokenizerStack.push(this.tokenizer);
            this.tokenizer = new DTDTokenizer(ed.getReplacementReader(), 1);
            this.declaredValue(attr);
            this.tokenizer = this.tokenizerStack.pop();
        }
    }

    private void defaultValue(AttributeDefinition attr) throws ParseException, IOException {
        switch (this.tokenizer.nextToken()) {
            case 11: {
                attr.setDefaultValue(this.tokenizer.sval);
                break;
            }
            case 5: {
                String str = this.tokenizer.sval;
                break;
            }
            case 12: {
                String str = this.tokenizer.sval;
                if (str.equalsIgnoreCase("#REQUIRED")) {
                    attr.setDefaultType(2);
                    break;
                }
                if (str.equalsIgnoreCase("#IMPLIED")) {
                    attr.setDefaultType(3);
                    break;
                }
                if (str.equalsIgnoreCase("#FIXED")) {
                    if (this.tokenizer.nextToken() == -1) {
                        this.tokenizer = this.tokenizerStack.peek();
                    } else {
                        this.tokenizer.pushBack();
                    }
                    if (this.tokenizer.nextToken() != 5) {
                        throw new DTDParseException(String.valueOf(this.tokenizer.getCurrentLine()) + ": STRING must follow #FIXED");
                    }
                    attr.setDefaultType(1);
                    str = this.tokenizer.sval;
                    this.tokenizerStack.push(this.tokenizer);
                    this.tokenizer = new DTDTokenizer(new StringReader(str), 1);
                    try {
                        SGMLEntityReference ref = this.readEntityReference();
                        attr.setDefaultValue(ref.getEntityDeclaration().getReplacementString());
                    }
                    catch (ParseException parseException) {
                        attr.setDefaultValue(str);
                    }
                    this.tokenizer = this.tokenizerStack.pop();
                    break;
                }
                attr.setDefaultValue(str);
            }
        }
    }

    private void readAttributeList() throws ParseException, IOException {
        this.readAttributeList(this.readElementType());
    }

    private AttributeDefinition[] readAttributeList(ElementDefinition[] defs) throws ParseException, IOException {
        Vector<AttributeDefinition> v = new Vector<AttributeDefinition>();
        while (this.tokenizer.nextToken() != 62 && this.tokenizer.ttype != -1) {
            this.tokenizer.pushBack();
            AttributeDefinition[] ads = this.attributeDefinitionList(defs);
            int i = 0;
            while (i < ads.length) {
                v.addElement(ads[i]);
                ++i;
            }
        }
        this.tokenizer.pushBack();
        Object[] ret = new AttributeDefinition[v.size()];
        v.copyInto(ret);
        return ret;
    }

    private AttributeDefinition[] attributeDefinitionList(ElementDefinition[] defs) throws ParseException, IOException {
        if (this.tokenizer.nextToken() == 11) {
            AttributeDefinition ad = new AttributeDefinition(this.tokenizer.sval);
            this.declaredValue(ad);
            this.defaultValue(ad);
            int i = 0;
            while (i < defs.length) {
                defs[i].addAttributeDefinition(ad);
                ++i;
            }
            AttributeDefinition[] ads = new AttributeDefinition[]{ad};
            return ads;
        }
        if (this.tokenizer.ttype == 37) {
            this.tokenizer.pushBack();
            SGMLEntityReference er = this.readEntityReference();
            SGMLEntityDeclaration ed = er.getEntityDeclaration();
            this.tokenizerStack.push(this.tokenizer);
            this.tokenizer = new DTDTokenizer(ed.getReplacementReader(), 1);
            AttributeDefinition[] ads = this.readAttributeList(defs);
            this.tokenizer = this.tokenizerStack.pop();
            return ads;
        }
        throw new DTDParseException("illegal attlist.");
    }

    private boolean mark() throws ParseException, IOException {
        if (this.tokenizer.nextToken() == 11) {
            if (this.tokenizer.sval.equalsIgnoreCase("INCLUDE")) {
                return true;
            }
            if (this.tokenizer.sval.equalsIgnoreCase("IGNORE")) {
                return false;
            }
            throw new DTDParseException("last sval: " + this.tokenizer.sval);
        }
        if (this.tokenizer.ttype == 37) {
            this.tokenizer.pushBack();
            SGMLEntityReference er = this.readEntityReference();
            SGMLEntityDeclaration ed = er.getEntityDeclaration();
            this.tokenizerStack.push(this.tokenizer);
            this.tokenizer = new DTDTokenizer(ed.getReplacementReader(), 1);
            boolean ret = this.mark();
            this.tokenizer = this.tokenizerStack.pop();
            return ret;
        }
        throw new DTDParseException("sval: " + this.tokenizer.sval + " ttype: " + this.tokenizer.ttype);
    }

    private ElementDefinition[] makeElementArray(IModelGroup model) throws ParseException {
        if (model instanceof ElementDefinition) {
            ElementDefinition[] ret = new ElementDefinition[]{(ElementDefinition)model};
            return ret;
        }
        if (model instanceof OrModelGroup) {
            return ((OrModelGroup)model).getChildren();
        }
        throw new DTDParseException("sval: " + this.tokenizer.sval + " ttype: " + this.tokenizer.ttype);
    }

    private boolean omit() throws ParseException, IOException {
        switch (this.tokenizer.nextToken()) {
            case 79: {
                return true;
            }
            case 45: {
                return false;
            }
        }
        throw new DTDParseException("'O' or '-' is required at " + this.tokenizer.getCurrentLine());
    }

    private ElementDefinition[] inclusion() throws ParseException, IOException {
        Vector<ElementDefinition[]> tmpVector = new Vector<ElementDefinition[]>();
        tmpVector.addElement(this.makeElementArray(this.atom()));
        while (this.tokenizer.nextToken() == 124) {
            tmpVector.addElement(this.makeElementArray(this.atom()));
        }
        if (this.tokenizer.ttype != 41) {
            throw new DTDParseException("sval: " + this.tokenizer.sval + " ttype: " + this.tokenizer.ttype);
        }
        int size = 0;
        Enumeration e = tmpVector.elements();
        while (e.hasMoreElements()) {
            size += ((ElementDefinition[])e.nextElement()).length;
        }
        ElementDefinition[] ret = new ElementDefinition[size];
        int i = 0;
        Enumeration e2 = tmpVector.elements();
        while (e2.hasMoreElements()) {
            ElementDefinition[] defs = (ElementDefinition[])e2.nextElement();
            int j = 0;
            while (j < defs.length) {
                ret[i++] = defs[j];
                ++j;
            }
        }
        return ret;
    }
}

