/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.services.internal.events;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.internal.services.Activator;
import org.eclipse.e4.ui.internal.services.ServiceMessages;
import org.eclipse.e4.ui.services.internal.events.UIEventHandler;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;

public class EventBroker
implements IEventBroker {
    private Map<EventHandler, Collection<ServiceRegistration<?>>> registrations = new HashMap();
    @Inject
    Logger logger;
    @Inject
    @Optional
    UISynchronize uiSync;

    static {
        EventAdmin eventAdmin = Activator.getDefault().getEventAdmin();
        if (eventAdmin == null) {
            Bundle[] bundles;
            Bundle[] bundleArray = bundles = Activator.getDefault().getBundleContext().getBundles();
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle = bundleArray[n2];
                if ("org.eclipse.equinox.event".equals(bundle.getSymbolicName())) {
                    try {
                        bundle.start(1);
                    }
                    catch (BundleException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                ++n2;
            }
        }
    }

    public boolean send(String topic, Object data) {
        Event event = this.constructEvent(topic, data);
        EventAdmin eventAdmin = Activator.getDefault().getEventAdmin();
        if (eventAdmin == null) {
            this.logger.error(NLS.bind((String)ServiceMessages.NO_EVENT_ADMIN, (Object)event.toString()));
            return false;
        }
        eventAdmin.sendEvent(event);
        return true;
    }

    public boolean post(String topic, Object data) {
        Event event = this.constructEvent(topic, data);
        EventAdmin eventAdmin = Activator.getDefault().getEventAdmin();
        if (eventAdmin == null) {
            this.logger.error(NLS.bind((String)ServiceMessages.NO_EVENT_ADMIN, (Object)event.toString()));
            return false;
        }
        eventAdmin.postEvent(event);
        return true;
    }

    private Event constructEvent(String topic, Object data) {
        Event event;
        if (data instanceof Dictionary) {
            event = new Event(topic, (Dictionary)data);
        } else if (data instanceof Map) {
            event = new Event(topic, (Map)data);
        } else {
            Hashtable<String, Object> d = new Hashtable<String, Object>(2);
            ((Dictionary)d).put("event.topics", topic);
            if (data != null) {
                ((Dictionary)d).put("org.eclipse.e4.data", data);
            }
            event = new Event(topic, d);
        }
        return event;
    }

    public boolean subscribe(String topic, EventHandler eventHandler) {
        return this.subscribe(topic, null, eventHandler, false);
    }

    public boolean subscribe(String topic, String filter, EventHandler eventHandler, boolean headless) {
        BundleContext bundleContext = Activator.getDefault().getBundleContext();
        if (bundleContext == null) {
            this.logger.error(NLS.bind((String)ServiceMessages.NO_BUNDLE_CONTEXT, (Object)topic));
            return false;
        }
        String[] topics = new String[]{topic};
        Hashtable<String, Object> d = new Hashtable<String, Object>();
        ((Dictionary)d).put("event.topics", topics);
        if (filter != null) {
            ((Dictionary)d).put("event.filter", filter);
        }
        UIEventHandler wrappedHandler = new UIEventHandler(eventHandler, headless ? null : this.uiSync);
        ServiceRegistration registration = bundleContext.registerService(EventHandler.class.getName(), (Object)wrappedHandler, d);
        Collection<ServiceRegistration<?>> handled = this.registrations.get(eventHandler);
        if (handled == null) {
            handled = new ArrayList();
            this.registrations.put(eventHandler, handled);
        }
        handled.add(registration);
        return true;
    }

    public boolean unsubscribe(EventHandler eventHandler) {
        Collection<ServiceRegistration<?>> handled = this.registrations.remove(eventHandler);
        if (handled == null || handled.isEmpty()) {
            return false;
        }
        for (ServiceRegistration<?> r : handled) {
            r.unregister();
        }
        return true;
    }

    @PreDestroy
    void dispose() {
        ArrayList values = new ArrayList(this.registrations.values());
        this.registrations.clear();
        for (Collection collection : values) {
            for (ServiceRegistration registration : collection) {
                registration.unregister();
            }
        }
    }
}

