/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.win32;

import org.eclipse.actf.util.win32.MemoryUtil;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.IDispatch;
import org.eclipse.swt.ole.win32.Variant;

public class NativeVariantAccess {
    private int size;
    private int pVariantAddress;

    public NativeVariantAccess() {
        this(1);
    }

    public NativeVariantAccess(int size) {
        this.size = size;
        this.pVariantAddress = MemoryUtil.GlobalAlloc(Variant.sizeof * size);
        int i = 0;
        while (i < size) {
            COM.VariantInit((int)this.getAddress(i));
            ++i;
        }
    }

    public void dispose() {
        int i = 0;
        while (i < this.size) {
            COM.VariantClear((int)this.getAddress(i));
            ++i;
        }
        MemoryUtil.GlobalFree(this.pVariantAddress);
    }

    public int getAddress() {
        return this.getAddress(0);
    }

    public int getAddress(int index) {
        return this.pVariantAddress + Variant.sizeof * index;
    }

    public short getType() {
        return this.getType(0);
    }

    public short getType(int index) {
        short[] pType = new short[1];
        MemoryUtil.MoveMemory(pType, this.getAddress(index), 2);
        return pType[0];
    }

    public int getInt() {
        return this.getInt(0);
    }

    public int getInt(int index) {
        if (3 == this.getType(index)) {
            int[] pInt = new int[1];
            MemoryUtil.MoveMemory(pInt, this.getAddress(index) + 8, 4);
            return pInt[0];
        }
        return -1;
    }

    public IDispatch getDispatch() {
        return this.getDispatch(0);
    }

    public IDispatch getDispatch(int index) {
        if (9 == this.getType(index)) {
            int[] pInt = new int[1];
            MemoryUtil.MoveMemory(pInt, this.getAddress(index) + 8, 4);
            return new IDispatch(pInt[0]);
        }
        return null;
    }

    public String getString() {
        return this.getString(0);
    }

    public String getString(int index) {
        if (8 == this.getType(index)) {
            int size;
            int[] hMem = new int[1];
            MemoryUtil.MoveMemory(hMem, this.getAddress(index) + 8, 4);
            if (hMem[0] != 0 && (size = COM.SysStringByteLen((int)hMem[0])) > 0) {
                char[] buffer = new char[(size + 1) / 2];
                MemoryUtil.MoveMemory(buffer, hMem[0], size);
                return new String(buffer);
            }
        }
        return null;
    }

    public Variant getVariant() {
        return this.getVariant(0);
    }

    public Variant getVariant(int index) {
        switch (this.getType(index)) {
            case 3: {
                return new Variant(this.getInt(index));
            }
            case 8: {
                return new Variant(this.getString(index));
            }
            case 0: {
                return new Variant();
            }
        }
        return null;
    }
}

