/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.blind.odfbyhtml;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import org.eclipse.actf.model.dom.html.HTMLParserFactory;
import org.eclipse.actf.model.dom.html.IErrorLogListener;
import org.eclipse.actf.model.dom.html.IHTMLParser;
import org.eclipse.actf.model.ui.IModelService;
import org.eclipse.actf.util.FileUtils;
import org.eclipse.actf.util.dom.DomPrintUtil;
import org.eclipse.actf.util.logging.DebugPrintUtil;
import org.eclipse.actf.visualization.blind.BlindVisualizerBase;
import org.eclipse.actf.visualization.blind.IBlindVisualizer;
import org.eclipse.actf.visualization.blind.ui.internal.Messages;
import org.eclipse.actf.visualization.engines.blind.BlindVizResourceUtil;
import org.eclipse.actf.visualization.engines.blind.eval.EvaluationResultBlind;
import org.eclipse.actf.visualization.engines.blind.html.IVisualizeMapData;
import org.eclipse.actf.visualization.engines.blind.html.VisualizeEngine;
import org.eclipse.actf.visualization.engines.blind.html.util.HtmlErrorLogListener;
import org.eclipse.actf.visualization.engines.blind.html.util.VisualizeReportUtil;
import org.eclipse.actf.visualization.eval.CheckTargetFactory;
import org.eclipse.actf.visualization.eval.EvaluationUtil;
import org.eclipse.actf.visualization.eval.ICheckTarget;
import org.eclipse.actf.visualization.eval.IChecker;
import org.eclipse.actf.visualization.eval.guideline.GuidelineHolder;
import org.eclipse.actf.visualization.eval.html.statistics.PageData;
import org.eclipse.actf.visualization.eval.problem.HighlightTargetNodeInfo;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.eval.problem.IProblemItemVisitor;
import org.eclipse.actf.visualization.eval.problem.ProblemItemImpl;
import org.eclipse.actf.visualization.util.html2view.Html2ViewMapMaker;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlindVisualizerOdfByHtml
extends BlindVisualizerBase
implements IBlindVisualizer {
    private final String ODF_HTML_FILE_NAME = "ODF.html";
    private final String odf_html_fileS = String.valueOf(this.tmpDirS) + "ODF.html";
    private final String NO_ALT_IMAGE = "10101";
    private static final String MAPPED_HTML_FILE_PRE = "MappedHTML";
    private static final String HTML_SOURCE_FILE = "source.html";

    public boolean setModelService(IModelService targetModel) {
        if (super.setModelService(targetModel)) {
            if (this.targetUrl.startsWith("file://")) {
                this.targetUrl = this.targetUrl.substring(8);
            }
            this.targetUrl = this.targetUrl.replaceAll("%20", " ");
            return true;
        }
        return false;
    }

    public int visualize() {
        Document document;
        Vector html2ViewMapV;
        block13: {
            if (this.modelService == null) {
                return -1;
            }
            GuidelineHolder.getInstance().setTargetMimeType(this.modelService.getCurrentMIMEType());
            this.modelService.saveDocumentAsHTMLFile(this.odf_html_fileS);
            this.checkResult = new EvaluationResultBlind();
            FileUtils.copyFile((String)this.odf_html_fileS, (String)(String.valueOf(this.tmpDirS) + HTML_SOURCE_FILE), (boolean)true);
            html2ViewMapV = new Vector();
            IHTMLParser htmlParser = HTMLParserFactory.createHTMLParser();
            HtmlErrorLogListener errorLogListener = new HtmlErrorLogListener();
            htmlParser.addErrorLogListener((IErrorLogListener)errorLogListener);
            String targetFile = String.valueOf(this.tmpDirS) + MAPPED_HTML_FILE_PRE + ".html";
            html2ViewMapV = Html2ViewMapMaker.makeMap((String)"ODF.html", (String)"MappedHTML.html", (String)this.tmpDirS);
            if (html2ViewMapV.size() == 0) {
                targetFile = this.odf_html_fileS;
            }
            IHTMLParser tmpHtmlParser = HTMLParserFactory.createHTMLParser();
            tmpHtmlParser.parse((InputStream)new FileInputStream(targetFile));
            document = tmpHtmlParser.getDocument();
            if (document != null) break block13;
            return -1;
        }
        try {
            this.setStatusMessage(Messages.BlindView_Now_processing);
            this.pageData = new PageData();
            VisualizeEngine engine = new VisualizeEngine();
            engine.setBaseUrl("");
            engine.setTargetUrl(this.targetUrl);
            engine.setDocument(document);
            engine.setHtml2viewMapV(html2ViewMapV);
            engine.setInvisibleIdSet(new HashSet());
            engine.setPageData(this.pageData);
            engine.visualize();
            this.maxReachingTime = engine.getMaxTime();
            this.setInfoMessage(this.getMaxReachingTime());
            this.resultDocument = engine.getResult();
            this.checkResult.setProblemList(engine.getProbelems());
            this.checkResult.setTargetUrl(this.targetUrl);
            if (this.variantFile != null) {
                this.variantFile.delete();
            }
            this.variantFile = engine.getVariantFile();
            this.checkResult.addAssociateFile(this.variantFile);
            IVisualizeMapData mapData = engine.getVisualizeMapData();
            this.checkResult.setSourceFile(null);
            ArrayList<IProblemItem> tmpResults = new ArrayList<IProblemItem>(1024);
            Document odfDoc = this.modelService.getDocument();
            ICheckTarget checkTarget = CheckTargetFactory.createCheckTarget((Document)odfDoc, (String)this.modelService.getURL());
            checkTarget.setAdditionalDocument("html", document);
            IChecker[] checkers = EvaluationUtil.getCheckers();
            int i = 0;
            while (i < checkers.length) {
                if (checkers[i].isTargetFormat(this.modelService.getCurrentMIMEType()) && checkers[i].isEnabled()) {
                    long startTime = System.currentTimeMillis();
                    tmpResults.addAll(checkers[i].check(checkTarget));
                    DebugPrintUtil.devOrDebugPrintln((Object)(System.currentTimeMillis() - startTime));
                }
                ++i;
            }
            this.visualizeError(this.resultDocument, tmpResults);
            i = 0;
            while (i < tmpResults.size()) {
                IProblemItem tmpItem = tmpResults.get(i);
                HighlightTargetNodeInfo nodeInfo = tmpItem.getHighlightTargetNodeInfo();
                if (nodeInfo != null) {
                    tmpItem.setHighlightTargetIds(nodeInfo.getHighlightTargetIds(mapData.getOrig2idMap()));
                }
                ++i;
            }
            this.checkResult.addProblemItems(tmpResults);
            this.checkResult.accept((IProblemItemVisitor)this.pageData);
            if (this.resultFile != null) {
                this.resultFile.delete();
            }
            this.resultFile = BlindVizResourceUtil.createTempFile((String)"result", (String)".html");
            try {
                DomPrintUtil dpu = new DomPrintUtil(this.resultDocument);
                dpu.writeToFile(this.resultFile);
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
        }
        catch (Exception e) {
            this.setStatusMessage(Messages.Visualization_Error);
            e.printStackTrace();
            return -1;
        }
        return 0;
    }

    public boolean isTarget(IModelService modelService) {
        return modelService != null && modelService.getCurrentMIMEType().startsWith("application/vnd.oasis.opendocument.");
    }

    private void visualizeError(Document resultDoc, List<IProblemItem> problems) {
        int size = problems.size();
        int i = 0;
        while (i < size) {
            ProblemItemImpl prob;
            IProblemItem obj = problems.get(i);
            if (obj instanceof ProblemItemImpl && (prob = (ProblemItemImpl)obj).getId().equals("O_10101")) {
                VisualizeReportUtil.visualizeError((Document)resultDoc, (IProblemItem)prob);
            }
            ++i;
        }
    }
}

