/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.ui.editor.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.actf.model.internal.ui.FavoritesChangeEvent;
import org.eclipse.actf.model.internal.ui.FavoritesChangeListener;
import org.eclipse.actf.model.internal.ui.FavoritesUtil;
import org.eclipse.actf.model.internal.ui.editor.actions.AddFavoritesAction;
import org.eclipse.actf.model.internal.ui.editor.actions.ArrangeFavoritesAction;
import org.eclipse.actf.model.internal.ui.editor.actions.FavoritesItemAction;
import org.eclipse.actf.model.ui.util.ModelServiceMessages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IWorkbenchWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FavoritesMenu
extends MenuManager
implements FavoritesChangeListener {
    private IWorkbenchWindow _window;
    private List<String> _favoritesItemIdList = new ArrayList<String>();
    private boolean useExistingEditor;

    public FavoritesMenu(IWorkbenchWindow window) {
        this(window, false);
    }

    public FavoritesMenu(IWorkbenchWindow window, boolean useExistingEditor) {
        super(ModelServiceMessages.MenuConst_F_avorites_8);
        this._window = window;
        this.useExistingEditor = useExistingEditor;
        Map<String, String> favoritesMap = FavoritesUtil.getFavoritesMap();
        AddFavoritesAction favoritesAddAction = new AddFavoritesAction(window, favoritesMap);
        this.add((IAction)favoritesAddAction);
        favoritesAddAction.addFavoritesChangeListener(this);
        ArrangeFavoritesAction favoritesArrangeAction = new ArrangeFavoritesAction(this._window, favoritesMap);
        this.add((IAction)favoritesArrangeAction);
        favoritesArrangeAction.addFavoritesChangeListener(this);
        this.add((IContributionItem)new Separator());
        this.updateAllFavoritesItems(favoritesMap);
    }

    @Override
    public void favoritesChanged(FavoritesChangeEvent fce) {
        this.updateAllFavoritesItems(fce.getFavoritesMap());
    }

    private void updateAllFavoritesItems(Map<String, String> favoritesMap) {
        Iterator<String> favoritesIt = favoritesMap.keySet().iterator();
        this.removeAllFavoritesItemAction();
        while (favoritesIt.hasNext()) {
            String name = favoritesIt.next();
            String url = favoritesMap.get(name);
            this.addFavoritesItemAction(name, url);
        }
        FavoritesUtil.saveFavoritesMap(favoritesMap);
    }

    private void removeAllFavoritesItemAction() {
        int i = 0;
        while (i < this._favoritesItemIdList.size()) {
            this.remove(this._favoritesItemIdList.get(i));
            ++i;
        }
        this._favoritesItemIdList.clear();
    }

    private void addFavoritesItemAction(String name, String url) {
        FavoritesItemAction favoritesItemAction = new FavoritesItemAction(this._window, name, url, this.useExistingEditor);
        this.add((IAction)favoritesItemAction);
        this._favoritesItemIdList.add(String.valueOf(FavoritesItemAction.ID) + "_" + name);
    }
}

