/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ui.util;

import java.io.File;
import java.io.IOException;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public abstract class AbstractUIPluginACTF
extends AbstractUIPlugin {
    private File tmpDir = null;

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        this.createTempDirectory();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        super.stop(bundleContext);
        this.deleteFiles(this.tmpDir);
    }

    protected void createTempDirectory() {
        if (this.tmpDir == null) {
            String string = String.valueOf(this.getStateLocation().toOSString()) + File.separator + "tmp";
            this.tmpDir = this.isAvailableDirectory(string) ? new File(string) : new File(String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + "ACTF");
        }
    }

    public File createTempFile(String string, String string2) throws IOException {
        if (this.tmpDir == null) {
            this.createTempDirectory();
        }
        return File.createTempFile(string, string2, this.tmpDir);
    }

    public File getTempDirectory() {
        if (this.tmpDir == null) {
            this.createTempDirectory();
        }
        return this.tmpDir;
    }

    private void deleteFiles(File file) {
        if (file != null) {
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                if (fileArray[n].isDirectory()) {
                    this.deleteFiles(fileArray[n]);
                }
                fileArray[n].delete();
                ++n;
            }
        }
    }

    private boolean isAvailableDirectory(String string) {
        File file = new File(string);
        return file.isDirectory() && file.canWrite() || file.mkdirs();
    }
}

