/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.tasks;

import javax.inject.Named;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.tea.core.services.TaskProgressTracker;
import org.eclipse.tea.library.build.model.WorkspaceData;

@Named(value="Clean and refresh all projects")
public class TaskCleanWorkspace {
    @Execute
    public void run(TaskProgressTracker tracker) throws Exception {
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (tracker.isCanceled()) {
                throw new OperationCanceledException();
            }
            tracker.setTaskName(project.getName());
            TaskCleanWorkspace.fullCleanAndRefresh(project);
            tracker.worked(1);
            ++n2;
        }
    }

    public static void fullCleanAndRefresh(IProject project) throws CoreException {
        if (project == null || !project.exists() || !project.isOpen() || WorkspaceData.isBinaryProject(project)) {
            return;
        }
        project.build(15, null);
        project.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        project.refreshLocal(2, null);
    }
}

