/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.testers;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;

public class TargetPropertyTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof IPeerNode) {
            IPeerNode peerNode = (IPeerNode)receiver;
            if (property.equals("isWindows")) {
                return TargetPropertyTester.isWindows(peerNode);
            }
        }
        return false;
    }

    public static boolean isWindows(IPeerNode peerNode) {
        String osName = TargetPropertyTester.getOSName(peerNode);
        return osName == null ? false : osName.startsWith("Windows");
    }

    public static String getOSName(final IPeerNode peerNode) {
        final String[] osName = new String[1];
        if (Protocol.isDispatchThread()) {
            osName[0] = peerNode.getPeer().getOSName();
        } else {
            Protocol.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    osName[0] = peerNode.getPeer().getOSName();
                }
            });
        }
        return osName[0];
    }
}

