/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.tests;

import java.math.BigInteger;
import java.util.LinkedList;
import java.util.Random;
import org.eclipse.tcf.internal.debug.tests.ITCFTest;
import org.eclipse.tcf.internal.debug.tests.TCFTestSuite;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IErrorReport;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IDiagnostics;

class TestEchoINT
implements ITCFTest,
IDiagnostics.DoneEchoINT {
    private final TCFTestSuite test_suite;
    private final IDiagnostics diag;
    private final LinkedList<BigInteger> msgs = new LinkedList();
    private final Random rnd = new Random();
    private static final int MAX_COUNT = 4096;
    private static final int MAX_TIME_MS = 4000;
    private int count = 0;
    private long start_time;

    TestEchoINT(TCFTestSuite test_suite, IChannel channel) {
        this.test_suite = test_suite;
        this.diag = (IDiagnostics)channel.getRemoteService(IDiagnostics.class);
    }

    @Override
    public void start() {
        if (this.diag == null) {
            this.test_suite.done(this, null);
        } else {
            this.start_time = System.currentTimeMillis();
            int i = 0;
            while (i < 100) {
                this.sendMessage();
                ++i;
            }
        }
    }

    private void sendMessage() {
        int t = 0;
        BigInteger n = null;
        switch (this.count) {
            case 0: {
                n = new BigInteger("-2147483648");
                break;
            }
            case 1: {
                n = new BigInteger("2147483647");
                break;
            }
            case 2: {
                t = 2;
                n = new BigInteger("-9223372036854775808");
                break;
            }
            case 3: {
                t = 2;
                n = new BigInteger("9223372036854775807");
            }
        }
        if (n == null) {
            byte[] buf = null;
            t = this.rnd.nextInt() & 3;
            switch (t) {
                case 0: {
                    n = BigInteger.valueOf(this.rnd.nextInt());
                    break;
                }
                case 1: {
                    buf = new byte[4];
                    this.rnd.nextBytes(buf);
                    n = new BigInteger(1, buf);
                    break;
                }
                case 2: {
                    buf = new byte[8];
                    this.rnd.nextBytes(buf);
                    buf[0] = (byte)(buf[0] & 0x7F);
                    n = new BigInteger(this.rnd.nextBoolean() ? 1 : -1, buf);
                    break;
                }
                case 3: {
                    buf = new byte[8];
                    this.rnd.nextBytes(buf);
                    n = new BigInteger(1, buf);
                }
            }
        }
        this.msgs.add(n);
        this.diag.echoINT(t, n, (IDiagnostics.DoneEchoINT)this);
        ++this.count;
    }

    public void doneEchoINT(IToken token, Throwable error, BigInteger b) {
        BigInteger s = this.msgs.removeFirst();
        if (!this.test_suite.isActive(this)) {
            return;
        }
        if (error instanceof IErrorReport && ((IErrorReport)error).getErrorCode() == 25) {
            this.test_suite.done(this, null);
        } else if (error != null) {
            this.test_suite.done(this, error);
        } else if (!s.equals(b)) {
            this.test_suite.done(this, new Exception("EchoINT test failed: " + s + " != " + b));
        } else if (this.count < 4096) {
            this.sendMessage();
            if (this.count % 64 == 0 && System.currentTimeMillis() - this.start_time >= 4000L) {
                this.count = 4096;
            }
        } else if (this.msgs.isEmpty()) {
            this.test_suite.done(this, null);
        }
    }

    @Override
    public boolean canResume(String id) {
        return true;
    }
}

