/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.launch.core.delegates;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.te.launch.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.launch.core.bindings.LaunchConfigTypeBindingsManager;
import org.eclipse.tcf.te.launch.core.delegates.Launch;
import org.eclipse.tcf.te.launch.core.interfaces.IReferencedProjectItem;
import org.eclipse.tcf.te.launch.core.lm.interfaces.ILaunchManagerDelegate;
import org.eclipse.tcf.te.launch.core.nls.Messages;
import org.eclipse.tcf.te.launch.core.persistence.projects.ReferencedProjectsPersistenceDelegate;
import org.eclipse.tcf.te.runtime.interfaces.ISharedConstants;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepContext;
import org.eclipse.tcf.te.runtime.stepper.stepper.Stepper;

public class LaunchConfigurationDelegate
extends org.eclipse.debug.core.model.LaunchConfigurationDelegate {
    protected void buildProjects(final IProject[] projects, IProgressMonitor monitor) throws CoreException {
        IWorkspaceRunnable build = new IWorkspaceRunnable(){

            public void run(IProgressMonitor pm) throws CoreException {
                SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)pm, (String)Messages.AbstractLaunchConfigurationDelegate_scoped_incremental_build, (int)projects.length);
                try {
                    IProject[] iProjectArray = projects;
                    int n = projects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProject project = iProjectArray[n2];
                        if (localmonitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        project.build(10, (IProgressMonitor)localmonitor.newChild(1));
                        ++n2;
                    }
                }
                finally {
                    localmonitor.done();
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(build, null, 1, monitor);
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        block12: {
            Assert.isNotNull((Object)configuration);
            Assert.isNotNull((Object)mode);
            Assert.isNotNull((Object)launch);
            long startTime = System.currentTimeMillis();
            ILaunchConfigurationWorkingCopy launchConfig = configuration.getWorkingCopy();
            launchConfig.setAttribute("org.eclipse.tcf.te.launch.lastLaunched", Long.toString(startTime));
            launchConfig.doSave();
            CoreBundleActivator.getTraceHandler().trace("LaunchConfigurationDelegate#launch: *** ENTERED (" + configuration.getName() + ")", 0, "trace/stepping", 2, (Object)this);
            CoreBundleActivator.getTraceHandler().trace(" [" + ISharedConstants.TIME_FORMAT.format(new Date(startTime)) + "]" + " ***", 0, "profile/stepping", 2, (Object)this);
            launch.setAttribute("launchSequenceCompleted", Boolean.FALSE.toString());
            Stepper stepper = new Stepper(launchConfig.getName());
            IStatus status = null;
            try {
                try {
                    IPropertiesContainer properties = (IPropertiesContainer)launch.getAdapter(IPropertiesContainer.class);
                    Assert.isNotNull((Object)properties);
                    String stepGroupId = LaunchConfigTypeBindingsManager.getInstance().getStepGroupId(launchConfig.getType().getIdentifier(), launch.getLaunchMode());
                    IStepContext context = (IStepContext)launch.getAdapter(IStepContext.class);
                    properties.setProperty("org.eclipse.tcf.te.runtime.stepper.skip_last_run_history", true);
                    stepper.initialize(context, stepGroupId, properties, monitor);
                    stepper.execute();
                }
                catch (CoreException e) {
                    status = e.getStatus();
                    ILaunchManagerDelegate delegate = LaunchConfigTypeBindingsManager.getInstance().getLaunchManagerDelegate(configuration.getType().getIdentifier(), mode);
                    if (status == null || status.getSeverity() == 4 && delegate.showLaunchDialog(99)) {
                        throw e;
                    }
                    IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler(status);
                    if (handler == null) {
                        throw e;
                    }
                    handler.handleStatus(status, (Object)this);
                    if (!launch.hasChildren()) {
                        DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                        if (monitor != null) {
                            monitor.setCanceled(true);
                        }
                    }
                    if (monitor == null || monitor.isCanceled()) {
                        DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                    }
                    stepper.cleanup();
                    launch.setAttribute("launchSequenceCompleted", Boolean.TRUE.toString());
                    this.onLaunchFinished(launch, status != null ? status : Status.OK_STATUS);
                    long endTime = System.currentTimeMillis();
                    CoreBundleActivator.getTraceHandler().trace("LaunchConfigurationDelegate#launch: *** DONE (" + configuration.getName() + ")", 0, "trace/stepping", 2, (Object)this);
                    CoreBundleActivator.getTraceHandler().trace(" [" + ISharedConstants.TIME_FORMAT.format(new Date(endTime)) + " , delay = " + (endTime - startTime) + " ms]" + " ***", 0, "profile/stepping", 2, (Object)this);
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (monitor == null || monitor.isCanceled()) {
                    DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                }
                stepper.cleanup();
                launch.setAttribute("launchSequenceCompleted", Boolean.TRUE.toString());
                this.onLaunchFinished(launch, status != null ? status : Status.OK_STATUS);
                long endTime = System.currentTimeMillis();
                CoreBundleActivator.getTraceHandler().trace("LaunchConfigurationDelegate#launch: *** DONE (" + configuration.getName() + ")", 0, "trace/stepping", 2, (Object)this);
                CoreBundleActivator.getTraceHandler().trace(" [" + ISharedConstants.TIME_FORMAT.format(new Date(endTime)) + " , delay = " + (endTime - startTime) + " ms]" + " ***", 0, "profile/stepping", 2, (Object)this);
                throw throwable;
            }
            if (monitor == null || monitor.isCanceled()) {
                DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
            }
            stepper.cleanup();
            launch.setAttribute("launchSequenceCompleted", Boolean.TRUE.toString());
            this.onLaunchFinished(launch, status != null ? status : Status.OK_STATUS);
            long endTime = System.currentTimeMillis();
            CoreBundleActivator.getTraceHandler().trace("LaunchConfigurationDelegate#launch: *** DONE (" + configuration.getName() + ")", 0, "trace/stepping", 2, (Object)this);
            CoreBundleActivator.getTraceHandler().trace(" [" + ISharedConstants.TIME_FORMAT.format(new Date(endTime)) + " , delay = " + (endTime - startTime) + " ms]" + " ***", 0, "profile/stepping", 2, (Object)this);
        }
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return new Launch(configuration, mode, null);
    }

    protected IProject[] getProjectsForProblemSearch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return this.getBuildOrder(configuration, mode);
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        IReferencedProjectItem[] items;
        ArrayList<IProject> projects = new ArrayList<IProject>();
        IReferencedProjectItem[] iReferencedProjectItemArray = items = ReferencedProjectsPersistenceDelegate.getReferencedProjects(configuration);
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IReferencedProjectItem item = iReferencedProjectItemArray[n2];
            if (item.isProperty("enabled", true) && item.getStringProperty("project_name") != null) {
                IProject project = this.findProjectResource(item.getStringProperty("project_name"));
                projects.add(project);
            }
            ++n2;
        }
        this.checkForDuplicatesAndSubProjects(projects);
        return projects.toArray(new IProject[projects.size()]);
    }

    protected IProject findProjectResource(String projectName) throws CoreException {
        Assert.isNotNull((Object)projectName);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        if (project != null && !project.isAccessible()) {
            throw new CoreException((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), NLS.bind((String)Messages.LaunchConfigurationDelegate_error_inaccessibleReferencedProject, (Object)projectName)));
        }
        return project;
    }

    protected void checkForDuplicatesAndSubProjects(List<IProject> projects) {
        Assert.isNotNull(projects);
        ArrayList<String> processedProjectNames = new ArrayList<String>();
        ListIterator<IProject> iterator = projects.listIterator();
        while (iterator.hasNext()) {
            IProject project = iterator.next();
            if (processedProjectNames.contains(project.getName())) {
                iterator.remove();
                continue;
            }
            processedProjectNames.add(project.getName());
        }
    }

    public IBreakpoint[] getBreakpoints(ILaunchConfiguration configuration) {
        return super.getBreakpoints(configuration);
    }

    protected void onLaunchFinished(ILaunch launch, IStatus status) {
    }
}

