/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.core.launcher;

import java.util.EventObject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.services.IProcesses;
import org.eclipse.tcf.te.runtime.events.EventManager;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.processes.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.processes.core.interfaces.launcher.IProcessContextAwareListener;
import org.eclipse.tcf.te.tcf.processes.core.launcher.ProcessLauncher;
import org.eclipse.tcf.te.tcf.processes.core.launcher.ProcessStateChangeEvent;

public class ProcessProcessesListener
implements IProcesses.ProcessesListener,
IProcessContextAwareListener {
    private final ProcessLauncher parent;
    private IProcesses.ProcessContext context;
    private boolean exitedCalled = false;

    public ProcessProcessesListener(ProcessLauncher parent) {
        Assert.isNotNull((Object)parent);
        this.parent = parent;
    }

    protected final ProcessLauncher getParent() {
        return this.parent;
    }

    public void dispose(ICallback callback) {
        if (!this.exitedCalled && this.context != null) {
            ProcessStateChangeEvent event = new ProcessStateChangeEvent(this.context, "lostCommunication", Boolean.FALSE, Boolean.TRUE, -1);
            EventManager.getInstance().fireEvent((EventObject)((Object)event));
        }
        if (callback != null) {
            callback.done((Object)this, Status.OK_STATUS);
        }
    }

    @Override
    public void setProcessContext(IProcesses.ProcessContext context) {
        Assert.isNotNull((Object)context);
        this.context = context;
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/launcher/processesListener")) {
            CoreBundleActivator.getTraceHandler().trace("Process context set to: id='" + context.getID() + "', name='" + context.getName() + "'", 0, "trace/launcher/processesListener", 1, this.getClass());
        }
    }

    @Override
    public IProcesses.ProcessContext getProcessContext() {
        return this.context;
    }

    public void exited(String processId, int exitCode) {
        IProcesses.ProcessContext context;
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/launcher/processesListener")) {
            CoreBundleActivator.getTraceHandler().trace("Process context terminated: id='" + processId + "', exitCode='" + exitCode + "'", 0, "trace/launcher/processesListener", 1, this.getClass());
        }
        if ((context = this.getProcessContext()) != null && processId != null && processId.equals(context.getID())) {
            this.exitedCalled = true;
            ProcessStateChangeEvent event = this.createRemoteProcessStateChangeEvent(context, exitCode);
            EventManager.getInstance().fireEvent((EventObject)((Object)event));
            this.getParent().processExited();
        }
    }

    protected ProcessStateChangeEvent createRemoteProcessStateChangeEvent(IProcesses.ProcessContext context, int exitCode) {
        Assert.isNotNull((Object)context);
        return new ProcessStateChangeEvent(context, "terminated", Boolean.FALSE, Boolean.TRUE, exitCode);
    }
}

