/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.core.jobs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.runtime.statushandler.StatusHandlerManager;
import org.eclipse.tcf.te.runtime.statushandler.interfaces.IStatusHandler;
import org.eclipse.tcf.te.tcf.core.help.IContextHelpIds;
import org.eclipse.tcf.te.tcf.core.nls.Messages;

public abstract class AbstractJob
extends Job {
    final ICallback parentCallback;

    public AbstractJob(String name) {
        this(name, null);
    }

    public AbstractJob(String name, ICallback parentCallback) {
        super(name);
        this.parentCallback = parentCallback;
    }

    protected final IStatus run(final IProgressMonitor monitor) {
        Protocol.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                AbstractJob.this.setThread(Thread.currentThread());
            }
        });
        final IProgressMonitor finMonitor = monitor;
        Callback callback = new Callback(){

            protected void internalDone(final Object caller, final IStatus status) {
                if (AbstractJob.this.parentCallback == null) {
                    IStatusHandler[] handler;
                    if (status != null && status.getSeverity() != 8 && status.getSeverity() != 0 && (handler = StatusHandlerManager.getInstance().getHandler((Object)AbstractJob.this)).length > 0) {
                        PropertiesContainer data = new PropertiesContainer();
                        data.setProperty("title", this.getProperty("title") != null ? this.getProperty("title") : Messages.AbstractJob_error_dialogTitle);
                        data.setProperty("contextHelpId", this.getProperty("contextHelpId") != null ? this.getProperty("contextHelpId") : IContextHelpIds.MESSAGE_OPERATION_FAILED);
                        data.setProperty("caller", (Object)AbstractJob.this);
                        handler[0].handleStatus(status, (IPropertiesContainer)data, null);
                    }
                } else {
                    Protocol.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            (this).AbstractJob.this.parentCallback.done(caller, status);
                        }
                    });
                }
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        IStatus result = finMonitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
                        AbstractJob.this.done(result);
                    }
                };
                if (Protocol.isDispatchThread()) {
                    runnable.run();
                } else {
                    Protocol.invokeLater((Runnable)runnable);
                }
            }
        };
        Protocol.invokeLater((Runnable)new Runnable((ICallback)callback){
            private final /* synthetic */ ICallback val$callback;
            {
                this.val$callback = iCallback;
            }

            @Override
            public void run() {
                AbstractJob.this.run(monitor, this.val$callback);
            }
        });
        return ASYNC_FINISH;
    }

    public abstract void run(IProgressMonitor var1, ICallback var2);
}

