/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.model;

import java.util.HashMap;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildren;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildrenStackTrace;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExpression;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeStackFrame;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IExpressions;

public class TCFChildrenLocalVariables
extends TCFChildren {
    private final TCFNodeStackFrame node;

    TCFChildrenLocalVariables(TCFNodeStackFrame node) {
        super(node, 128);
        this.node = node;
    }

    void onSuspended(boolean func_call) {
        if (!func_call) {
            this.reset();
        }
        for (TCFNode n : this.getNodes()) {
            ((TCFNodeExpression)n).onSuspended(func_call);
        }
    }

    void onRegisterValueChanged() {
        for (TCFNode n : this.getNodes()) {
            ((TCFNodeExpression)n).onRegisterValueChanged();
        }
    }

    void onMemoryChanged() {
        for (TCFNode n : this.getNodes()) {
            ((TCFNodeExpression)n).onMemoryChanged();
        }
    }

    void onMemoryMapChanged() {
        this.reset();
        for (TCFNode n : this.getNodes()) {
            ((TCFNodeExpression)n).onMemoryMapChanged();
        }
    }

    protected boolean startDataRetrieval() {
        IExpressions exps = (IExpressions)this.node.model.getLaunch().getService(IExpressions.class);
        if (exps == null || this.node.isEmulated()) {
            this.set(null, null, new HashMap<String, TCFNode>());
            return true;
        }
        TCFChildrenStackTrace stack_trace_cache = ((TCFNodeExecContext)this.node.parent).getStackTrace();
        if (!stack_trace_cache.validate((Runnable)((Object)this))) {
            return false;
        }
        if (this.node.getFrameNo() < 0) {
            this.set(null, null, new HashMap<String, TCFNode>());
            return true;
        }
        assert (this.command == null);
        this.command = exps.getChildren(this.node.id, new IExpressions.DoneGetChildren(){

            public void doneGetChildren(IToken token, Exception error, String[] contexts) {
                HashMap<String, TCFNodeExpression> data = null;
                if (TCFChildrenLocalVariables.this.command == token && error == null) {
                    int cnt = 0;
                    data = new HashMap<String, TCFNodeExpression>();
                    String[] stringArray = contexts;
                    int n = contexts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String id = stringArray[n2];
                        TCFNodeExpression n3 = (TCFNodeExpression)((TCFChildrenLocalVariables)TCFChildrenLocalVariables.this).node.model.getNode(id);
                        if (n3 == null) {
                            n3 = new TCFNodeExpression(TCFChildrenLocalVariables.this.node, null, null, id, null, -1, false);
                        }
                        if (!$assertionsDisabled && !n3.id.equals(id)) {
                            throw new AssertionError();
                        }
                        if (!$assertionsDisabled && n3.parent != TCFChildrenLocalVariables.this.node) {
                            throw new AssertionError();
                        }
                        n3.setSortPosition(cnt++);
                        data.put(n3.id, n3);
                        ++n2;
                    }
                }
                TCFChildrenLocalVariables.this.set(token, (Throwable)error, data);
            }
        });
        return false;
    }
}

