/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.ext.widgets.reference.internal;

import org.eclipse.eef.EEFWidgetDescription;
import org.eclipse.eef.common.api.utils.Util;
import org.eclipse.eef.common.ui.api.EEFWidgetFactory;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.IEEFWidgetController;
import org.eclipse.eef.core.ext.widgets.reference.internal.EEFExtReferenceController;
import org.eclipse.eef.ext.widgets.reference.eefextwidgetsreference.EEFExtReferenceDescription;
import org.eclipse.eef.ide.ui.api.widgets.AbstractEEFWidgetLifecycleManager;
import org.eclipse.eef.ide.ui.api.widgets.EEFStyleHelper;
import org.eclipse.eef.ide.ui.ext.widgets.reference.internal.EEFExtStyleHelper;
import org.eclipse.eef.ide.ui.ext.widgets.reference.internal.Messages;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractEEFExtReferenceLifecycleManager
extends AbstractEEFWidgetLifecycleManager {
    private static final int MINIMUM_BUTTON_WIDTH = 80;
    protected final EEFExtReferenceDescription description;
    protected final EObject target;
    protected final EReference eReference;
    protected EEFExtReferenceController controller;
    protected ComposedAdapterFactory composedAdapterFactory;
    protected EEFWidgetFactory widgetFactory;
    protected Button browseButton;
    protected ButtonSelectionListener browseButtonListener;
    protected Button addButton;
    protected ButtonSelectionListener addButtonListener;
    protected Button removeButton;
    protected ButtonSelectionListener removeButtonListener;

    public AbstractEEFExtReferenceLifecycleManager(EEFExtReferenceDescription description, EObject target, EReference eReference, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter editingContextAdapter) {
        super(variableManager, interpreter, editingContextAdapter);
        this.description = description;
        this.target = target;
        this.eReference = eReference;
    }

    protected IEEFWidgetController getController() {
        return this.controller;
    }

    protected EEFWidgetDescription getWidgetDescription() {
        return this.description;
    }

    protected Button createButton(Composite parent, Image image) {
        Button button = this.widgetFactory.createButton(parent, "", 0);
        button.setImage(image);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.minimumWidth = 80;
        button.setLayoutData((Object)gridData);
        return button;
    }

    protected abstract void createButtons(Composite var1);

    public void aboutToBeShown() {
        super.aboutToBeShown();
        if (!this.eReference.isContainment()) {
            this.initializeBrowseButton();
        }
        this.initializeAddButton();
        this.initializeRemoveButton();
    }

    protected void initializeBrowseButton() {
        this.browseButtonListener = new ButtonSelectionListener(this.editingContextAdapter, () -> this.browseButtonCallback());
        this.browseButton.addSelectionListener((SelectionListener)this.browseButtonListener);
        this.browseButton.setToolTipText(Messages.ReferenceBrowseButton_tooltipText);
    }

    protected abstract void browseButtonCallback();

    protected void initializeAddButton() {
        this.addButtonListener = new ButtonSelectionListener(this.editingContextAdapter, () -> this.addButtonCallback());
        this.addButton.addSelectionListener((SelectionListener)this.addButtonListener);
        this.addButton.setToolTipText(Messages.ReferenceAddButton_tooltipText);
    }

    protected abstract void addButtonCallback();

    protected void initializeRemoveButton() {
        this.removeButtonListener = new ButtonSelectionListener(this.editingContextAdapter, () -> this.removeButtonCallback());
        this.removeButton.addSelectionListener((SelectionListener)this.removeButtonListener);
        if (this.eReference.isContainment()) {
            this.removeButton.setToolTipText(Messages.ReferenceRemoveButton_containmentTooltipText);
        } else {
            this.removeButton.setToolTipText(Messages.ReferenceRemoveButton_nonContainmentTooltipText);
        }
    }

    protected abstract void removeButtonCallback();

    public void refresh() {
        Adapter adapter;
        super.refresh();
        if (Util.isBlank((String)this.description.getLabelExpression()) && (adapter = this.composedAdapterFactory.adapt((Notifier)this.target, IItemPropertySource.class)) instanceof IItemPropertySource) {
            IItemPropertySource propertySource = (IItemPropertySource)adapter;
            IItemPropertyDescriptor propertyDescriptor = propertySource.getPropertyDescriptor((Object)this.target, (Object)this.eReference);
            if (propertyDescriptor != null) {
                String displayName = propertyDescriptor.getDisplayName((Object)this.eReference);
                this.label.setText(displayName);
            } else {
                this.label.setText(this.eReference.getName());
            }
        }
        this.setLabelFontStyle();
    }

    protected void setEnabled(boolean isEnabled) {
        if (this.addButton != null && !this.addButton.isDisposed()) {
            this.addButton.setEnabled(isEnabled);
        }
        if (this.removeButton != null && !this.removeButton.isDisposed()) {
            this.removeButton.setEnabled(isEnabled);
        }
        if (this.browseButton != null && !this.browseButton.isDisposed()) {
            this.browseButton.setEnabled(isEnabled);
        }
    }

    protected boolean isEnabled() {
        return super.isEnabled() && this.eReference.isChangeable();
    }

    public void aboutToBeHidden() {
        super.aboutToBeHidden();
        if (!this.eReference.isContainment()) {
            this.removeListener(this.browseButton, this.browseButtonListener);
        }
        this.removeListener(this.addButton, this.addButtonListener);
        this.removeListener(this.removeButton, this.removeButtonListener);
    }

    protected void removeListener(Button button, ButtonSelectionListener listener) {
        if (button != null && !button.isDisposed()) {
            button.removeSelectionListener((SelectionListener)listener);
        }
    }

    public void dispose() {
        super.dispose();
        this.composedAdapterFactory.dispose();
    }

    protected EEFStyleHelper getEEFStyleHelper() {
        return new EEFExtStyleHelper(this.interpreter, this.variableManager);
    }

    protected static class ButtonSelectionListener
    implements SelectionListener {
        private EditingContextAdapter editingContextAdapter;
        private Runnable runnable;

        public ButtonSelectionListener(EditingContextAdapter editingContextAdapter, Runnable runnable) {
            this.editingContextAdapter = editingContextAdapter;
            this.runnable = runnable;
        }

        public void widgetSelected(SelectionEvent event) {
            this.editingContextAdapter.performModelChange(this.runnable);
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.editingContextAdapter.performModelChange(this.runnable);
        }
    }
}

