/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.shellwax.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.runtime.Platform;
import org.eclipse.lsp4e.server.ProcessStreamConnectionProvider;
import org.eclipse.wildwebdeveloper.embedder.node.NodeJSManager;

public class BashLanguageServer
extends ProcessStreamConnectionProvider {
    private static final String LS_VERSION = "5.6.0";
    private static final String LOCAL_PATH = "/.local/share/shellwax/5.6.0";
    private static final String LS_MAIN = "/node_modules/.bin/bash-language-server";
    private static CompletableFuture<Void> initializeFuture;

    private static String getLsPath() {
        Object lsPath = System.getProperty("user.home") + "/.local/share/shellwax/5.6.0/node_modules/.bin/bash-language-server";
        if (Platform.OS.isWindows()) {
            lsPath = ((String)lsPath).replace('/', '\\');
        }
        return lsPath;
    }

    private static boolean isInstalled() {
        File installLocation = new File(BashLanguageServer.getLsPath());
        return installLocation.exists() && installLocation.canExecute();
    }

    public BashLanguageServer() {
        ArrayList<Object> commands = new ArrayList<Object>();
        String nodePath = NodeJSManager.getNodeJsLocation().getAbsolutePath();
        if (nodePath != null) {
            if (!BashLanguageServer.isInstalled()) {
                this.installLS();
            }
            String lsPath = BashLanguageServer.getLsPath();
            if (Platform.OS.isWindows()) {
                commands.add("cmd");
                commands.add("/c");
                commands.add("\"\"" + lsPath + "\" start\"");
            } else {
                commands.add(nodePath);
                commands.add(lsPath);
                commands.add("start");
            }
            this.setCommands(commands);
            this.setWorkingDirectory(System.getProperty("user.dir"));
        }
    }

    public void start() throws IOException {
        if (!BashLanguageServer.isInstalled()) {
            this.installLS().join();
        }
        super.start();
    }

    private synchronized CompletableFuture<Void> installLS() {
        if (initializeFuture == null) {
            initializeFuture = CompletableFuture.runAsync(() -> {
                File installLocation = new File(System.getProperty("user.home") + LOCAL_PATH);
                if (!installLocation.isDirectory()) {
                    installLocation.delete();
                }
                if (!installLocation.exists()) {
                    installLocation.mkdirs();
                    File nodeModulesDir = new File(installLocation, "node_modules");
                    nodeModulesDir.mkdir();
                }
                ProcessBuilder pb = NodeJSManager.prepareNPMProcessBuilder((String[])new String[]{"install", "--prefix=.", "bash-language-server@5.6.0"});
                pb.directory(installLocation);
                pb.inheritIO();
                try {
                    Process ps = pb.start();
                    ps.waitFor();
                }
                catch (IOException | InterruptedException e) {
                    e.printStackTrace();
                }
            });
        }
        return initializeFuture;
    }
}

