/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.runtime.spy.dialogs;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.databinding.observable.list.ComputedList;
import org.eclipse.core.databinding.observable.sideeffect.CompositeSideEffect;
import org.eclipse.core.databinding.observable.sideeffect.ISideEffectFactory;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.runtime.PDERuntimePluginImages;
import org.eclipse.pde.internal.runtime.spy.dialogs.ControlSelector;
import org.eclipse.pde.internal.runtime.spy.dialogs.GeometryUtil;
import org.eclipse.pde.internal.runtime.spy.dialogs.Messages;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class LayoutSpyDialog {
    private static final int EDGE_SIZE = 4;
    private static final RGB SELECTED_PARENT_OVERLAY_COLOR = new RGB(255, 0, 0);
    private static final RGB SELECTED_CHILD_OVERLAY_COLOR = new RGB(255, 255, 0);
    private static final int UNKNOWN = -2;
    private Shell shell;
    private TableViewer childList;
    private Text details;
    private Button selectWidgetButton;
    private Button goUpButton;
    private Button goDownButton;
    private Shell overlay;
    private WritableValue<Composite> parentControl = new WritableValue(null, null);
    private WritableValue<Boolean> controlSelectorOpen = new WritableValue((Object)Boolean.FALSE, null);
    private ComputedList<Control> listContents;
    private IViewerObservableValue selectedChild;
    private Color parentRectangleColor;
    private Color childRectangleColor;
    private ResourceManager resources;
    private ISWTObservableValue overlayEnabled;
    private Image upImage;
    private Text diagnostics;

    public LayoutSpyDialog(Shell parentShell) {
        this.overlay = new Shell(16392);
        this.overlay.addPaintListener((PaintListener & Serializable)paintEvent -> this.paintOverlay(paintEvent));
        this.shell = new Shell(parentShell, 1264);
        this.shell.setText(Messages.get().LayoutSpyDialog_shell_text);
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)this.shell);
        this.parentRectangleColor = this.resources.createColor(SELECTED_PARENT_OVERLAY_COLOR);
        this.childRectangleColor = this.resources.createColor(SELECTED_CHILD_OVERLAY_COLOR);
        this.upImage = this.resources.createImage(PDERuntimePluginImages.UP_NAV);
        Composite infoRegion = new Composite((Composite)this.shell, 0);
        Composite headerRegion = new Composite(infoRegion, 0);
        Button upButton = new Button(headerRegion, 0x1000008);
        upButton.setImage(this.upImage);
        upButton.addListener(13, (Listener & Serializable)event -> this.goUp());
        GridDataFactory.fillDefaults().applyTo((Control)upButton);
        Label childrenLabel = new Label(headerRegion, 0);
        childrenLabel.setText(Messages.get().LayoutSpyDialog_label_children);
        GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(headerRegion);
        Label detailsLabel = new Label(infoRegion, 0);
        detailsLabel.setText(Messages.get().LayoutSpyDialog_label_layout);
        this.childList = new TableViewer(infoRegion);
        this.details = new Text(infoRegion, 2826);
        GridDataFactory.fillDefaults().hint(300, 300).grab(true, true).applyTo((Control)this.details);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(true).generateLayout(infoRegion);
        this.diagnostics = new Text((Composite)this.shell, 2826);
        GridDataFactory.fillDefaults().hint(300, 300).grab(true, true).applyTo((Control)this.diagnostics);
        Button showOverlayButton = new Button((Composite)this.shell, 32);
        showOverlayButton.setText(Messages.get().LayoutSpyDialog_button_show_overlay);
        Composite buttonBar = new Composite((Composite)this.shell, 0);
        this.selectWidgetButton = new Button(buttonBar, 8);
        this.selectWidgetButton.setText(Messages.get().LayoutSpyDialog_button_select_control);
        this.goUpButton = new Button(buttonBar, 8);
        this.goUpButton.setText(Messages.get().LayoutSpyDialog_button_open_parent);
        this.goDownButton = new Button(buttonBar, 8);
        this.goDownButton.setText(Messages.get().LayoutSpyDialog_button_open_child);
        GridLayoutFactory.fillDefaults().numColumns(3).generateLayout(buttonBar);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)buttonBar);
        GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).generateLayout((Composite)this.shell);
        this.shell.addDisposeListener((DisposeListener & Serializable)event -> this.disposed());
        this.selectWidgetButton.addListener(13, (Listener & Serializable)event -> this.selectControl());
        this.goUpButton.addListener(13, (Listener & Serializable)event -> this.goUp());
        this.goDownButton.addListener(13, (Listener & Serializable)event -> this.goDown());
        this.childList.addOpenListener(event -> this.goDown());
        this.selectedChild = ViewerProperties.singleSelection().observe((Viewer)this.childList);
        this.overlayEnabled = WidgetProperties.selection().observe((Widget)showOverlayButton);
        this.childList.setContentProvider((IContentProvider)new ObservableListContentProvider());
        this.listContents = new ComputedList<Control>(){

            protected List<Control> calculate() {
                Composite control = (Composite)LayoutSpyDialog.this.parentControl.getValue();
                if (control == null) {
                    return Arrays.asList(Display.getCurrent().getShells());
                }
                return Arrays.asList(control.getChildren());
            }
        };
        this.childList.setInput(this.listContents);
        ISideEffectFactory sideEffectFactory = LayoutSpyDialog.createFactory((Widget)this.shell);
        sideEffectFactory.create(this::computeParentInfo, arg_0 -> ((Text)this.details).setText(arg_0));
        sideEffectFactory.create(this::computeChildInfo, arg_0 -> ((Text)this.diagnostics).setText(arg_0));
        sideEffectFactory.create(this::updateOverlay);
        this.openComposite((Composite)parentShell);
    }

    public static ISideEffectFactory createFactory(Widget disposableWidget) {
        CompositeSideEffect compositeSideEffect = (CompositeSideEffect)disposableWidget.getData(CompositeSideEffect.class.getName());
        if (compositeSideEffect == null) {
            CompositeSideEffect newCompositeSideEffect = new CompositeSideEffect();
            disposableWidget.setData(CompositeSideEffect.class.getName(), (Object)newCompositeSideEffect);
            disposableWidget.addDisposeListener((DisposeListener & Serializable)e -> newCompositeSideEffect.dispose());
            compositeSideEffect = newCompositeSideEffect;
        }
        return ISideEffectFactory.createFactory(arg_0 -> ((CompositeSideEffect)compositeSideEffect).add(arg_0));
    }

    public void open() {
        this.shell.pack();
        this.shell.open();
    }

    public void close() {
        this.shell.dispose();
    }

    private void disposed() {
        this.listContents.dispose();
        this.selectedChild.dispose();
        this.parentControl.dispose();
        this.overlay.dispose();
    }

    private void openComposite(Composite composite) {
        this.parentControl.setValue((Object)composite);
    }

    private Control getSelectedChild() {
        return (Control)this.selectedChild.getValue();
    }

    private void openControl(Control control) {
        Composite parent = control.getParent();
        if (parent == null) {
            if (control instanceof Composite) {
                this.parentControl.setValue((Object)((Composite)control));
            }
        } else {
            this.parentControl.setValue((Object)parent);
            this.selectedChild.setValue((Object)control);
        }
    }

    public void updateOverlay() {
        Composite parent = (Composite)this.parentControl.getValue();
        boolean enabled = Boolean.TRUE.equals(this.overlayEnabled.getValue());
        this.overlay.setVisible(parent != null && (Boolean)this.controlSelectorOpen.getValue() == false && enabled);
        if (parent == null) {
            return;
        }
        Shell shell = parent.getShell();
        Rectangle outerBounds = Geometry.copy((Rectangle)shell.getBounds());
        this.overlay.setBounds(outerBounds);
        Rectangle parentBoundsWrtDisplay = GeometryUtil.getDisplayBounds((Control)parent);
        Rectangle parentBoundsWrtOverlay = Geometry.toControl((Control)this.overlay, (Rectangle)parentBoundsWrtDisplay);
        Rectangle innerBoundsWrtOverlay = Geometry.copy((Rectangle)parentBoundsWrtOverlay);
        Geometry.expand((Rectangle)innerBoundsWrtOverlay, (int)-4, (int)-4, (int)-4, (int)-4);
        Control child = (Control)this.selectedChild.getValue();
        if (child != null) {
            Rectangle childBoundsWrtOverlay = Geometry.toControl((Control)this.overlay, (Rectangle)GeometryUtil.getDisplayBounds(child));
            Rectangle childInnerBoundsWrtOverlay = Geometry.copy((Rectangle)childBoundsWrtOverlay);
            Geometry.expand((Rectangle)childInnerBoundsWrtOverlay, (int)-4, (int)-4, (int)-4, (int)-4);
            int cfr_ignored_0 = childBoundsWrtOverlay.y;
            int cfr_ignored_1 = innerBoundsWrtOverlay.y;
            int cfr_ignored_2 = childBoundsWrtOverlay.x;
            int cfr_ignored_3 = innerBoundsWrtOverlay.x;
            GeometryUtil.getRight(innerBoundsWrtOverlay);
            GeometryUtil.getRight(childBoundsWrtOverlay);
            GeometryUtil.getBottom(innerBoundsWrtOverlay);
            GeometryUtil.getBottom(childBoundsWrtOverlay);
        }
        this.overlay.redraw();
    }

    protected void paintOverlay(PaintEvent e) {
        Composite parent = (Composite)this.parentControl.getValue();
        if (parent == null) {
            return;
        }
        int halfSize = 2;
        Rectangle parentDisplayBounds = GeometryUtil.getDisplayBounds((Control)parent);
        Rectangle parentBoundsWrtOverlay = Geometry.toControl((Control)this.overlay, (Rectangle)parentDisplayBounds);
        Geometry.expand((Rectangle)parentBoundsWrtOverlay, (int)(-halfSize), (int)(-halfSize), (int)(-halfSize), (int)(-halfSize));
        Control child = (Control)this.selectedChild.getValue();
        e.gc.setLineWidth(4);
        e.gc.setForeground(this.parentRectangleColor);
        e.gc.drawRectangle(parentBoundsWrtOverlay.x, parentBoundsWrtOverlay.y, parentBoundsWrtOverlay.width, parentBoundsWrtOverlay.height);
        if (child != null) {
            Rectangle childBoundsWrtOverlay = Geometry.toControl((Control)this.overlay, (Rectangle)GeometryUtil.getDisplayBounds(child));
            Geometry.expand((Rectangle)childBoundsWrtOverlay, (int)(-halfSize), (int)(-halfSize), (int)(-halfSize), (int)(-halfSize));
            e.gc.setForeground(this.childRectangleColor);
            e.gc.drawRectangle(childBoundsWrtOverlay.x, childBoundsWrtOverlay.y, childBoundsWrtOverlay.width, childBoundsWrtOverlay.height);
        }
    }

    private void selectControl() {
        this.controlSelectorOpen.setValue((Object)true);
        this.shell.setVisible(false);
        new ControlSelector(control -> {
            if (control != null) {
                this.openControl((Control)control);
            }
            this.controlSelectorOpen.setValue((Object)false);
            this.shell.setVisible(true);
        });
    }

    private void goUp() {
        Composite parent = (Composite)this.parentControl.getValue();
        if (parent == null) {
            return;
        }
        Composite ancestor = parent.getParent();
        this.openComposite(ancestor);
        this.selectedChild.setValue((Object)parent);
    }

    private void goDown() {
        Control child = this.getSelectedChild();
        if (child instanceof Composite) {
            Composite composite = (Composite)child;
            this.openComposite(composite);
        }
    }

    private String getWarningMessage(String string) {
        return NLS.bind((String)Messages.get().LayoutSpyDialog_warning_prefix, (Object)string);
    }

    private static String printHint(int hint) {
        if (hint == -1) {
            return "SWT.DEFAULT";
        }
        return Integer.toString(hint);
    }

    private static String printPoint(Point toPrint) {
        return NLS.bind((String)"({0}, {1})", (Object[])new Object[]{toPrint.x, toPrint.y});
    }

    private static boolean isHorizontallyScrollable(Control child) {
        return (child.getStyle() & 0x100) != 0;
    }

    private static boolean isVerticallyScrollable(Control child) {
        return (child.getStyle() & 0x200) != 0;
    }

    private static Point computeHintAdjustment(Control control) {
        int heightAdjustment;
        int widthAdjustment;
        if (control instanceof Scrollable) {
            Scrollable composite = (Scrollable)control;
            Rectangle trim = composite.computeTrim(0, 0, 0, 0);
            widthAdjustment = trim.width;
            heightAdjustment = trim.height;
        } else {
            heightAdjustment = widthAdjustment = control.getBorderWidth() * 2;
        }
        return new Point(widthAdjustment, heightAdjustment);
    }

    private static boolean isGrowableLayout(Control control, boolean horizontal) {
        Composite composite;
        Layout theLayout;
        if (control instanceof Composite && (theLayout = (composite = (Composite)control).getLayout()) instanceof GridLayout) {
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                Control child = children[i];
                GridData data = (GridData)child.getLayoutData();
                if (data != null && (horizontal ? data.grabExcessHorizontalSpace : data.grabExcessVerticalSpace)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private static boolean overlapsSibling(Control toFind) {
        Composite parent = toFind.getParent();
        Control current = toFind;
        Rectangle displayBounds = GeometryUtil.getDisplayBounds(toFind);
        while (parent != null && !(parent instanceof Shell)) {
            Control[] controlArray = parent.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Rectangle nextSiblingBounds;
                Control nextSibling = controlArray[n2];
                if (nextSibling != current && nextSibling.isVisible() && (nextSiblingBounds = GeometryUtil.getDisplayBounds(nextSibling)).intersects(displayBounds)) {
                    return true;
                }
                ++n2;
            }
            current = parent;
            parent = parent.getParent();
        }
        return false;
    }

    private String computeChildInfo() {
        StringBuilder builder = new StringBuilder();
        Control child = this.getSelectedChild();
        if (child != null) {
            builder.append(child.getClass().getName());
            builder.append("\n\n");
            int widthHintFromLayoutData = -2;
            int heightHintFromLayoutData = -2;
            Object layoutData = child.getLayoutData();
            if (layoutData == null) {
                builder.append("getLayoutData() == null\n");
            } else if (layoutData instanceof GridData) {
                GridData grid = (GridData)layoutData;
                builder.append(GridDataFactory.createFrom((GridData)grid));
                widthHintFromLayoutData = grid.widthHint;
                heightHintFromLayoutData = grid.heightHint;
                if (!grid.grabExcessHorizontalSpace && (LayoutSpyDialog.isHorizontallyScrollable(child) || LayoutSpyDialog.isGrowableLayout(child, true))) {
                    builder.append(this.getWarningMessage(Messages.get().LayoutSpyDialog_warning_grab_horizontally_scrolling));
                }
                if (!grid.grabExcessVerticalSpace && (LayoutSpyDialog.isVerticallyScrollable(child) || LayoutSpyDialog.isGrowableLayout(child, false))) {
                    builder.append(this.getWarningMessage(Messages.get().LayoutSpyDialog_warning_grab_vertical_scrolling));
                }
            } else if (layoutData instanceof FormData) {
                FormData data = (FormData)layoutData;
                widthHintFromLayoutData = data.width;
                heightHintFromLayoutData = data.height;
            } else {
                this.describeObject(builder, "data", layoutData);
            }
            if (LayoutSpyDialog.isHorizontallyScrollable(child) && widthHintFromLayoutData == -1) {
                builder.append(this.getWarningMessage(Messages.get().LayoutSpyDialog_warning_hint_for_horizontally_scrollable));
            }
            if (LayoutSpyDialog.isVerticallyScrollable(child) && heightHintFromLayoutData == -1) {
                builder.append(this.getWarningMessage(Messages.get().LayoutSpyDialog_warning_hint_for_vertically_scrollable));
            }
            builder.append("\n");
            Rectangle bounds = child.getBounds();
            builder.append(NLS.bind((String)"getBounds() = {0}", (Object)bounds.toString()));
            builder.append("\n");
            Point adjustment = LayoutSpyDialog.computeHintAdjustment(child);
            int widthHint = Math.max(0, bounds.width - adjustment.x);
            int heightHint = Math.max(0, bounds.height - adjustment.y);
            builder.append(NLS.bind((String)"widthAdjustment = {0}, heightAdjustment = {1}", (Object[])new Object[]{adjustment.x, adjustment.y}));
            builder.append("\n\n");
            Point defaultSize = child.computeSize(-1, -1, false);
            builder.append(NLS.bind((String)"computeSize(SWT.DEFAULT, SWT.DEFAULT, false) = {0}", (Object)LayoutSpyDialog.printPoint(defaultSize)));
            builder.append("\n");
            Point hWrappedSize = child.computeSize(widthHint, -1, false);
            builder.append(NLS.bind((String)"computeSize({0} - widthAdjustment, SWT.DEFAULT, false) = {1}", (Object[])new Object[]{bounds.width, LayoutSpyDialog.printPoint(hWrappedSize)}));
            builder.append("\n");
            Point vWrappedSize = child.computeSize(-1, heightHint, false);
            builder.append(NLS.bind((String)"computeSize(SWT.DEFAULT, {0} - heightAdjustment, false) = {1}", (Object[])new Object[]{bounds.height, LayoutSpyDialog.printPoint(vWrappedSize)}));
            builder.append("\n");
            Point noOpSize = child.computeSize(widthHint, heightHint, false);
            if (noOpSize.x != bounds.width || noOpSize.y != bounds.height) {
                builder.append(this.getWarningMessage(NLS.bind((String)Messages.get().LayoutSpyDialog_warning_unexpected_compute_size, (Object[])new Object[]{LayoutSpyDialog.printHint(widthHint), LayoutSpyDialog.printHint(heightHint), LayoutSpyDialog.printPoint(noOpSize)})));
            }
            if (bounds.height < hWrappedSize.y) {
                builder.append(this.getWarningMessage(Messages.get().LayoutSpyDialog_warning_shorter_than_preferred_size));
            }
            this.printReasonControlIsInvisible(builder, child);
        }
        return builder.toString();
    }

    private void printReasonControlIsInvisible(StringBuilder builder, Control control) {
        if (!control.isVisible()) {
            builder.append(this.getWarningMessage("isVisible() == false"));
            return;
        }
        Rectangle bounds = control.getBounds();
        if (bounds.isEmpty()) {
            builder.append(this.getWarningMessage(Messages.get().LayoutSpyDialog_warning_zero_size));
            return;
        }
        Rectangle displayBounds = GeometryUtil.getDisplayBounds(control);
        Composite parent = control.getParent();
        if (parent != null) {
            Rectangle parentDisplayBounds = GeometryUtil.getDisplayBounds((Control)parent);
            Rectangle intersection = displayBounds.intersection(parentDisplayBounds);
            if (intersection.isEmpty()) {
                builder.append(this.getWarningMessage(Messages.get().LayoutSpyDialog_warning_bounds_outside_parent));
                return;
            }
            if (intersection.width < bounds.width || intersection.height < bounds.height) {
                builder.append(this.getWarningMessage(Messages.get().LayoutSpyDialog_warning_control_partially_clipped));
                return;
            }
            if (LayoutSpyDialog.overlapsSibling(control)) {
                builder.append(this.getWarningMessage(Messages.get().LayoutSpyDialog_warning_control_overlaps_siblings));
                return;
            }
        }
    }

    private String computeParentInfo() {
        StringBuilder builder = new StringBuilder();
        Composite parent = (Composite)this.parentControl.getValue();
        if (parent != null) {
            builder.append(parent.getClass().getName());
            builder.append("\n\n");
            Rectangle parentBounds = GeometryUtil.getDisplayBounds((Control)parent);
            Layout layout = parent.getLayout();
            if (layout != null) {
                if (layout instanceof GridLayout) {
                    GridLayout grid = (GridLayout)layout;
                    builder.append(GridLayoutFactory.createFrom((GridLayout)grid));
                    boolean hasVerticallyTruncadeControls = false;
                    boolean hasHorizontallyTruncadeControls = false;
                    boolean hasHorizontalGrab = false;
                    boolean hasVerticalGrab = false;
                    Control[] controlArray = parent.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control next = controlArray[n2];
                        GridData data = (GridData)next.getLayoutData();
                        if (data != null) {
                            Rectangle childBounds = GeometryUtil.getDisplayBounds((Control)parent);
                            Rectangle intersection = childBounds.intersection(parentBounds);
                            if (intersection.width < childBounds.width) {
                                hasHorizontallyTruncadeControls = true;
                            }
                            if (intersection.height < childBounds.height) {
                                hasVerticallyTruncadeControls = true;
                            }
                            hasHorizontalGrab = hasHorizontalGrab || data.grabExcessHorizontalSpace;
                            hasVerticalGrab = hasVerticalGrab || data.grabExcessVerticalSpace;
                        }
                        ++n2;
                    }
                    if (hasHorizontallyTruncadeControls && !hasHorizontalGrab) {
                        builder.append(this.getWarningMessage(Messages.get().LayoutSpyDialog_warning_not_grabbing_horizontally));
                    }
                    if (hasVerticallyTruncadeControls && !hasVerticalGrab) {
                        builder.append(this.getWarningMessage(Messages.get().LayoutSpyDialog_warning_not_grabbing_vertically));
                    }
                } else {
                    this.describeObject(builder, "layout", layout);
                }
            }
        } else {
            builder.append(Messages.get().LayoutSpyDialog_label_no_parent_control_selected);
        }
        return builder.toString();
    }

    void describeObject(StringBuilder result, String variableName, Object toDescribe) {
        Field[] fields;
        Class<?> clazz = toDescribe.getClass();
        result.append(clazz.getName());
        result.append(" ");
        result.append(variableName);
        result.append(";\n");
        Field[] fieldArray = fields = clazz.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field nextField = fieldArray[n2];
            int modifiers = nextField.getModifiers();
            if (Modifier.isPublic(modifiers)) {
                try {
                    String next = String.valueOf(variableName) + "." + nextField.getName() + " = " + nextField.get(toDescribe) + ";";
                    result.append(next);
                    result.append("\n");
                }
                catch (IllegalAccessException | IllegalArgumentException exception) {}
            }
            ++n2;
        }
    }
}

