/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rap.rwt.internal.lifecycle.ProcessActionRunner;
import org.eclipse.rap.rwt.internal.textsize.TextSizeUtil;
import org.eclipse.rap.rwt.internal.theme.IThemeAdapter;
import org.eclipse.rap.rwt.template.Template;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.internal.widgets.ICellToolTipAdapter;
import org.eclipse.swt.internal.widgets.ICellToolTipProvider;
import org.eclipse.swt.internal.widgets.IControlAdapter;
import org.eclipse.swt.internal.widgets.IItemHolderAdapter;
import org.eclipse.swt.internal.widgets.ITableAdapter;
import org.eclipse.swt.internal.widgets.ItemHolder;
import org.eclipse.swt.internal.widgets.MarkupUtil;
import org.eclipse.swt.internal.widgets.tablekit.TableThemeAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Table
extends Composite {
    public static final String ALWAYS_HIDE_SELECTION = String.valueOf(Table.class.getName()) + "#alwaysHideSelection";
    private static final int GRID_WIDTH = 1;
    private static final int[] EMPTY_SELECTION = new int[0];
    private transient CompositeItemHolder itemHolder;
    private final ITableAdapter tableAdapter = new TableAdapter();
    private int customItemHeight;
    private int itemCount;
    private TableItem[] items;
    private final ItemHolder<TableColumn> columnHolder = new ItemHolder<TableColumn>(TableColumn.class);
    private int[] columnImageCount;
    private int[] columnOrder;
    private int[] selection;
    private boolean linesVisible;
    private boolean headerVisible;
    private boolean hasVScrollBar;
    private boolean hasHScrollBar;
    private int topIndex;
    int leftOffset;
    private int focusIndex = -1;
    private TableColumn sortColumn;
    private int sortDirection = 0;
    private Point itemImageSize;
    private Rectangle bufferedCellPadding;
    private int bufferedCellSpacing;
    private int preloadedItems;

    public Table(Composite parent, int style) {
        super(parent, Table.checkStyle(style));
        this.setTableEmpty();
        this.selection = EMPTY_SELECTION;
        this.customItemHeight = -1;
        this.bufferedCellSpacing = -1;
    }

    @Override
    void initState() {
        this.state &= 0xFFFFFEFF;
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        Object result;
        if (adapter == IItemHolderAdapter.class) {
            if (this.itemHolder == null) {
                this.itemHolder = new CompositeItemHolder();
            }
            result = this.itemHolder;
        } else {
            result = adapter == ITableAdapter.class ? this.tableAdapter : (adapter == ICellToolTipAdapter.class ? this.tableAdapter : super.getAdapter(adapter));
        }
        return (T)result;
    }

    @Override
    public void setData(String key, Object value) {
        if ("org.eclipse.rap.rwt.customItemHeight".equals(key)) {
            this.setCustomItemHeight(value);
        } else if ("org.eclipse.rap.rwt.preloadedItems".equals(key)) {
            this.setPreloadedItems(value);
        }
        if (!"org.eclipse.rap.rwt.markupEnabled".equals(key) || !MarkupUtil.isMarkupEnabledFor(this)) {
            super.setData(key, value);
        }
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columnHolder.size();
    }

    public TableColumn[] getColumns() {
        this.checkWidget();
        return (TableColumn[])this.columnHolder.getItems();
    }

    public TableColumn getColumn(int index) {
        this.checkWidget();
        return this.columnHolder.getItem(index);
    }

    public int indexOf(TableColumn tableColumn) {
        this.checkWidget();
        if (tableColumn == null) {
            SWT.error(4);
        }
        return this.columnHolder.indexOf(tableColumn);
    }

    public void setColumnOrder(int[] order) {
        int columnCount;
        this.checkWidget();
        if (order == null) {
            SWT.error(4);
        }
        if (order.length != (columnCount = this.columnHolder.size())) {
            SWT.error(5);
        }
        if (columnCount > 0) {
            int[] oldOrder = new int[columnCount];
            System.arraycopy(this.columnOrder, 0, oldOrder, 0, this.columnOrder.length);
            boolean reorder = false;
            boolean[] seen = new boolean[columnCount];
            int i = 0;
            while (i < order.length) {
                int index = order[i];
                if (index < 0 || index >= columnCount) {
                    SWT.error(6);
                }
                if (seen[index]) {
                    SWT.error(5);
                }
                seen[index] = true;
                if (index != oldOrder[i]) {
                    reorder = true;
                }
                ++i;
            }
            if (reorder) {
                System.arraycopy(order, 0, this.columnOrder, 0, this.columnOrder.length);
                i = 0;
                while (i < seen.length) {
                    if (oldOrder[i] != this.columnOrder[i]) {
                        TableColumn column = this.columnHolder.getItem(this.columnOrder[i]);
                        column.notifyListeners(10, new Event());
                    }
                    ++i;
                }
            }
        }
    }

    public int[] getColumnOrder() {
        int[] result;
        this.checkWidget();
        if (this.columnHolder.size() == 0) {
            result = new int[]{};
        } else {
            result = new int[this.columnOrder.length];
            System.arraycopy(this.columnOrder, 0, result, 0, this.columnOrder.length);
        }
        return result;
    }

    public void setItemCount(int count) {
        this.checkWidget();
        int oldItemCount = this.itemCount;
        int newItemCount = Math.max(0, count);
        if (newItemCount != oldItemCount && !this.isInDispose()) {
            int deleteIndex = oldItemCount - 1;
            while (deleteIndex >= newItemCount) {
                TableItem item = this.items[deleteIndex];
                if (item != null && !item.isDisposed()) {
                    item.dispose();
                } else {
                    this.destroyItem(null, deleteIndex);
                }
                --deleteIndex;
            }
            int length = Math.max(4, (newItemCount + 3) / 4 * 4);
            TableItem[] newItems = new TableItem[length];
            System.arraycopy(this.items, 0, newItems, 0, Math.min(newItemCount, this.itemCount));
            this.items = newItems;
            if ((this.style & 0x10000000) == 0) {
                int i = this.itemCount;
                while (i < newItemCount) {
                    this.items[i] = new TableItem(this, 0, i, true);
                    ++i;
                }
            }
            this.itemCount = newItemCount;
            this.adjustTopIndex();
            if (this.focusIndex > this.itemCount - 1) {
                this.adjustFocusIndex();
            }
            if ((this.style & 0x10000000) != 0) {
                this.updateScrollBars();
            }
            this.redraw();
        }
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public TableItem[] getItems() {
        this.checkWidget();
        TableItem[] result = new TableItem[this.itemCount];
        if ((this.style & 0x10000000) != 0) {
            int i = 0;
            while (i < this.itemCount) {
                result[i] = this._getItem(i);
                ++i;
            }
        } else {
            System.arraycopy(this.items, 0, result, 0, this.itemCount);
        }
        return result;
    }

    public TableItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            SWT.error(6);
        }
        return this._getItem(index);
    }

    public TableItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            SWT.error(4);
        }
        TableItem result = null;
        int headerHeight = this.getHeaderHeight();
        Rectangle itemArea = this.getClientArea();
        itemArea.y += headerHeight;
        if (itemArea.contains(point)) {
            int itemHeight = this.getItemHeight();
            int index = (point.y - headerHeight) / itemHeight - 1;
            if (point.y == headerHeight || point.y % itemHeight != 0) {
                ++index;
            }
            if ((index += this.topIndex) >= 0 && index < this.itemCount) {
                result = this._getItem(index);
            }
        }
        return result;
    }

    public int indexOf(TableItem item) {
        this.checkWidget();
        if (item == null) {
            SWT.error(4);
        }
        return item.parent == this ? item.index : -1;
    }

    public void removeAll() {
        this.checkWidget();
        while (this.itemCount > 0) {
            this.removeItem(this.itemCount - 1);
        }
    }

    public void remove(int start, int end) {
        this.checkWidget();
        if (start <= end) {
            if (start < 0 || start > end || end >= this.itemCount) {
                this.error(6);
            }
            int i = end;
            while (i >= start) {
                this.removeItem(i);
                --i;
            }
        }
    }

    public void remove(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            SWT.error(15);
        }
        this.removeItem(index);
    }

    public void remove(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if (indices.length > 0) {
            int[] sortedIndices = new int[indices.length];
            System.arraycopy(indices, 0, sortedIndices, 0, indices.length);
            Table.sort(sortedIndices);
            int start = sortedIndices[sortedIndices.length - 1];
            int end = sortedIndices[0];
            if (start < 0 || start > end || end >= this.itemCount) {
                SWT.error(6);
            }
            int lastValue = -1;
            int i = 0;
            while (i < sortedIndices.length) {
                if (sortedIndices[i] != lastValue) {
                    lastValue = sortedIndices[i];
                    this.removeItem(sortedIndices[i]);
                }
                ++i;
            }
            if (this.itemCount == 0) {
                this.setTableEmpty();
            }
        }
    }

    public void clear(int index) {
        TableItem item;
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            SWT.error(6);
        }
        if ((item = this.items[index]) != null) {
            item.clear();
        }
    }

    public void clear(int start, int end) {
        this.checkWidget();
        if (start <= end) {
            if (start < 0 || start > end || end >= this.itemCount) {
                SWT.error(6);
            }
            if (start == 0 && end == this.itemCount - 1) {
                this.clearAll();
            } else {
                int i = start;
                while (i <= end) {
                    TableItem item = this.items[i];
                    if (item != null) {
                        item.clear();
                    }
                    ++i;
                }
            }
        }
    }

    public void clearAll() {
        this.checkWidget();
        int i = 0;
        while (i < this.itemCount) {
            TableItem item = this.items[i];
            if (item != null) {
                item.clear();
            }
            ++i;
        }
        this.clearItemImageSize();
    }

    public void clear(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            SWT.error(4);
        }
        if (indices.length > 0) {
            int i = 0;
            while (i < indices.length) {
                if (indices[i] < 0 || indices[i] >= this.itemCount) {
                    SWT.error(6);
                }
                ++i;
            }
            i = 0;
            while (i < indices.length) {
                TableItem item = this.items[indices[i]];
                if (item != null) {
                    item.clear();
                }
                ++i;
            }
        }
    }

    public int getSelectionIndex() {
        this.checkWidget();
        int result = -1;
        int topSelectedIndex = -1;
        int i = 0;
        while (i < this.selection.length) {
            if (this.focusIndex == this.selection[i]) {
                result = this.selection[i];
            }
            topSelectedIndex = topSelectedIndex == -1 ? this.selection[i] : Math.min(topSelectedIndex, this.selection[i]);
            ++i;
        }
        if (result == -1) {
            result = topSelectedIndex;
        }
        return result;
    }

    public void setSelection(int index) {
        this.checkWidget();
        this.deselectAll();
        this.select(index);
        if (index < this.itemCount) {
            this.setFocusIndex(index);
        }
        this.showSelection();
    }

    public int getSelectionCount() {
        this.checkWidget();
        return this.selection.length;
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        this.deselectAll();
        this.select(start, end);
        if (end >= 0 && start <= end && ((this.style & 4) == 0 || start == end) && this.itemCount != 0 && start < this.itemCount) {
            this.setFocusIndex(Math.max(0, start));
        }
        this.showSelection();
    }

    public TableItem[] getSelection() {
        this.checkWidget();
        int length = this.selection.length;
        TableItem[] result = new TableItem[length];
        int i = 0;
        while (i < this.selection.length) {
            result[i] = this._getItem(this.selection[i]);
            ++i;
        }
        return result;
    }

    public void setSelection(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            SWT.error(4);
        }
        this.deselectAll();
        this.select(indices);
        int length = indices.length;
        if (length != 0 && ((this.style & 4) == 0 || length <= 1)) {
            this.setFocusIndex(indices[0]);
        }
        this.showSelection();
    }

    public void setSelection(TableItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        this.setSelection(new TableItem[]{item});
    }

    public void setSelection(TableItem[] items) {
        this.checkWidget();
        if (items == null) {
            SWT.error(4);
        }
        int[] indices = new int[items.length];
        int i = 0;
        while (i < items.length) {
            indices[i] = this.indexOf(items[i]);
            ++i;
        }
        this.setSelection(indices);
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        TableItem[] currentSelection = this.getSelection();
        int[] result = new int[currentSelection.length];
        int i = 0;
        while (i < currentSelection.length) {
            result[i] = this.indexOf(currentSelection[i]);
            ++i;
        }
        return result;
    }

    public boolean isSelected(int index) {
        this.checkWidget();
        boolean result = false;
        if (index >= 0 && index < this.itemCount) {
            int i = 0;
            while (!result && i < this.selection.length) {
                result = this.selection[i] == index;
                ++i;
            }
        }
        return result;
    }

    public void select(int index) {
        this.checkWidget();
        if (index >= 0 && index < this.itemCount) {
            if ((this.style & 4) != 0) {
                this.selection = new int[]{index};
            } else if (!this.isSelected(index)) {
                int length = this.selection.length;
                int[] newSelection = new int[length + 1];
                System.arraycopy(this.selection, 0, newSelection, 0, length);
                newSelection[length] = index;
                this.selection = newSelection;
            }
        }
    }

    public void select(int start, int end) {
        this.checkWidget();
        if (end >= 0 && start <= end && ((this.style & 4) == 0 || start == end) && this.itemCount != 0 && start < this.itemCount) {
            int adjustedStart = Math.max(0, start);
            int adjustedEnd = Math.min(end, this.itemCount - 1);
            if (adjustedStart == 0 && adjustedEnd == this.itemCount - 1) {
                this.selectAll();
            } else {
                int i = adjustedStart;
                while (i <= adjustedEnd) {
                    this.select(i);
                    ++i;
                }
            }
        }
    }

    public void select(int[] indices) {
        int length;
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if ((length = indices.length) != 0 && ((this.style & 4) == 0 || length <= 1)) {
            int i = length - 1;
            while (i >= 0) {
                this.select(indices[i]);
                --i;
            }
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) == 0) {
            this.setSelection(this.getItems());
        }
    }

    public void deselect(int index) {
        this.checkWidget();
        this.removeFromSelection(index);
    }

    public void deselect(int start, int end) {
        this.checkWidget();
        if (start == 0 && end == this.itemCount - 1) {
            this.deselectAll();
        } else {
            int actualStart;
            int i = actualStart = Math.max(0, start);
            while (i <= end) {
                this.removeFromSelection(i);
                ++i;
            }
        }
    }

    public void deselect(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        int i = 0;
        while (i < indices.length) {
            this.removeFromSelection(indices[i]);
            ++i;
        }
    }

    public void deselectAll() {
        this.checkWidget();
        this.selection = EMPTY_SELECTION;
    }

    public void setTopIndex(int topIndex) {
        this.checkWidget();
        if (this.topIndex != topIndex && topIndex >= 0 && topIndex < this.itemCount) {
            this.topIndex = topIndex;
            this.adjustTopIndex();
            if ((this.style & 0x10000000) != 0) {
                this.redraw();
            }
        }
    }

    public int getTopIndex() {
        this.checkWidget();
        return this.topIndex;
    }

    public void showItem(TableItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        int itemIndex = this.indexOf(item);
        int itemCount = this.getVisibleItemCount(false);
        if (itemIndex < this.topIndex) {
            this.setTopIndex(itemIndex);
        } else if (itemCount > 0 && itemIndex >= this.topIndex + itemCount) {
            this.setTopIndex(itemIndex - itemCount + 1);
        }
    }

    public void showColumn(TableColumn column) {
        int index;
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        if (column.isDisposed()) {
            this.error(5);
        }
        if (column.getParent() == this && (index = this.indexOf(column)) >= 0 && index < this.getColumnCount()) {
            int leftColumnsWidth = 0;
            int rightColumnsWidth = 0;
            int columnWidth = column.getWidth();
            int clientWidth = this.getClientArea().width;
            int[] columnOrder = this.getColumnOrder();
            boolean found = false;
            int i = 0;
            while (i < columnOrder.length) {
                if (index != columnOrder[i]) {
                    int currentColumnWidth = this.getColumn(columnOrder[i]).getWidth();
                    if (found) {
                        rightColumnsWidth += currentColumnWidth;
                    } else if (this.isFixedColumn(columnOrder[i])) {
                        clientWidth -= currentColumnWidth;
                    } else {
                        leftColumnsWidth += currentColumnWidth;
                    }
                } else {
                    found = true;
                }
                ++i;
            }
            if (this.getColumnLeftOffset(index) > leftColumnsWidth) {
                this.leftOffset = leftColumnsWidth;
            } else if (this.leftOffset < leftColumnsWidth + columnWidth - clientWidth) {
                this.leftOffset = columnWidth + rightColumnsWidth < clientWidth ? leftColumnsWidth + columnWidth + rightColumnsWidth - clientWidth : leftColumnsWidth;
            }
        }
    }

    public void showSelection() {
        this.checkWidget();
        int index = this.getSelectionIndex();
        if (index != -1) {
            this.showItem(this._getItem(index));
        }
    }

    public void setHeaderVisible(boolean headerVisible) {
        this.checkWidget();
        boolean changed = headerVisible ^ this.headerVisible;
        this.headerVisible = headerVisible;
        if (changed) {
            this.updateScrollBars();
        }
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        return this.headerVisible;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        return this.linesVisible;
    }

    public void setLinesVisible(boolean linesVisible) {
        this.checkWidget();
        this.linesVisible = linesVisible;
    }

    public void setSortColumn(TableColumn column) {
        this.checkWidget();
        if (column != null && column.isDisposed()) {
            this.error(5);
        }
        this.sortColumn = column;
    }

    public TableColumn getSortColumn() {
        this.checkWidget();
        return this.sortColumn;
    }

    public void setSortDirection(int direction) {
        this.checkWidget();
        if ((direction & 0x480) != 0 || direction == 0) {
            this.sortDirection = direction;
        }
    }

    public int getSortDirection() {
        this.checkWidget();
        return this.sortDirection;
    }

    public int getItemHeight() {
        this.checkWidget();
        int result = this.customItemHeight;
        if (result == -1) {
            int textHeight = TextSizeUtil.getCharHeight(this.getFont());
            int imageHeight = this.getItemImageSize().y;
            result = Math.max(imageHeight, textHeight) + this.getCellPadding().height;
            if ((this.style & 0x20) != 0) {
                result = Math.max(this.getCheckSize().y, result);
            }
        }
        return result;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        int result = 0;
        if (this.headerVisible) {
            Font headerFont = this.getHeaderFont();
            int textHeight = TextSizeUtil.getCharHeight(headerFont);
            int imageHeight = 0;
            int i = 0;
            while (i < this.columnHolder.size()) {
                Image image;
                int height;
                TableColumn column = this.columnHolder.getItem(i);
                if (column.getText().contains("\n")) {
                    int columnTextHeight = TextSizeUtil.textExtent((Font)headerFont, (String)column.getText(), (int)0).y;
                    textHeight = Math.max(textHeight, columnTextHeight);
                }
                int n = height = (image = column.getImage()) == null ? 0 : image.getBounds().height;
                if (height > imageHeight) {
                    imageHeight = height;
                }
                ++i;
            }
            result = Math.max(textHeight, imageHeight);
            TableThemeAdapter themeAdapter = (TableThemeAdapter)this.getAdapter(IThemeAdapter.class);
            result += themeAdapter.getHeaderBorderBottomWidth(this);
            result += themeAdapter.getHeaderPadding((Control)this).height;
        }
        return result;
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 1;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.removeListener(13, listener);
        this.removeListener(14, listener);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.clearItemsTextWidths();
        this.updateScrollBars();
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        if (this.columnHolder.size() > 0) {
            int i = 0;
            while (i < this.columnHolder.size()) {
                width += this.columnHolder.getItem(i).getWidth();
                ++i;
            }
        } else {
            width = this.getItemsPreferredWidth(0);
        }
        height += this.getHeaderHeight();
        height += this.getItemCount() * this.getItemHeight();
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        width += border * 2;
        height += border * 2;
        if ((this.style & 0x200) != 0) {
            width += this.getVerticalBar().getSize().x;
        }
        if ((this.style & 0x100) != 0) {
            height += this.getHorizontalBar().getSize().y;
        }
        return new Point(width, height);
    }

    private void setCustomItemHeight(Object value) {
        if (value == null) {
            this.customItemHeight = -1;
        } else {
            int itemHeight;
            if (!(value instanceof Integer)) {
                this.error(5);
            }
            if ((itemHeight = ((Integer)value).intValue()) < 0) {
                this.error(6);
            }
            this.customItemHeight = itemHeight;
        }
    }

    private void setPreloadedItems(Object value) {
        if (value == null) {
            this.preloadedItems = 0;
        } else {
            if (!(value instanceof Integer)) {
                this.error(5);
            }
            this.preloadedItems = (Integer)value;
            if (this.preloadedItems < 0) {
                this.error(6);
            }
        }
    }

    final int getItemsPreferredWidth(int columnIndex) {
        int width = this.getCheckSize((int)columnIndex).x + 12;
        TableItem[] items = this.getCachedItems();
        int i = 0;
        while (i < items.length) {
            int packWidth;
            int checkWidth = items[i].getCheckWidth(columnIndex);
            int itemWidth = checkWidth + (packWidth = items[i].getPackWidth(columnIndex));
            if (itemWidth > width) {
                width = itemWidth;
            }
            ++i;
        }
        return width;
    }

    private void clearItemsTextWidths() {
        TableItem[] items = this.getCreatedItems();
        int i = 0;
        while (i < items.length) {
            items[i].clearTextWidths();
            ++i;
        }
    }

    final void createColumn(TableColumn column, int index) {
        int length;
        this.columnHolder.insert(column, index);
        if (this.columnOrder == null) {
            this.columnOrder = new int[]{index};
        } else {
            length = this.columnOrder.length;
            int i = index;
            while (i < length) {
                int n = i++;
                this.columnOrder[n] = this.columnOrder[n] + 1;
            }
            int[] newColumnOrder = new int[length + 1];
            System.arraycopy(this.columnOrder, 0, newColumnOrder, 0, index);
            System.arraycopy(this.columnOrder, index, newColumnOrder, index + 1, length - index);
            this.columnOrder = newColumnOrder;
            this.columnOrder[index] = index;
        }
        if (this.columnImageCount == null) {
            this.columnImageCount = new int[1];
        } else if (this.columnHolder.size() > 1) {
            length = this.columnImageCount.length;
            int[] newColumnImageCount = new int[length + 1];
            System.arraycopy(this.columnImageCount, 0, newColumnImageCount, 0, index);
            System.arraycopy(this.columnImageCount, index, newColumnImageCount, index + 1, length - index);
            this.columnImageCount = newColumnImageCount;
        }
        int i = 0;
        while (i < this.itemCount) {
            if (this.items[i] != null) {
                this.items[i].shiftData(index);
            }
            ++i;
        }
        this.updateScrollBars();
    }

    final void destroyColumn(TableColumn column) {
        if (!this.isInDispose()) {
            int index = this.indexOf(column);
            int i = 0;
            while (i < this.itemCount) {
                if (this.items[i] != null) {
                    this.items[i].removeData(index);
                }
                ++i;
            }
            if (column == this.sortColumn) {
                this.sortColumn = null;
            }
            this.columnHolder.remove(column);
            int length = this.columnOrder.length;
            int[] newColumnOrder = new int[length - 1];
            int count = 0;
            int i2 = 0;
            while (i2 < length) {
                if (this.columnOrder[i2] != index) {
                    int newOrder = this.columnOrder[i2];
                    if (index < newOrder) {
                        // empty if block
                    }
                    newColumnOrder[count] = --newOrder;
                    ++count;
                }
                ++i2;
            }
            this.columnOrder = newColumnOrder;
            if (this.columnImageCount.length == 1) {
                this.columnImageCount = null;
            } else {
                count = 0;
                int[] newColumnImageCount = new int[this.columnImageCount.length - 1];
                int i3 = 0;
                while (i3 < this.columnImageCount.length) {
                    if (i3 != index) {
                        newColumnImageCount[count] = this.columnImageCount[i3];
                        ++count;
                    }
                    ++i3;
                }
                this.columnImageCount = newColumnImageCount;
            }
            this.updateScrollBars();
        }
    }

    final void createItem(TableItem item, int index) {
        if (index < 0 || index > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            boolean small = this.isVisible();
            int length = small ? this.items.length + 4 : Math.max(4, this.items.length * 3 / 2);
            TableItem[] newItems = new TableItem[length];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        System.arraycopy(this.items, index, this.items, index + 1, this.itemCount - index);
        this.items[index] = item;
        ++this.itemCount;
        this.adjustItemIndices(index);
        int i = 0;
        while (i < this.selection.length) {
            if (this.selection[i] >= index) {
                this.selection[i] = this.selection[i] + 1;
            }
            ++i;
        }
        if (index <= this.focusIndex) {
            ++this.focusIndex;
        }
        this.updateScrollBars();
    }

    final void destroyItem(TableItem item, int index) {
        if (!this.isInDispose()) {
            this.removeFromSelection(index);
            this.adjustSelectionIdices(index);
            if (item != null) {
                int columnCount = Math.max(1, this.columnHolder.size());
                int i = 0;
                while (i < columnCount) {
                    this.updateColumnImageCount(i, item.getImageInternal(i), null);
                    ++i;
                }
            }
            --this.itemCount;
            if (item != null) {
                item.index = -1;
            }
            if (this.itemCount == 0) {
                this.setTableEmpty();
            } else {
                System.arraycopy(this.items, index + 1, this.items, index, this.itemCount - index);
                this.items[this.itemCount] = null;
                this.adjustItemIndices(index);
            }
            this.adjustTopIndex();
            if (index == this.focusIndex || this.focusIndex > this.itemCount - 1) {
                this.adjustFocusIndex();
            }
            this.updateScrollBars();
            if ((this.style & 0x10000000) != 0) {
                this.redraw();
            }
        }
    }

    @Override
    void releaseChildren() {
        TableItem[] tableItems = new TableItem[this.items.length];
        System.arraycopy(this.items, 0, tableItems, 0, this.items.length);
        int i = 0;
        while (i < tableItems.length) {
            if (tableItems[i] != null) {
                tableItems[i].dispose();
                this.items[i] = null;
            }
            ++i;
        }
        TableColumn[] tableColumns = (TableColumn[])this.columnHolder.getItems();
        int i2 = 0;
        while (i2 < tableColumns.length) {
            tableColumns[i2].dispose();
            this.columnHolder.remove(tableColumns[i2]);
            ++i2;
        }
        super.releaseChildren();
    }

    private TableItem _getItem(int index) {
        if ((this.style & 0x10000000) != 0 && this.items[index] == null) {
            this.items[index] = new TableItem(this, 0, index, false);
        }
        return this.items[index];
    }

    final TableItem[] getCachedItems() {
        TableItem[] result;
        if ((this.style & 0x10000000) != 0) {
            int count = 0;
            int i = 0;
            while (i < this.itemCount) {
                if (this.items[i] != null && this.items[i].cached) {
                    ++count;
                }
                ++i;
            }
            result = new TableItem[count];
            count = 0;
            i = 0;
            while (i < this.itemCount) {
                if (this.items[i] != null && this.items[i].cached) {
                    result[count] = this.items[i];
                    ++count;
                }
                ++i;
            }
        } else {
            result = new TableItem[this.itemCount];
            System.arraycopy(this.items, 0, result, 0, this.itemCount);
        }
        return result;
    }

    final TableItem[] getCreatedItems() {
        TableItem[] result;
        if ((this.style & 0x10000000) != 0) {
            int count = 0;
            int i = 0;
            while (i < this.itemCount) {
                if (this.items[i] != null) {
                    ++count;
                }
                ++i;
            }
            result = new TableItem[count];
            count = 0;
            i = 0;
            while (i < this.itemCount) {
                if (this.items[i] != null) {
                    result[count] = this.items[i];
                    ++count;
                }
                ++i;
            }
        } else {
            result = new TableItem[this.itemCount];
            System.arraycopy(this.items, 0, result, 0, this.itemCount);
        }
        return result;
    }

    private void checkData() {
        int visibleItemCount = this.getVisibleItemCount(true);
        int startIndex = Math.max(0, this.topIndex - this.preloadedItems);
        int endIndex = Math.min(this.itemCount, this.topIndex + visibleItemCount + this.preloadedItems);
        int index = startIndex;
        while (index < endIndex) {
            this.checkData(this._getItem(index), index);
            ++index;
        }
    }

    final boolean checkData(TableItem item, int index) {
        boolean virtual;
        boolean result = true;
        boolean bl = virtual = (this.style & 0x10000000) != 0;
        if (virtual && !item.cached && index >= 0 && index < this.itemCount) {
            item.cached = true;
            Event event = new Event();
            event.item = item;
            event.index = index;
            this.notifyListeners(36, event);
            if (this.isDisposed() || item.isDisposed()) {
                result = false;
            }
        }
        return result;
    }

    final void updateColumnImageCount(int columnIndex, Image oldImage, Image newImage) {
        int delta = 0;
        if (oldImage == null && newImage != null) {
            delta = 1;
        } else if (oldImage != null && newImage == null) {
            delta = -1;
        }
        if (delta != 0) {
            if (this.columnImageCount == null) {
                int columnCount = Math.max(1, this.columnHolder.size());
                this.columnImageCount = new int[columnCount];
            }
            int n = columnIndex;
            this.columnImageCount[n] = this.columnImageCount[n] + delta;
        }
    }

    final boolean hasColumnImages(int columnIndex) {
        return this.columnImageCount == null ? false : this.columnImageCount[columnIndex] > 0;
    }

    final void updateItemImageSize(Image image) {
        if (image != null && this.itemImageSize == null) {
            Rectangle imageBounds = image.getBounds();
            this.itemImageSize = new Point(imageBounds.width, imageBounds.height);
        }
    }

    final Point getItemImageSize() {
        return this.itemImageSize == null ? new Point(0, 0) : this.itemImageSize;
    }

    final void clearItemImageSize() {
        this.itemImageSize = null;
    }

    Rectangle getCellPadding() {
        if (this.bufferedCellPadding == null) {
            TableThemeAdapter themeAdapter = (TableThemeAdapter)this.getAdapter(IThemeAdapter.class);
            this.bufferedCellPadding = themeAdapter.getCellPadding(this);
        }
        return this.bufferedCellPadding;
    }

    int getCellSpacing() {
        if (this.bufferedCellSpacing < 0) {
            TableThemeAdapter themeAdapter = (TableThemeAdapter)this.getAdapter(IThemeAdapter.class);
            this.bufferedCellSpacing = themeAdapter.getCellSpacing(this.parent);
        }
        return this.bufferedCellSpacing;
    }

    boolean hasVScrollBar() {
        return this.hasVScrollBar;
    }

    boolean hasHScrollBar() {
        return this.hasHScrollBar;
    }

    @Override
    int getVScrollBarWidth() {
        int result = 0;
        if (this.hasVScrollBar()) {
            result = this.getVerticalBar().getSize().x;
        }
        return result;
    }

    @Override
    int getHScrollBarHeight() {
        int result = 0;
        if (this.hasHScrollBar()) {
            result = this.getHorizontalBar().getSize().y;
        }
        return result;
    }

    void updateScrollBars() {
        if ((this.style & 0x10) == 0) {
            this.hasVScrollBar = false;
            this.hasHScrollBar = this.needsHScrollBar();
            if (this.needsVScrollBar()) {
                this.hasVScrollBar = true;
                this.hasHScrollBar = this.needsHScrollBar();
            }
            this.getHorizontalBar().setVisible(this.hasHScrollBar);
            this.getVerticalBar().setVisible(this.hasVScrollBar);
        }
    }

    @Override
    void notifyResize(Point oldSize) {
        if (!oldSize.equals(this.getSize()) && !TextSizeUtil.isTemporaryResize()) {
            if ((this.style & 0x10000000) != 0) {
                this.checkData();
            }
            this.clearItemsTextWidths();
            this.updateScrollBars();
            this.adjustTopIndex();
        }
        super.notifyResize(oldSize);
    }

    final Point getCheckSize(int index) {
        Point result = new Point(0, 0);
        if (index == 0 && this.getColumnCount() == 0) {
            result = this.getCheckSize();
        } else {
            int[] columnOrder = this.getColumnOrder();
            if (columnOrder[0] == index) {
                result = this.getCheckSize();
            }
        }
        return result;
    }

    final Point getCheckSize() {
        Point result = new Point(0, 0);
        if ((this.style & 0x20) != 0) {
            TableThemeAdapter themeAdapter = (TableThemeAdapter)this.getAdapter(IThemeAdapter.class);
            Point checkImageSize = themeAdapter.getCheckBoxImageSize(this);
            Rectangle margin = this.getCheckBoxMargin();
            result.x = checkImageSize.x + margin.width;
            result.y = checkImageSize.y + margin.height;
        }
        return result;
    }

    final Rectangle getCheckBoxMargin() {
        TableThemeAdapter themeAdapter = (TableThemeAdapter)this.getAdapter(IThemeAdapter.class);
        Rectangle result = themeAdapter.getCheckBoxMargin(this);
        if (result.equals(new Rectangle(0, 0, 0, 0))) {
            int width = themeAdapter.getCheckBoxWidth(this);
            int imageWidth = themeAdapter.getCheckBoxImageSize((Control)this).x;
            result.width = Math.max(0, width - imageWidth);
            result.x = Math.round(result.width / 2);
        }
        return result;
    }

    final int getColumnLeftOffset(int columnIndex) {
        int result = this.leftOffset;
        if (columnIndex >= 0) {
            result = this.isFixedColumn(columnIndex) ? 0 : this.leftOffset;
        }
        return result;
    }

    private boolean isFixedColumn(int index) {
        int[] columnOrder = this.getColumnOrder();
        int visualIndex = -1;
        int i = 0;
        while (i < columnOrder.length && visualIndex == -1) {
            if (index == columnOrder[i]) {
                visualIndex = i;
            }
            ++i;
        }
        return visualIndex < this.getFixedColumns();
    }

    private int getFixedColumns() {
        int result = -1;
        try {
            Integer data = (Integer)this.getData("org.eclipse.rap.rwt.fixedColumns");
            if (data != null && !(this.getData("org.eclipse.rap.rwt.rowTemplate") instanceof Template)) {
                result = data;
            }
        }
        catch (ClassCastException classCastException) {}
        return result;
    }

    final int getVisibleItemCount(boolean includePartlyVisible) {
        int clientHeight = this.getClientArea().height - this.getHeaderHeight();
        int result = 0;
        if (clientHeight >= 0) {
            int itemHeight = this.getItemHeight();
            result = clientHeight / itemHeight;
            if (includePartlyVisible && clientHeight % itemHeight != 0) {
                ++result;
            }
        }
        return result;
    }

    private void setFocusIndex(int focusIndex) {
        if (focusIndex >= 0) {
            this.focusIndex = focusIndex;
        }
    }

    private void removeItem(int index) {
        TableItem item = this.items[index];
        if (item != null && !item.isDisposed()) {
            item.dispose();
        } else {
            this.destroyItem(null, index);
        }
    }

    private void removeFromSelection(int index) {
        if (index >= 0 && index < this.itemCount) {
            boolean found = false;
            int i = 0;
            while (!found && i < this.selection.length) {
                if (index == this.selection[i]) {
                    int length = this.selection.length;
                    int[] newSel = new int[length - 1];
                    System.arraycopy(this.selection, 0, newSel, 0, i);
                    if (i < length - 1) {
                        System.arraycopy(this.selection, i + 1, newSel, i, length - i - 1);
                    }
                    this.selection = newSel;
                    found = true;
                }
                ++i;
            }
        }
    }

    private void adjustSelectionIdices(int removedIndex) {
        int i = 0;
        while (i < this.selection.length) {
            if (this.selection[i] >= removedIndex) {
                this.selection[i] = this.selection[i] - 1;
            }
            ++i;
        }
    }

    private void adjustTopIndex() {
        int correction;
        int visibleItemCount = this.getVisibleItemCount(false);
        int n = correction = visibleItemCount == 0 ? 1 : 0;
        if (this.topIndex > this.itemCount - visibleItemCount - correction) {
            this.topIndex = Math.max(0, this.itemCount - visibleItemCount - correction);
        }
    }

    private void adjustFocusIndex() {
        this.focusIndex = -1;
        this.focusIndex = this.getSelectionIndex();
    }

    private void adjustItemIndices(int start) {
        int i = start;
        while (i < this.itemCount) {
            if (this.items[i] != null) {
                this.items[i].index = i;
            }
            ++i;
        }
    }

    boolean isItemVisible(int index) {
        boolean result = false;
        int visibleItemCount = this.getVisibleItemCount(true);
        if (visibleItemCount > 0) {
            result = index >= this.topIndex && index < this.topIndex + visibleItemCount;
        }
        return result;
    }

    private static void sort(int[] items) {
        int length = items.length;
        int gap = length / 2;
        while (gap > 0) {
            int i = gap;
            while (i < length) {
                int j = i - gap;
                while (j >= 0) {
                    if (items[j] <= items[j + gap]) {
                        int swap = items[j];
                        items[j] = items[j + gap];
                        items[j + gap] = swap;
                    }
                    j -= gap;
                }
                ++i;
            }
            gap /= 2;
        }
    }

    private void setTableEmpty() {
        this.items = new TableItem[4];
        this.clearItemImageSize();
    }

    Font getHeaderFont() {
        IControlAdapter controlAdapter = this.getAdapter(IControlAdapter.class);
        Font result = controlAdapter.getUserFont();
        if (result == null) {
            TableThemeAdapter themeAdapter = (TableThemeAdapter)this.getAdapter(IThemeAdapter.class);
            result = themeAdapter.getHeaderFont(this);
        }
        return result;
    }

    private static int checkStyle(int style) {
        int result = style;
        if ((style & 0x10) == 0) {
            result |= 0x300;
        }
        return Table.checkBits(result, 4, 2, 0, 0, 0, 0);
    }

    boolean needsVScrollBar() {
        int availableHeight = this.getClientArea().height;
        int height = this.getHeaderHeight();
        return (height += this.getItemCount() * this.getItemHeight()) > availableHeight;
    }

    boolean needsHScrollBar() {
        boolean result = false;
        int availableWidth = this.getClientArea().width;
        int columnCount = this.columnHolder.size();
        if (columnCount > 0) {
            int totalWidth = 0;
            int i = 0;
            while (i < columnCount) {
                TableColumn column = this.columnHolder.getItem(i);
                totalWidth += column.getWidth();
                ++i;
            }
            result = totalWidth > availableWidth;
        } else {
            TableItem measureItem = this.getMeasureItem();
            if (measureItem != null) {
                int itemWidth = measureItem.getBounds().width;
                result = itemWidth > availableWidth;
            }
        }
        return result;
    }

    TableItem getMeasureItem() {
        TableItem[] items = this.tableAdapter.getCachedItems();
        TableItem result = null;
        if (this.columnHolder.size() == 0) {
            int i = 0;
            while (i < items.length) {
                result = result == null ? items[i] : this.max(result, items[i]);
                ++i;
            }
        } else if (items.length > 0) {
            result = items[0];
        }
        return result;
    }

    private TableItem max(TableItem item1, TableItem item2) {
        int item1TextWidth = this.getStringExtent((Font)item1.getFont(), (String)item1.getText((int)0)).x;
        int item2TextWidth = this.getStringExtent((Font)item2.getFont(), (String)item2.getText((int)0)).x;
        TableItem result = item1TextWidth > item2TextWidth ? item1 : item2;
        return result;
    }

    Point getStringExtent(Font font, String text) {
        return TextSizeUtil.stringExtent(font, text, MarkupUtil.isMarkupEnabledFor(this));
    }

    @Override
    void reskinChildren(int flags) {
        TableColumn[] columns;
        if (this.items != null) {
            int i = 0;
            while (i < this.items.length) {
                TableItem item = this.items[i];
                if (item != null) {
                    item.reskin(flags);
                }
                ++i;
            }
        }
        if ((columns = this.getColumns()) != null) {
            int i = 0;
            while (i < columns.length) {
                TableColumn column = columns[i];
                if (!column.isDisposed()) {
                    column.reskin(flags);
                }
                ++i;
            }
        }
        super.reskinChildren(flags);
    }

    private final class CompositeItemHolder
    implements IItemHolderAdapter {
        private CompositeItemHolder() {
        }

        public void add(Item item) {
            if (!(item instanceof TableColumn)) {
                String msg = "Only TableColumns may be added to CompositeItemHolder";
                throw new IllegalArgumentException(msg);
            }
            Table.this.columnHolder.add((TableColumn)item);
        }

        public void insert(Item item, int index) {
            if (!(item instanceof TableColumn)) {
                String msg = "Only TableColumns may be inserted to CompositeItemHolder";
                throw new IllegalArgumentException(msg);
            }
            Table.this.columnHolder.insert((TableColumn)item, index);
        }

        public void remove(Item item) {
            if (!(item instanceof TableColumn)) {
                String msg = "Only TableColumns may be removed from CompositeItemHolder";
                throw new IllegalArgumentException(msg);
            }
            Table.this.columnHolder.remove((TableColumn)item);
        }

        public Item[] getItems() {
            TableItem[] items = Table.this.getCreatedItems();
            Item[] columns = Table.this.columnHolder.getItems();
            Item[] result = new Item[columns.length + items.length];
            System.arraycopy(columns, 0, result, 0, columns.length);
            System.arraycopy(items, 0, result, columns.length, items.length);
            return result;
        }
    }

    private final class TableAdapter
    implements ITableAdapter,
    ICellToolTipAdapter,
    SerializableCompatibility {
        private String toolTipText;
        private ICellToolTipProvider provider;

        private TableAdapter() {
        }

        public int getCheckWidthWithMargin() {
            return Table.this.getCheckSize().x;
        }

        public int getCheckLeft() {
            Rectangle margin = Table.this.getCheckBoxMargin();
            return margin.x;
        }

        public int getCheckWidth() {
            TableThemeAdapter themeAdapter = (TableThemeAdapter)Table.this.getAdapter(IThemeAdapter.class);
            return themeAdapter.getCheckBoxImageSize((Control)Table.this).x;
        }

        public int getItemImageWidth(int columnIndex) {
            int result = 0;
            if (Table.this.hasColumnImages(columnIndex)) {
                result = Table.this.getItemImageSize().x;
            }
            return result;
        }

        public int getFocusIndex() {
            return Table.this.focusIndex;
        }

        public void setFocusIndex(int focusIndex) {
            Table.this.setFocusIndex(focusIndex);
        }

        public int getColumnLeftOffset(int columnIndex) {
            return Table.this.getColumnLeftOffset(columnIndex);
        }

        public int getColumnLeft(TableColumn column) {
            int index = Table.this.indexOf(column);
            return ((TableColumn)Table.this.columnHolder.getItem(index)).getLeft();
        }

        public int getLeftOffset() {
            return Table.this.leftOffset;
        }

        public void setLeftOffset(int leftOffset) {
            Table.this.leftOffset = leftOffset;
        }

        public void checkData() {
            Table.this.checkData();
        }

        public void checkData(final int index) {
            if ((Table.this.style & 0x10000000) != 0) {
                ProcessActionRunner.add(new Runnable(){

                    public void run() {
                        TableItem item;
                        if (index >= 0 && index < Table.this.itemCount && !(item = Table.this._getItem(index)).isDisposed()) {
                            Table.this.checkData(item, index);
                        }
                    }
                });
            }
        }

        public int getDefaultColumnWidth() {
            int result = 0;
            TableItem[] items = Table.this.getCachedItems();
            int i = 0;
            while (i < items.length) {
                result = Math.max(result, items[i].getPackWidth(0));
                ++i;
            }
            return result;
        }

        public boolean isItemVirtual(int index) {
            boolean result = false;
            if ((Table.this.style & 0x10000000) != 0) {
                TableItem item = Table.this.items[index];
                result = item == null || !item.cached;
            }
            return result;
        }

        public TableItem[] getCachedItems() {
            return Table.this.getCachedItems();
        }

        public TableItem[] getCreatedItems() {
            return Table.this.getCreatedItems();
        }

        public TableItem getMeasureItem() {
            return Table.this.getMeasureItem();
        }

        public ICellToolTipProvider getCellToolTipProvider() {
            return this.provider;
        }

        public void setCellToolTipProvider(ICellToolTipProvider provider) {
            this.provider = provider;
        }

        public String getCellToolTipText() {
            return this.toolTipText;
        }

        public void setCellToolTipText(String toolTipText) {
            this.toolTipText = toolTipText;
        }

        public int getFixedColumns() {
            return Table.this.getFixedColumns();
        }

        public boolean isFixedColumn(TableColumn column) {
            return Table.this.isFixedColumn(Table.this.indexOf(column));
        }
    }
}

