/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.internal.boot.PlatformURLConnection;
import org.eclipse.core.internal.boot.PlatformURLHandler;
import org.eclipse.core.runtime.IPath;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class PlatformURLPluginConnection
extends PlatformURLConnection {
    private Bundle target = null;
    private static boolean isRegistered = false;
    public static final String PLUGIN = "plugin";

    public PlatformURLPluginConnection(URL url) {
        super(url);
    }

    protected boolean allowCaching() {
        return true;
    }

    public static Object[] parse(String spec, URL originalURL) throws IOException {
        Object[] result = new Object[2];
        if (spec.startsWith("/")) {
            spec = spec.substring(1);
        }
        if (!spec.startsWith(PLUGIN)) {
            throw new IOException(String.format("Unsupported \"platform:\" protocol variation \"{0}\".", originalURL));
        }
        int ix = spec.indexOf("/", PLUGIN.length() + 1);
        String ref = ix == -1 ? spec.substring(PLUGIN.length() + 1) : spec.substring(PLUGIN.length() + 1, ix);
        String id = PlatformURLPluginConnection.getId(ref);
        Bundle bundle = FrameworkUtil.getBundle(IPath.class).getBundleContext().getBundle(id);
        if (bundle == null) {
            throw new IOException(String.format("Unable to resolve plug-in \"{0}\".", originalURL));
        }
        result[0] = bundle;
        result[1] = ix == -1 || ix + 1 >= spec.length() ? "/" : spec.substring(ix + 1);
        return result;
    }

    protected URL resolve() throws IOException {
        String path;
        String spec = this.url.getFile().trim();
        Object[] obj = PlatformURLPluginConnection.parse(spec, this.url);
        Bundle b = (Bundle)obj[0];
        URL result = b.getEntry(path = (String)obj[1]);
        if (result != null || "/".equals(path)) {
            return result;
        }
        result = b.getResource(path);
        if (result != null) {
            return result;
        }
        return new URL(b.getEntry("/"), path);
    }

    public static void startup() {
        if (isRegistered) {
            return;
        }
        PlatformURLHandler.register(PLUGIN, PlatformURLPluginConnection.class);
        isRegistered = true;
    }

    public URL[] getAuxillaryURLs() throws IOException {
        if (this.target == null) {
            String spec = this.url.getFile().trim();
            if (spec.startsWith("/")) {
                spec = spec.substring(1);
            }
            if (!spec.startsWith(PLUGIN)) {
                throw new IOException(String.format("Unsupported \"platform:\" protocol variation \"{0}\".", this.url));
            }
            int ix = spec.indexOf("/", PLUGIN.length() + 1);
            String ref = ix == -1 ? spec.substring(PLUGIN.length() + 1) : spec.substring(PLUGIN.length() + 1, ix);
            String id = PlatformURLPluginConnection.getId(ref);
            this.target = FrameworkUtil.getBundle(IPath.class).getBundleContext().getBundle(id);
            if (this.target == null) {
                throw new IOException(String.format("Unable to resolve plug-in \"{0}\".", this.url));
            }
        }
        return null;
    }
}

