/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.addons.dropdown.internal.resources;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.client.service.JavaScriptLoader;

public final class DropDownResources {
    public static final String[] SCRIPTS = new String[]{"rwt/dropdown/DropDown.js", "rwt/dropdown/DropDownHandler.js"};
    private static final boolean DEBUG = true;

    public static void ensure() {
        DropDownResources.ensureRegistered();
        DropDownResources.ensureLoaded();
    }

    private static void ensureRegistered() {
        if (RWT.getResourceManager().isRegistered(SCRIPTS[0])) {
            DropDownResources.deregister();
        }
        if (!RWT.getResourceManager().isRegistered(SCRIPTS[0])) {
            try {
                DropDownResources.register();
            }
            catch (IOException exception) {
                throw new RuntimeException("Failed to register resources", exception);
            }
        }
    }

    private static void ensureLoaded() {
        String[] stringArray = SCRIPTS;
        int n = SCRIPTS.length;
        int n2 = 0;
        while (n2 < n) {
            String script = stringArray[n2];
            JavaScriptLoader loader = (JavaScriptLoader)RWT.getClient().getService(JavaScriptLoader.class);
            loader.require(RWT.getResourceManager().getLocation(script));
            ++n2;
        }
    }

    private static void register() throws IOException {
        String[] stringArray = SCRIPTS;
        int n = SCRIPTS.length;
        int n2 = 0;
        while (n2 < n) {
            String script = stringArray[n2];
            InputStream inputStream = DropDownResources.getResourceAsStream(script);
            try {
                RWT.getResourceManager().register(script, inputStream);
            }
            finally {
                inputStream.close();
            }
            ++n2;
        }
    }

    private static void deregister() {
        String[] stringArray = SCRIPTS;
        int n = SCRIPTS.length;
        int n2 = 0;
        while (n2 < n) {
            String script = stringArray[n2];
            RWT.getResourceManager().unregister(script);
            ++n2;
        }
    }

    public static InputStream getResourceAsStream(String resourceName) {
        ClassLoader classLoader = DropDownResources.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(resourceName);
        if (inputStream == null) {
            throw new RuntimeException("Resource not found: " + resourceName);
        }
        return inputStream;
    }

    private DropDownResources() {
    }
}

