/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid.internal.gridcolumnkit;

import java.io.IOException;
import java.util.Arrays;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridColumnGroup;
import org.eclipse.nebula.widgets.grid.internal.IGridAdapter;
import org.eclipse.rap.rwt.Adaptable;
import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.internal.protocol.ProtocolUtil;
import org.eclipse.rap.rwt.internal.util.NumberFormatUtil;
import org.eclipse.rap.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.rap.rwt.lifecycle.WidgetAdapter;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.widgets.ItemLCAUtil;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

public class GridColumnLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.GridColumn";
    private static final String PROP_INDEX = "index";
    private static final String PROP_LEFT = "left";
    private static final String PROP_WIDTH = "width";
    private static final String PROP_ALIGNMENT = "alignment";
    private static final String PROP_RESIZABLE = "resizable";
    private static final String PROP_MOVEABLE = "moveable";
    private static final String PROP_VISIBLE = "visibility";
    private static final String PROP_CHECK = "check";
    private static final String PROP_FONT = "font";
    private static final String PROP_FOOTER_FONT = "footerFont";
    private static final String PROP_FOOTER_TEXT = "footerText";
    private static final String PROP_FOOTER_IMAGE = "footerImage";
    private static final String PROP_SELECTION_LISTENER = "Selection";
    private static final int ZERO = 0;
    private static final String DEFAULT_ALIGNMENT = "left";

    public void renderInitialization(Widget widget) throws IOException {
        GridColumn column = (GridColumn)widget;
        IClientObject clientObject = ClientObjectFactory.getClientObject((Adaptable)column);
        clientObject.create(TYPE);
        clientObject.set("parent", WidgetUtil.getId((Widget)column.getParent()));
        GridColumnGroup group = column.getColumnGroup();
        if (group != null) {
            clientObject.set("group", WidgetUtil.getId((Widget)group));
        }
    }

    public void readData(Widget widget) {
        GridColumn column = (GridColumn)widget;
        GridColumnLCA.readLeft(column);
        GridColumnLCA.readWidth(column);
        ControlLCAUtil.processSelection((Widget)column, null, (boolean)false);
    }

    public void preserveValues(Widget widget) {
        GridColumn column = (GridColumn)widget;
        WidgetLCAUtil.preserveToolTipText((Widget)column, (String)column.getHeaderTooltip());
        WidgetLCAUtil.preserveCustomVariant((Widget)column);
        ItemLCAUtil.preserve((Item)column);
        WidgetLCAUtil.preserveProperty((Widget)column, (String)PROP_INDEX, (int)GridColumnLCA.getIndex(column));
        WidgetLCAUtil.preserveProperty((Widget)column, (String)"left", (int)GridColumnLCA.getLeft(column));
        WidgetLCAUtil.preserveProperty((Widget)column, (String)PROP_WIDTH, (int)column.getWidth());
        WidgetLCAUtil.preserveProperty((Widget)column, (String)PROP_ALIGNMENT, (Object)GridColumnLCA.getAlignment(column));
        WidgetLCAUtil.preserveProperty((Widget)column, (String)PROP_RESIZABLE, (boolean)column.getResizeable());
        WidgetLCAUtil.preserveProperty((Widget)column, (String)PROP_MOVEABLE, (boolean)column.getMoveable());
        WidgetLCAUtil.preserveProperty((Widget)column, (String)PROP_VISIBLE, (boolean)column.isVisible());
        WidgetLCAUtil.preserveProperty((Widget)column, (String)PROP_CHECK, (boolean)column.isCheck());
        WidgetLCAUtil.preserveProperty((Widget)column, (String)PROP_FONT, (Object)column.getHeaderFont());
        WidgetLCAUtil.preserveProperty((Widget)column, (String)PROP_FOOTER_FONT, (Object)column.getFooterFont());
        WidgetLCAUtil.preserveProperty((Widget)column, (String)PROP_FOOTER_TEXT, (Object)column.getFooterText());
        WidgetLCAUtil.preserveProperty((Widget)column, (String)PROP_FOOTER_IMAGE, (Object)column.getFooterImage());
        WidgetLCAUtil.preserveListener((Widget)column, (String)PROP_SELECTION_LISTENER, (boolean)column.isListening(13));
    }

    public void renderChanges(Widget widget) throws IOException {
        GridColumn column = (GridColumn)widget;
        WidgetLCAUtil.renderToolTip((Widget)column, (String)column.getHeaderTooltip());
        WidgetLCAUtil.renderCustomVariant((Widget)column);
        ItemLCAUtil.renderChanges((Item)column);
        WidgetLCAUtil.renderProperty((Widget)column, (String)PROP_INDEX, (int)GridColumnLCA.getIndex(column), (int)0);
        WidgetLCAUtil.renderProperty((Widget)column, (String)"left", (int)GridColumnLCA.getLeft(column), (int)0);
        WidgetLCAUtil.renderProperty((Widget)column, (String)PROP_WIDTH, (int)column.getWidth(), (int)0);
        WidgetLCAUtil.renderProperty((Widget)column, (String)PROP_ALIGNMENT, (Object)GridColumnLCA.getAlignment(column), (Object)"left");
        WidgetLCAUtil.renderProperty((Widget)column, (String)PROP_RESIZABLE, (boolean)column.getResizeable(), (boolean)true);
        WidgetLCAUtil.renderProperty((Widget)column, (String)PROP_MOVEABLE, (boolean)column.getMoveable(), (boolean)false);
        WidgetLCAUtil.renderProperty((Widget)column, (String)PROP_VISIBLE, (boolean)column.isVisible(), (boolean)true);
        WidgetLCAUtil.renderProperty((Widget)column, (String)PROP_CHECK, (boolean)column.isCheck(), (boolean)false);
        GridColumnLCA.renderFont(column, PROP_FONT, column.getHeaderFont());
        GridColumnLCA.renderFont(column, PROP_FOOTER_FONT, column.getFooterFont());
        WidgetLCAUtil.renderProperty((Widget)column, (String)PROP_FOOTER_TEXT, (Object)column.getFooterText(), (Object)"");
        WidgetLCAUtil.renderProperty((Widget)column, (String)PROP_FOOTER_IMAGE, (Image)column.getFooterImage(), null);
        WidgetLCAUtil.renderListener((Widget)column, (String)PROP_SELECTION_LISTENER, (boolean)column.isListening(13), (boolean)false);
    }

    private static void readLeft(final GridColumn column) {
        String methodName = "move";
        if (ProtocolUtil.wasCallSend((String)WidgetUtil.getId((Widget)column), (String)methodName)) {
            String value = ProtocolUtil.readCallPropertyValueAsString((String)WidgetUtil.getId((Widget)column), (String)methodName, (String)"left");
            final int newLeft = NumberFormatUtil.parseInt((String)value);
            ProcessActionRunner.add((Runnable)new Runnable(){

                public void run() {
                    GridColumnLCA.moveColumn(column, newLeft);
                }
            });
        }
    }

    private static void readWidth(final GridColumn column) {
        String methodName = "resize";
        if (ProtocolUtil.wasCallSend((String)WidgetUtil.getId((Widget)column), (String)methodName)) {
            String value = ProtocolUtil.readCallPropertyValueAsString((String)WidgetUtil.getId((Widget)column), (String)methodName, (String)PROP_WIDTH);
            final int newWidth = NumberFormatUtil.parseInt((String)value);
            ProcessActionRunner.add((Runnable)new Runnable(){

                public void run() {
                    column.setWidth(newWidth);
                }
            });
        }
    }

    private static void renderFont(GridColumn column, String property, Font newValue) {
        if (WidgetLCAUtil.hasChanged((Widget)column, (String)property, (Object)newValue, (Object)column.getParent().getFont())) {
            IClientObject clientObject = ClientObjectFactory.getClientObject((Adaptable)column);
            clientObject.set(property, ProtocolUtil.getJsonForFont((Font)newValue));
        }
    }

    static void moveColumn(GridColumn column, int newLeft) {
        Grid grid = column.getParent();
        int index = grid.indexOf(column);
        int targetColumn = GridColumnLCA.findMoveTarget(grid, newLeft);
        int[] columnOrder = grid.getColumnOrder();
        int orderIndex = GridColumnLCA.arrayIndexOf(columnOrder, index);
        columnOrder = GridColumnLCA.arrayRemove(columnOrder, orderIndex);
        if (orderIndex < targetColumn) {
            --targetColumn;
        }
        if (Arrays.equals(columnOrder = GridColumnLCA.arrayInsert(columnOrder, targetColumn, index), grid.getColumnOrder())) {
            GridColumn[] columns = grid.getColumns();
            int i = 0;
            while (i < columns.length) {
                WidgetAdapter adapter = WidgetUtil.getAdapter((Widget)columns[i]);
                adapter.preserve("left", null);
                ++i;
            }
        } else {
            try {
                try {
                    grid.setColumnOrder(columnOrder);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    WidgetAdapter adapter = WidgetUtil.getAdapter((Widget)column);
                    adapter.preserve("left", null);
                }
            }
            finally {
                WidgetAdapter adapter = WidgetUtil.getAdapter((Widget)column);
                adapter.preserve("left", null);
            }
        }
    }

    private static int findMoveTarget(Grid grid, int newLeft) {
        int result = -1;
        GridColumn[] columns = grid.getColumns();
        int[] columnOrder = grid.getColumnOrder();
        if (newLeft < 0) {
            result = 0;
        } else {
            int i = 0;
            while (result == -1 && i < columns.length) {
                GridColumn column = columns[columnOrder[i]];
                int left = GridColumnLCA.getLeft(column);
                int width = GridColumnLCA.getWidth(column);
                if (newLeft >= left && newLeft <= left + width) {
                    result = i;
                    if (newLeft >= left + width / 2 && result < columns.length) {
                        ++result;
                    }
                }
                ++i;
            }
        }
        if (result == -1) {
            result = columns.length;
        }
        return result;
    }

    private static int getIndex(GridColumn column) {
        return column.getParent().indexOf(column);
    }

    private static int getLeft(GridColumn column) {
        Grid grid = column.getParent();
        IGridAdapter adapter = grid.getAdapter(IGridAdapter.class);
        return adapter.getCellLeft(grid.indexOf(column));
    }

    private static int getWidth(GridColumn column) {
        Grid grid = column.getParent();
        IGridAdapter adapter = grid.getAdapter(IGridAdapter.class);
        return adapter.getCellWidth(grid.indexOf(column));
    }

    private static String getAlignment(GridColumn column) {
        int alignment = column.getAlignment();
        String result = "left";
        if ((alignment & 0x1000000) != 0) {
            result = "center";
        } else if ((alignment & 0x20000) != 0) {
            result = "right";
        }
        return result;
    }

    private static int arrayIndexOf(int[] array, int value) {
        int result = -1;
        int i = 0;
        while (result == -1 && i < array.length) {
            if (array[i] == value) {
                result = i;
            }
            ++i;
        }
        return result;
    }

    private static int[] arrayRemove(int[] array, int index) {
        int length = array.length;
        int[] result = new int[length - 1];
        System.arraycopy(array, 0, result, 0, index);
        if (index < length - 1) {
            System.arraycopy(array, index + 1, result, index, length - index - 1);
        }
        return result;
    }

    private static int[] arrayInsert(int[] array, int index, int value) {
        int length = array.length;
        int[] result = new int[length + 1];
        System.arraycopy(array, 0, result, 0, length);
        System.arraycopy(result, index, result, index + 1, length - index);
        result[index] = value;
        return result;
    }
}

