/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.StringValueImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.compiler.CodeGenerator;
import oracle.kv.impl.query.compiler.CompilerAPI;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprConst;
import oracle.kv.impl.query.compiler.ExprFuncCall;
import oracle.kv.impl.query.compiler.Function;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.compiler.QueryControlBlock;
import oracle.kv.impl.query.compiler.StaticContext;
import oracle.kv.impl.query.runtime.ArithOpIter;
import oracle.kv.impl.query.runtime.ConstIter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.types.ExprType;
import oracle.kv.impl.query.types.TypeManager;

public class FuncArithOp
extends Function {
    FuncArithOp(FunctionLib.FuncCode code, String name) {
        super(code, name, TypeManager.ANY_JATOMIC_QSTN(), TypeManager.ANY_JATOMIC_QSTN(), true);
    }

    @Override
    PlanIter codegen(CodeGenerator codegen, ExprFuncCall funcCall, PlanIter[] argIters) {
        int resultReg = codegen.allocateResultReg(funcCall);
        assert (argIters != null && argIters.length >= 3);
        assert (argIters[argIters.length - 1] instanceof ConstIter);
        assert (((ConstIter)argIters[argIters.length - 1]).getValue().isString());
        String ops = ((ConstIter)argIters[argIters.length - 1]).getValue().castAsString();
        PlanIter[] newArgIters = Arrays.copyOf(argIters, argIters.length - 1);
        return new ArithOpIter(funcCall, resultReg, this.theCode, newArgIters, ops);
    }

    @Override
    ExprType getRetType(ExprFuncCall caller) {
        ExprType.TypeCode typeCode = ExprType.TypeCode.INT;
        ExprType.Quantifier quantifier = ExprType.Quantifier.ONE;
        int numArgs = caller.getNumArgs();
        assert (caller.getArg(numArgs - 1).getType().getDef().isString());
        block12: for (int i = 0; i < numArgs - 1; ++i) {
            ExprType argType = caller.getArg(i).getType();
            switch (argType.getQuantifier()) {
                case ONE: 
                case PLUS: {
                    break;
                }
                case QSTN: 
                case STAR: {
                    quantifier = ExprType.Quantifier.QSTN;
                    break;
                }
                default: {
                    throw new QueryStateException("Unknown Quantifier: " + (Object)((Object)argType.getQuantifier()));
                }
            }
            if (typeCode == ExprType.TypeCode.ANY_ATOMIC || typeCode == ExprType.TypeCode.ANY_JSON_ATOMIC) continue;
            switch (argType.getCode()) {
                case INT: {
                    continue block12;
                }
                case LONG: {
                    if (typeCode != ExprType.TypeCode.INT) continue block12;
                    typeCode = ExprType.TypeCode.LONG;
                    continue block12;
                }
                case FLOAT: {
                    if (typeCode != ExprType.TypeCode.INT && typeCode != ExprType.TypeCode.LONG) continue block12;
                    typeCode = ExprType.TypeCode.FLOAT;
                    continue block12;
                }
                case DOUBLE: {
                    if (typeCode != ExprType.TypeCode.INT && typeCode != ExprType.TypeCode.LONG && typeCode != ExprType.TypeCode.FLOAT) continue block12;
                    typeCode = ExprType.TypeCode.DOUBLE;
                    continue block12;
                }
                case NUMBER: {
                    typeCode = ExprType.TypeCode.NUMBER;
                    continue block12;
                }
                case ANY_JSON_ATOMIC: 
                case JSON: 
                case ANY_ATOMIC: 
                case ANY: {
                    typeCode = ExprType.TypeCode.ANY_JSON_ATOMIC;
                    continue block12;
                }
                default: {
                    throw new QueryException("Operand in arithmetic operation has illegal type\nOperand : " + i + " type :\n" + argType.getDef().getDDLString(), caller.getLocation());
                }
            }
        }
        return TypeManager.getBuiltinType(typeCode, quantifier);
    }

    @Override
    boolean mayReturnNULL(ExprFuncCall caller) {
        int numArgs = caller.getNumArgs();
        for (int i = 0; i < numArgs - 1; ++i) {
            if (!caller.getArg(i).mayReturnNULL()) continue;
            return true;
        }
        return false;
    }

    static Expr createArithExpr(Expr arg1, Expr arg2, String op) {
        QueryControlBlock qcb = arg1.getQCB();
        StaticContext sctx = arg1.getSctx();
        QueryException.Location loc = arg1.getLocation();
        Function func = CompilerAPI.getFuncLib().getFunc(FunctionLib.FuncCode.OP_ADD_SUB);
        ArrayList<Expr> args = new ArrayList<Expr>(3);
        args.add(arg1);
        args.add(arg2);
        op = "+" + op;
        StringValueImpl opStr = FieldDefImpl.stringDef.createString(op);
        args.add(new ExprConst(qcb, sctx, loc, opStr));
        return ExprFuncCall.create(qcb, sctx, loc, func, args);
    }
}

