/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.persist.model.Persistent;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.IntegerRangeValue;
import oracle.kv.impl.api.table.IntegerValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.util.SortableString;
import oracle.kv.table.FieldDef;
import oracle.kv.table.IntegerDef;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ObjectNode;

@Persistent(version=1)
public class IntegerDefImpl
extends FieldDefImpl
implements IntegerDef {
    private static final long serialVersionUID = 1L;
    private Integer min;
    private Integer max;
    private int encodingLength;

    IntegerDefImpl(String description, Integer min, Integer max) {
        super(FieldDef.Type.INTEGER, description);
        this.min = min;
        this.max = max;
        this.validate();
    }

    IntegerDefImpl(String description) {
        this(description, null, null);
    }

    IntegerDefImpl() {
        super(FieldDef.Type.INTEGER);
        this.min = null;
        this.max = null;
        this.encodingLength = 0;
    }

    private IntegerDefImpl(IntegerDefImpl impl) {
        super(impl);
        this.min = impl.min;
        this.max = impl.max;
        this.encodingLength = impl.encodingLength;
    }

    @Override
    public IntegerDefImpl clone() {
        if (this == FieldDefImpl.integerDef) {
            return this;
        }
        return new IntegerDefImpl(this);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + (this.min != null ? this.min.hashCode() : 0) + (this.max != null ? this.max.hashCode() : 0);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof IntegerDefImpl;
    }

    @Override
    public boolean isValidKeyField() {
        return true;
    }

    @Override
    public boolean isValidIndexField() {
        return true;
    }

    @Override
    public IntegerDef asInteger() {
        return this;
    }

    @Override
    public IntegerValueImpl createInteger(int value) {
        return this.hasMin() || this.hasMax() ? new IntegerRangeValue(value, this) : new IntegerValueImpl(value);
    }

    @Override
    IntegerValueImpl createInteger(String value) {
        return this.hasMin() || this.hasMax() ? new IntegerRangeValue(value, this) : new IntegerValueImpl(value);
    }

    @Override
    public short getRequiredSerialVersion() {
        return 4;
    }

    @Override
    public Integer getMin() {
        return this.min;
    }

    @Override
    public Integer getMax() {
        return this.max;
    }

    @Override
    int getEncodingLength() {
        return this.encodingLength;
    }

    @Override
    public boolean hasMin() {
        return this.min != null;
    }

    @Override
    public boolean hasMax() {
        return this.max != null;
    }

    @Override
    public boolean isSubtype(FieldDefImpl superType) {
        return superType.isInteger() || superType.isLong() || superType.isNumber() || superType.isAny() || superType.isAnyJsonAtomic() || superType.isAnyAtomic() || superType.isJson();
    }

    @Override
    void toJson(ObjectNode node) {
        super.toJson(node);
        if (this.min != null) {
            node.put("min", this.min);
        }
        if (this.max != null) {
            node.put("max", this.max);
        }
    }

    @Override
    FieldValueImpl createValue(JsonNode node) {
        if (node == null || node.isNull()) {
            return NullValueImpl.getInstance();
        }
        if (!node.isInt()) {
            throw new IllegalArgumentException("Default value for type INTEGER is not int");
        }
        return this.createInteger(node.getIntValue());
    }

    private void validate() {
        if (this.min != null && this.max != null && this.min > this.max) {
            throw new IllegalArgumentException("Invalid min or max value");
        }
        this.encodingLength = SortableString.encodingLength(this.min, this.max);
    }

    void validateValue(int val) {
        if (this.min != null && val < this.min || this.max != null && val > this.max) {
            StringBuilder sb = new StringBuilder();
            sb.append("Value, ");
            sb.append(val);
            sb.append(", is outside of the allowed range");
            throw new IllegalArgumentException(sb.toString());
        }
    }
}

