/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.nosql.adapters.sdk;

import jakarta.resource.ResourceException;
import jakarta.resource.cci.Connection;
import jakarta.resource.cci.Interaction;
import jakarta.resource.cci.InteractionSpec;
import jakarta.resource.cci.Record;
import jakarta.resource.cci.ResourceWarning;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.nosql.driver.ops.DeleteRequest;
import oracle.nosql.driver.ops.DeleteResult;
import oracle.nosql.driver.ops.GetRequest;
import oracle.nosql.driver.ops.GetResult;
import oracle.nosql.driver.ops.PrepareRequest;
import oracle.nosql.driver.ops.PrepareResult;
import oracle.nosql.driver.ops.PreparedStatement;
import oracle.nosql.driver.ops.PutRequest;
import oracle.nosql.driver.ops.PutResult;
import oracle.nosql.driver.ops.QueryRequest;
import oracle.nosql.driver.ops.QueryResult;
import oracle.nosql.driver.values.ArrayValue;
import oracle.nosql.driver.values.BinaryValue;
import oracle.nosql.driver.values.BooleanValue;
import oracle.nosql.driver.values.DoubleValue;
import oracle.nosql.driver.values.FieldValue;
import oracle.nosql.driver.values.IntegerValue;
import oracle.nosql.driver.values.LongValue;
import oracle.nosql.driver.values.MapValue;
import oracle.nosql.driver.values.NullValue;
import oracle.nosql.driver.values.NumberValue;
import oracle.nosql.driver.values.StringValue;
import oracle.nosql.driver.values.TimestampValue;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.eis.EISException;
import org.eclipse.persistence.eis.mappings.EISCompositeCollectionMapping;
import org.eclipse.persistence.eis.mappings.EISCompositeDirectCollectionMapping;
import org.eclipse.persistence.eis.mappings.EISCompositeObjectMapping;
import org.eclipse.persistence.eis.mappings.EISDirectMapping;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.nosql.adapters.sdk.OracleNoSQLConnection;
import org.eclipse.persistence.internal.nosql.adapters.sdk.OracleNoSQLInteractionSpec;
import org.eclipse.persistence.internal.nosql.adapters.sdk.OracleNoSQLOperation;
import org.eclipse.persistence.internal.nosql.adapters.sdk.OracleNoSQLRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.nosql.adapters.sdk.OracleNoSQLPlatform;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class OracleNoSQLInteraction
implements Interaction {
    private static final String JSON_DEFAULT_TYPE = "JSON";
    protected OracleNoSQLConnection connection;

    public OracleNoSQLInteraction(OracleNoSQLConnection connection) {
        this.connection = connection;
    }

    public void clearWarnings() {
    }

    public void close() {
    }

    public boolean execute(InteractionSpec spec, Record input, Record output) throws ResourceException {
        throw ValidationException.operationNotSupported((String)"execute(InteractionSpec, jakarta.resource.cci.Record, jakarta.resource.cci.Record)");
    }

    public Record execute(InteractionSpec spec, Record record) throws ResourceException {
        block52: {
            if (!(spec instanceof OracleNoSQLInteractionSpec)) {
                throw EISException.invalidInteractionSpecType();
            }
            if (!(record instanceof OracleNoSQLRecord)) {
                throw EISException.invalidRecordType();
            }
            OracleNoSQLInteractionSpec noSqlSpec = (OracleNoSQLInteractionSpec)spec;
            OracleNoSQLRecord input = (OracleNoSQLRecord)record;
            try {
                OracleNoSQLOperation operation = noSqlSpec.getOperation();
                Map<String, DatabaseMapping> fieldNameMapping = this.createFieldNameMappingMap(noSqlSpec.getDescriptor(), true);
                if (operation == OracleNoSQLOperation.GET) {
                    OracleNoSQLRecord output = new OracleNoSQLRecord();
                    for (Map.Entry entry : input.entrySet()) {
                        GetResult getResult;
                        MapValue values;
                        MapValue key = null;
                        if (entry.getValue() instanceof byte[]) {
                            key = this.createMapValue(this.createDOMRecord((byte[])entry.getValue()), noSqlSpec.getDescriptor());
                        } else if (entry.getValue() instanceof Map) {
                            key = this.createMapValue((Map)entry.getValue(), noSqlSpec.getDescriptor());
                        }
                        GetRequest getRequest = new GetRequest().setKey(key).setTableName(noSqlSpec.getTableName());
                        if (noSqlSpec.getTimeout() > 0) {
                            getRequest.setTimeout(noSqlSpec.getTimeout());
                        }
                        if (noSqlSpec.getConsistency() != null) {
                            getRequest.setConsistency(noSqlSpec.getConsistency());
                        }
                        if ((values = (getResult = this.connection.getNoSQLHandle().get(getRequest)).getValue()) == null) continue;
                        for (Map.Entry outputEntry : values.entrySet()) {
                            output.put(outputEntry.getKey(), this.unboxFieldValue((FieldValue)outputEntry.getValue(), spec, this.isDBFieldJSONType(noSqlSpec.getTableName(), (String)outputEntry.getKey(), fieldNameMapping)));
                        }
                    }
                    if (output.isEmpty()) {
                        return null;
                    }
                    return output;
                }
                if (operation == OracleNoSQLOperation.PUT || operation == OracleNoSQLOperation.PUT_IF_ABSENT || operation == OracleNoSQLOperation.PUT_IF_PRESENT || operation == OracleNoSQLOperation.PUT_IF_VERSION) {
                    for (Map.Entry entry : input.entrySet()) {
                        PutResult putResult;
                        PutRequest putRequest = null;
                        if (entry.getValue() instanceof byte[]) {
                            DOMRecord domRecord = this.createDOMRecord((byte[])entry.getValue());
                            putRequest = this.createPutRequest(domRecord, noSqlSpec.getTableName(), noSqlSpec.getDescriptor());
                        } else if (entry.getValue() instanceof Map) {
                            putRequest = this.createPutRequest((Map)entry.getValue(), noSqlSpec.getTableName(), noSqlSpec.getDescriptor());
                        }
                        if (noSqlSpec.getTimeout() > 0) {
                            putRequest.setTimeout(noSqlSpec.getTimeout());
                        }
                        if (noSqlSpec.getDurability() != null) {
                            putRequest.setDurability(noSqlSpec.getDurability());
                        }
                        if ((putResult = this.connection.getNoSQLHandle().put(putRequest)).getVersion() != null) continue;
                        throw new ResourceException("Attempt to put failed:" + input);
                    }
                    break block52;
                }
                if (operation == OracleNoSQLOperation.DELETE) {
                    for (Map.Entry entry : input.entrySet()) {
                        MapValue key = null;
                        if (entry.getValue() instanceof byte[]) {
                            key = this.createMapValue(this.createDOMRecord((byte[])entry.getValue()), noSqlSpec.getDescriptor());
                        } else if (entry.getValue() instanceof Map) {
                            key = this.createMapValue((Map)entry.getValue(), noSqlSpec.getDescriptor());
                        }
                        DeleteRequest deleteRequest = new DeleteRequest().setKey(key).setTableName(noSqlSpec.getTableName());
                        if (noSqlSpec.getTimeout() > 0) {
                            deleteRequest.setTimeout(noSqlSpec.getTimeout());
                        }
                        if (noSqlSpec.getDurability() != null) {
                            deleteRequest.setDurability(noSqlSpec.getDurability());
                        }
                        DeleteResult getRequest = this.connection.getNoSQLHandle().delete(deleteRequest);
                    }
                    break block52;
                }
                if (operation == OracleNoSQLOperation.ITERATOR) {
                    OracleNoSQLRecord output = new OracleNoSQLRecord();
                    QueryRequest queryRequest = new QueryRequest().setStatement("SELECT * FROM " + noSqlSpec.getTableName());
                    if (noSqlSpec.getTimeout() > 0) {
                        queryRequest.setTimeout(noSqlSpec.getTimeout());
                    }
                    if (noSqlSpec.getConsistency() != null) {
                        queryRequest.setConsistency(noSqlSpec.getConsistency());
                    }
                    do {
                        QueryResult queryResult = this.connection.getNoSQLHandle().query(queryRequest);
                        List results = queryResult.getResults();
                        int rowId = 1;
                        for (MapValue values : results) {
                            OracleNoSQLRecord outputRow = new OracleNoSQLRecord();
                            for (Map.Entry outputEntry : values.entrySet()) {
                                outputRow.put(outputEntry.getKey(), this.unboxFieldValue((FieldValue)outputEntry.getValue(), spec, this.isDBFieldJSONType(noSqlSpec.getTableName(), (String)outputEntry.getKey(), fieldNameMapping)));
                            }
                            output.put(rowId++, outputRow);
                        }
                    } while (!queryRequest.isDone());
                    if (output.isEmpty()) {
                        return null;
                    }
                    return output;
                }
                if (operation == OracleNoSQLOperation.ITERATOR_QUERY) {
                    OracleNoSQLRecord output = new OracleNoSQLRecord();
                    OracleNoSQLRecord inputRecord = null;
                    for (Map.Entry entry : input.entrySet()) {
                        if (entry.getValue() instanceof byte[]) {
                            inputRecord = this.createMapFromDOMRecord(this.createDOMRecord((byte[])entry.getValue()));
                            continue;
                        }
                        inputRecord = (OracleNoSQLRecord)entry.getValue();
                    }
                    String sqlString = (String)inputRecord.get(OracleNoSQLPlatform.QUERY);
                    PrepareRequest prepareRequest = new PrepareRequest().setStatement(sqlString);
                    if (noSqlSpec.getTimeout() > 0) {
                        prepareRequest.setTimeout(noSqlSpec.getTimeout());
                    }
                    PrepareResult prepareResult = this.connection.getNoSQLHandle().prepare(prepareRequest);
                    PreparedStatement preparedStatement = prepareResult.getPreparedStatement();
                    if (inputRecord.get(OracleNoSQLPlatform.QUERY_ARGUMENTS) != null) {
                        StringTokenizer st = new StringTokenizer((String)inputRecord.get(OracleNoSQLPlatform.QUERY_ARGUMENTS), ";");
                        while (st.hasMoreTokens()) {
                            String argumentName = st.nextToken();
                            preparedStatement.setVariable("$" + argumentName, OracleNoSQLPlatform.getFieldValue(argumentName + (String)inputRecord.get(OracleNoSQLPlatform.QUERY_ARGUMENT_TYPE_SUFFIX), (String)inputRecord.get(argumentName + OracleNoSQLPlatform.QUERY_ARGUMENT_VALUE_SUFFIX), false));
                        }
                    }
                    QueryRequest queryRequest = new QueryRequest().setPreparedStatement(preparedStatement);
                    do {
                        QueryResult queryResult = this.connection.getNoSQLHandle().query(queryRequest);
                        List results = queryResult.getResults();
                        int rowId = 1;
                        for (MapValue values : results) {
                            OracleNoSQLRecord outputRow = new OracleNoSQLRecord();
                            for (Map.Entry outputEntry : values.entrySet()) {
                                outputRow.put(outputEntry.getKey(), this.unboxFieldValue((FieldValue)outputEntry.getValue(), spec, this.isDBFieldJSONType(noSqlSpec.getTableName(), (String)outputEntry.getKey(), fieldNameMapping)));
                            }
                            output.put(rowId++, outputRow);
                        }
                    } while (!queryRequest.isDone());
                    if (output.isEmpty()) {
                        return null;
                    }
                    return output;
                }
                if (operation == OracleNoSQLOperation.NATIVE_QUERY) {
                    OracleNoSQLRecord output = new OracleNoSQLRecord();
                    String sqlString = (String)input.get(OracleNoSQLPlatform.QUERY);
                    PrepareRequest prepareRequest = new PrepareRequest().setStatement(sqlString);
                    if (noSqlSpec.getTimeout() > 0) {
                        prepareRequest.setTimeout(noSqlSpec.getTimeout());
                    }
                    PrepareResult prepareResult = this.connection.getNoSQLHandle().prepare(prepareRequest);
                    PreparedStatement preparedStatement = prepareResult.getPreparedStatement();
                    if (input.get(OracleNoSQLPlatform.QUERY_ARGUMENTS) != null) {
                        OracleNoSQLRecord arguments = (OracleNoSQLRecord)input.get(OracleNoSQLPlatform.QUERY_ARGUMENTS);
                        for (Map.Entry entry : arguments.entrySet()) {
                            preparedStatement.setVariable("$" + entry.getKey(), OracleNoSQLPlatform.getFieldValue(entry.getValue().getClass().getName(), entry.getValue(), false));
                        }
                    }
                    QueryRequest queryRequest = new QueryRequest().setPreparedStatement(preparedStatement);
                    do {
                        QueryResult queryResult = this.connection.getNoSQLHandle().query(queryRequest);
                        List results = queryResult.getResults();
                        int rowId = 1;
                        for (MapValue values : results) {
                            OracleNoSQLRecord outputRow = new OracleNoSQLRecord();
                            for (Map.Entry outputEntry : values.entrySet()) {
                                outputRow.put(outputEntry.getKey(), this.unboxFieldValue((FieldValue)outputEntry.getValue(), spec, this.isDBFieldJSONType(noSqlSpec.getTableName(), (String)outputEntry.getKey(), fieldNameMapping)));
                            }
                            output.put(rowId++, outputRow);
                        }
                    } while (!queryRequest.isDone());
                    if (output.isEmpty()) {
                        return null;
                    }
                    return output;
                }
                throw new ResourceException("Invalid NoSQL operation:" + operation);
            }
            catch (Exception exception) {
                throw new ResourceException((Throwable)exception);
            }
        }
        return null;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public ResourceWarning getWarnings() {
        return null;
    }

    private DOMRecord createDOMRecord(byte[] byteArray) {
        DOMRecord domRecord = new DOMRecord();
        domRecord.transformFromXML(new String(byteArray));
        return domRecord;
    }

    private MapValue createMapValue(DOMRecord domRecord, ClassDescriptor descriptor) {
        Map<String, DatabaseMapping> fieldNameMapping = this.createFieldNameMappingMap(descriptor, false);
        MapValue mapValue = new MapValue();
        for (Map.Entry entry : domRecord.entrySet()) {
            Map<String, DatabaseMapping> fieldNameMappingCollection;
            ArrayValue arrayValue;
            String key = ((DatabaseField)entry.getKey()).getName();
            String typesKey = descriptor.buildField((DatabaseField)entry.getKey()).toString();
            DatabaseMapping mapping = fieldNameMapping.get(typesKey);
            if (mapping == null) {
                mapping = fieldNameMapping.get(typesKey.replace("/text()", ""));
            }
            if (mapping instanceof EISDirectMapping) {
                Converter converter = ((EISDirectMapping)mapping).getConverter();
                String fieldClassificationName = ((EISDirectMapping)mapping).getFieldClassificationClassName();
                String typeName = mapping.getAttributeClassification().getTypeName();
                String value = ((Element)entry.getValue()).getFirstChild().getNodeValue();
                if (converter == null) {
                    mapValue.put(key, OracleNoSQLPlatform.getFieldValue(typeName, value, OracleNoSQLPlatform.isLob(fieldClassificationName)));
                    continue;
                }
                AbstractSession session = SessionManager.getManager().getSession(descriptor.getSessionName());
                Object convertedValue = converter.convertDataValueToObjectValue((Object)value, (Session)session);
                mapValue.put(key, OracleNoSQLPlatform.getFieldValue(typeName, convertedValue, OracleNoSQLPlatform.isLob(fieldClassificationName)));
                continue;
            }
            if (mapping instanceof EISCompositeDirectCollectionMapping) {
                arrayValue = new ArrayValue();
                List domRecordList = (List)domRecord.getValues(key);
                for (DOMRecord domRecordListItem : domRecordList) {
                    StringValue recordValue = null;
                    for (Node domRecordListItemValue : domRecordListItem.getValues()) {
                        recordValue = new StringValue(domRecordListItemValue.getNodeValue());
                        arrayValue.add((FieldValue)recordValue);
                    }
                }
                mapValue.put(key, (FieldValue)arrayValue);
                continue;
            }
            if (mapping instanceof EISCompositeObjectMapping) {
                Object convertedValue;
                AbstractSession session;
                String value;
                String typeName;
                String fieldClassificationName;
                Converter converter;
                DatabaseMapping mappingCollection;
                Node item;
                MapValue recordValue = new MapValue();
                fieldNameMappingCollection = this.createFieldNameMappingMap(mapping.getReferenceDescriptor(), false);
                NamedNodeMap namedNodeMap = ((Element)entry.getValue()).getAttributes();
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    item = namedNodeMap.item(i);
                    mappingCollection = fieldNameMappingCollection.get("@" + item.getLocalName());
                    converter = ((EISDirectMapping)mappingCollection).getConverter();
                    fieldClassificationName = ((EISDirectMapping)mappingCollection).getFieldClassificationClassName();
                    typeName = mappingCollection.getAttributeClassification().getTypeName();
                    value = item.getNodeValue();
                    if (converter == null) {
                        recordValue.put(item.getLocalName(), OracleNoSQLPlatform.getFieldValue(typeName, value, OracleNoSQLPlatform.isLob(typeName)));
                        continue;
                    }
                    session = SessionManager.getManager().getSession(descriptor.getSessionName());
                    convertedValue = converter.convertDataValueToObjectValue((Object)value, (Session)session);
                    recordValue.put(item.getLocalName(), OracleNoSQLPlatform.getFieldValue(typeName, convertedValue, OracleNoSQLPlatform.isLob(fieldClassificationName)));
                }
                Node firstChild = ((Element)entry.getValue()).getFirstChild();
                if (firstChild != null && firstChild.getFirstChild() != null) {
                    item = firstChild;
                    do {
                        mappingCollection = fieldNameMappingCollection.get(item.getLocalName()) != null ? fieldNameMappingCollection.get(item.getLocalName()) : fieldNameMappingCollection.get(item.getLocalName() + "/text()");
                        converter = ((EISDirectMapping)mappingCollection).getConverter();
                        fieldClassificationName = ((EISDirectMapping)mappingCollection).getFieldClassificationClassName();
                        typeName = mappingCollection.getAttributeClassification().getTypeName();
                        value = item.getFirstChild().getNodeValue();
                        if (converter == null) {
                            recordValue.put(item.getLocalName(), OracleNoSQLPlatform.getFieldValue(typeName, value, OracleNoSQLPlatform.isLob(typeName)));
                            continue;
                        }
                        session = SessionManager.getManager().getSession(descriptor.getSessionName());
                        convertedValue = converter.convertDataValueToObjectValue((Object)value, (Session)session);
                        recordValue.put(item.getLocalName(), OracleNoSQLPlatform.getFieldValue(typeName, convertedValue, OracleNoSQLPlatform.isLob(fieldClassificationName)));
                    } while ((item = item.getNextSibling()) != null);
                }
                if (recordValue.size() <= 0) continue;
                mapValue.put(key, (FieldValue)recordValue);
                continue;
            }
            if (!(mapping instanceof EISCompositeCollectionMapping)) continue;
            arrayValue = new ArrayValue();
            fieldNameMappingCollection = this.createFieldNameMappingMap(mapping.getReferenceDescriptor(), false);
            List domRecordList = (List)domRecord.getValues(key);
            for (DOMRecord domRecordListItem : domRecordList) {
                Object convertedValue;
                AbstractSession session;
                String value;
                String typeName;
                String fieldClassificationName;
                Converter converter;
                DatabaseMapping mappingCollection;
                MapValue recordValue = new MapValue();
                NamedNodeMap attributes = domRecordListItem.getDOM().getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node item = attributes.item(i);
                    mappingCollection = fieldNameMappingCollection.get("@" + item.getLocalName());
                    converter = ((EISDirectMapping)mappingCollection).getConverter();
                    fieldClassificationName = ((EISDirectMapping)mappingCollection).getFieldClassificationClassName();
                    typeName = mappingCollection.getAttributeClassification().getTypeName();
                    value = item.getNodeValue();
                    if (converter == null) {
                        recordValue.put(item.getLocalName(), OracleNoSQLPlatform.getFieldValue(typeName, value, OracleNoSQLPlatform.isLob(typeName)));
                        continue;
                    }
                    session = SessionManager.getManager().getSession(descriptor.getSessionName());
                    convertedValue = converter.convertDataValueToObjectValue((Object)value, (Session)session);
                    recordValue.put(item.getLocalName(), OracleNoSQLPlatform.getFieldValue(typeName, convertedValue, OracleNoSQLPlatform.isLob(fieldClassificationName)));
                }
                if (domRecordListItem.getValues().size() > 0) {
                    for (Map.Entry listItemEntry : domRecordListItem.entrySet()) {
                        mappingCollection = fieldNameMappingCollection.get(((Element)listItemEntry.getValue()).getLocalName()) != null ? fieldNameMappingCollection.get(((Element)listItemEntry.getValue()).getLocalName()) : fieldNameMappingCollection.get(((Element)listItemEntry.getValue()).getLocalName() + "/text()");
                        converter = ((EISDirectMapping)mappingCollection).getConverter();
                        fieldClassificationName = ((EISDirectMapping)mappingCollection).getFieldClassificationClassName();
                        typeName = mappingCollection.getAttributeClassification().getTypeName();
                        value = ((Element)listItemEntry.getValue()).getFirstChild().getNodeValue();
                        if (converter == null) {
                            recordValue.put(((Element)listItemEntry.getValue()).getLocalName(), OracleNoSQLPlatform.getFieldValue(typeName, value, OracleNoSQLPlatform.isLob(typeName)));
                            continue;
                        }
                        session = SessionManager.getManager().getSession(descriptor.getSessionName());
                        convertedValue = converter.convertDataValueToObjectValue((Object)value, (Session)session);
                        recordValue.put(((Element)listItemEntry.getValue()).getLocalName(), OracleNoSQLPlatform.getFieldValue(typeName, convertedValue, OracleNoSQLPlatform.isLob(fieldClassificationName)));
                    }
                }
                if (recordValue.size() <= 0) continue;
                arrayValue.add((FieldValue)recordValue);
            }
            mapValue.put(key, (FieldValue)arrayValue);
        }
        return mapValue;
    }

    private MapValue createMapValue(Map recordEntry, ClassDescriptor descriptor) {
        Map<String, DatabaseMapping> fieldNameMapping = this.createFieldNameMappingMap(descriptor, false);
        MapValue mapValue = new MapValue();
        for (Map.Entry entry : recordEntry.entrySet()) {
            Map<String, DatabaseMapping> fieldNameMappingCollection;
            ArrayValue arrayValue;
            if (entry.getValue() == null) continue;
            String key = (String)entry.getKey();
            String typesKey = descriptor.buildField((String)entry.getKey()).toString();
            DatabaseMapping mapping = fieldNameMapping.get(typesKey);
            if (mapping == null) {
                mapping = fieldNameMapping.get(typesKey.replace("/text()", ""));
            }
            if (mapping == null) {
                mapping = fieldNameMapping.get(descriptor.getTableName() + "." + typesKey.replace("/text()", ""));
            }
            if (mapping instanceof EISDirectMapping) {
                Converter converter = ((EISDirectMapping)mapping).getConverter();
                String fieldClassificationName = ((EISDirectMapping)mapping).getFieldClassificationClassName();
                String typeName = mapping.getAttributeClassification().getTypeName();
                String value = entry.getValue().toString();
                if (converter == null) {
                    mapValue.put(key, OracleNoSQLPlatform.getFieldValue(typeName, value, OracleNoSQLPlatform.isLob(fieldClassificationName)));
                    continue;
                }
                String[] session = SessionManager.getManager().getSession(descriptor.getSessionName());
                Object object = converter.convertDataValueToObjectValue((Object)value, (Session)session);
                mapValue.put(key, OracleNoSQLPlatform.getFieldValue(typeName, object, OracleNoSQLPlatform.isLob(fieldClassificationName)));
                continue;
            }
            if (mapping instanceof EISCompositeDirectCollectionMapping) {
                arrayValue = new ArrayValue();
                for (Object collectionItem : (List)entry.getValue()) {
                    StringValue recordValue;
                    if (collectionItem instanceof String) {
                        recordValue = new StringValue((String)collectionItem);
                        arrayValue.add((FieldValue)recordValue);
                        continue;
                    }
                    if (!(collectionItem instanceof String[])) continue;
                    for (String collectionSubItem : (String[])collectionItem) {
                        recordValue = new StringValue(collectionSubItem);
                        arrayValue.add((FieldValue)recordValue);
                    }
                }
                mapValue.put(key, (FieldValue)arrayValue);
                continue;
            }
            if (mapping instanceof EISCompositeObjectMapping) {
                MapValue recordValue = new MapValue();
                fieldNameMappingCollection = this.createFieldNameMappingMap(mapping.getReferenceDescriptor(), false);
                for (Map compositeObject : (List)entry.getValue()) {
                    for (Map.Entry entry2 : compositeObject.entrySet()) {
                        DatabaseMapping mappingCollection = fieldNameMappingCollection.get(entry2.getKey());
                        Converter converter = ((EISDirectMapping)mappingCollection).getConverter();
                        String fieldClassificationName = ((EISDirectMapping)mappingCollection).getFieldClassificationClassName();
                        String typeName = mappingCollection.getAttributeClassification().getTypeName();
                        String value = (String)entry2.getValue();
                        if (value == null) continue;
                        if (converter == null) {
                            recordValue.put((String)entry2.getKey(), OracleNoSQLPlatform.getFieldValue(typeName, value, OracleNoSQLPlatform.isLob(typeName)));
                            continue;
                        }
                        AbstractSession session = SessionManager.getManager().getSession(descriptor.getSessionName());
                        Object convertedValue = converter.convertDataValueToObjectValue((Object)value, (Session)session);
                        recordValue.put((String)entry2.getKey(), OracleNoSQLPlatform.getFieldValue(typeName, convertedValue, OracleNoSQLPlatform.isLob(fieldClassificationName)));
                    }
                }
                if (recordValue.size() <= 0) continue;
                mapValue.put(key, (FieldValue)recordValue);
                continue;
            }
            if (!(mapping instanceof EISCompositeCollectionMapping)) continue;
            arrayValue = new ArrayValue();
            fieldNameMappingCollection = this.createFieldNameMappingMap(mapping.getReferenceDescriptor(), false);
            for (Map compositeObjectList : (List)entry.getValue()) {
                MapValue recordValue = new MapValue();
                for (Map.Entry compositeObjectEntry : compositeObjectList.entrySet()) {
                    DatabaseMapping mappingCollection = fieldNameMappingCollection.get(compositeObjectEntry.getKey());
                    Converter converter = ((EISDirectMapping)mappingCollection).getConverter();
                    String fieldClassificationName = ((EISDirectMapping)mappingCollection).getFieldClassificationClassName();
                    String typeName = mappingCollection.getAttributeClassification().getTypeName();
                    Object value = compositeObjectEntry.getValue();
                    if (value == null) continue;
                    if (converter == null) {
                        recordValue.put((String)compositeObjectEntry.getKey(), OracleNoSQLPlatform.getFieldValue(typeName, value, OracleNoSQLPlatform.isLob(typeName)));
                        continue;
                    }
                    AbstractSession session = SessionManager.getManager().getSession(descriptor.getSessionName());
                    Object convertedValue = converter.convertDataValueToObjectValue(value, (Session)session);
                    recordValue.put((String)compositeObjectEntry.getKey(), OracleNoSQLPlatform.getFieldValue(typeName, convertedValue, OracleNoSQLPlatform.isLob(fieldClassificationName)));
                }
                arrayValue.add((FieldValue)recordValue);
            }
            mapValue.put(key, (FieldValue)arrayValue);
        }
        return mapValue;
    }

    private OracleNoSQLRecord createMapFromDOMRecord(DOMRecord domRecord) {
        OracleNoSQLRecord map = new OracleNoSQLRecord();
        for (Map.Entry entry : domRecord.entrySet()) {
            String key = ((DatabaseField)entry.getKey()).getName();
            String value = ((Element)entry.getValue()).getFirstChild().getNodeValue();
            map.put(key, value);
        }
        return map;
    }

    private Object unboxFieldValue(FieldValue value, InteractionSpec spec, boolean isJson) {
        Object result = null;
        if (value instanceof ArrayValue) {
            if (((OracleNoSQLInteractionSpec)spec).getInteractionType() == OracleNoSQLInteractionSpec.InteractionType.XML) {
                result = new int[((ArrayValue)value).size()];
                if (((ArrayValue)value).size() > 0) {
                    result = Array.newInstance(this.unboxFieldValue(((ArrayValue)value).get(0), spec, isJson).getClass(), ((ArrayValue)value).size());
                }
                for (int i = 0; i < ((ArrayValue)value).size(); ++i) {
                    ((Object[])result)[i] = this.unboxFieldValue(((ArrayValue)value).get(i), spec, isJson);
                }
            } else if (((OracleNoSQLInteractionSpec)spec).getInteractionType() == OracleNoSQLInteractionSpec.InteractionType.MAPPED && ((ArrayValue)value).size() > 0) {
                result = new ArrayList(((ArrayValue)value).size());
                for (int i = 0; i < ((ArrayValue)value).size(); ++i) {
                    ((List)result).add(this.unboxFieldValue(((ArrayValue)value).get(i), spec, isJson));
                }
            }
        } else if (value instanceof BinaryValue) {
            result = value.getBinary();
        } else if (value instanceof BooleanValue) {
            result = value.getBoolean();
        } else if (value instanceof DoubleValue) {
            result = value.getDouble();
        } else if (value instanceof IntegerValue) {
            result = value.getInt();
        } else if (value instanceof LongValue) {
            result = value.getLong();
        } else if (value instanceof MapValue) {
            if (isJson) {
                result = value.toJson();
            } else {
                Map mapValue = ((MapValue)value).getMap();
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                for (Map.Entry entry : mapValue.entrySet()) {
                    resultMap.put((String)entry.getKey(), this.unboxFieldValue((FieldValue)entry.getValue(), spec, isJson));
                }
                result = resultMap;
            }
        } else if (value instanceof NullValue) {
            result = null;
        } else if (value instanceof NumberValue) {
            result = value.getNumber();
        } else if (value instanceof StringValue) {
            result = value.getString();
        } else if (value instanceof TimestampValue) {
            result = value.getTimestamp();
        }
        return result;
    }

    private PutRequest createPutRequest(DOMRecord domRecord, String tableName, ClassDescriptor descriptor) {
        MapValue mapValue = this.createMapValue(domRecord, descriptor);
        return new PutRequest().setValue(mapValue).setTableName(tableName);
    }

    private PutRequest createPutRequest(Map input, String tableName, ClassDescriptor descriptor) {
        MapValue mapValue = this.createMapValue(input, descriptor);
        return new PutRequest().setValue(mapValue).setTableName(tableName);
    }

    private Map<String, DatabaseMapping> createFieldNameMappingMap(ClassDescriptor descriptor, boolean withoutTextXPath) {
        HashMap<String, DatabaseMapping> result = new HashMap<String, DatabaseMapping>();
        for (DatabaseMapping mapping : descriptor.getMappings()) {
            for (DatabaseField field : mapping.getFields()) {
                result.put(withoutTextXPath ? field.getQualifiedName().replace("/text()", "") : field.getQualifiedName(), mapping);
            }
        }
        return result;
    }

    private boolean isDBFieldJSONType(String tableName, String fieldName, Map<String, DatabaseMapping> fieldNameMapping) {
        DatabaseMapping mapping = fieldNameMapping.get(tableName + "." + fieldName);
        if (mapping == null) {
            mapping = fieldNameMapping.get(tableName + "." + fieldName.toUpperCase());
        }
        return JSON_DEFAULT_TYPE.equalsIgnoreCase(mapping.getField().getColumnDefinition());
    }
}

