/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jaxb.json.schema;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.jaxb.json.schema.model.JsonSchema;
import org.eclipse.persistence.internal.jaxb.json.schema.model.JsonType;
import org.eclipse.persistence.internal.jaxb.json.schema.model.Property;
import org.eclipse.persistence.internal.oxm.Constants;
import org.eclipse.persistence.internal.oxm.QNameInheritancePolicy;
import org.eclipse.persistence.internal.oxm.XMLBinaryDataHelper;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.mappings.BinaryDataCollectionMapping;
import org.eclipse.persistence.internal.oxm.mappings.BinaryDataMapping;
import org.eclipse.persistence.internal.oxm.mappings.ChoiceCollectionMapping;
import org.eclipse.persistence.internal.oxm.mappings.ChoiceObjectMapping;
import org.eclipse.persistence.internal.oxm.mappings.CollectionReferenceMapping;
import org.eclipse.persistence.internal.oxm.mappings.CompositeCollectionMapping;
import org.eclipse.persistence.internal.oxm.mappings.CompositeObjectMapping;
import org.eclipse.persistence.internal.oxm.mappings.DirectCollectionMapping;
import org.eclipse.persistence.internal.oxm.mappings.DirectMapping;
import org.eclipse.persistence.internal.oxm.mappings.InverseReferenceMapping;
import org.eclipse.persistence.internal.oxm.mappings.Mapping;
import org.eclipse.persistence.internal.oxm.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.internal.oxm.record.namespaces.MapNamespacePrefixMapper;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.jaxb.JAXBEnumTypeConverter;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.NamespacePrefixMapper;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLAnyAttributeMapping;
import org.eclipse.persistence.oxm.mappings.XMLAnyCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLAnyObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLFragmentCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLFragmentMapping;
import org.eclipse.persistence.sessions.Project;

public class JsonSchemaGenerator {
    Project project;
    JsonSchema schema;
    Map contextProperties;
    String attributePrefix;
    Class<?> rootClass;
    boolean namespaceAware;
    NamespaceResolver resolver;
    String NAMESPACE_SEPARATOR = ".";
    NamespacePrefixMapper prefixMapper = null;
    Property[] xopIncludeProp = null;
    XMLContext xmlContext;
    Property rootProperty = null;
    private JAXBContext jaxbContext;
    private static String DEFINITION_PATH = "#/definitions";
    private static HashMap<Class, JsonType> javaTypeToJsonType;

    public JsonSchemaGenerator(JAXBContext jaxbContext, Map properties) {
        this.xmlContext = jaxbContext.getXMLContext();
        this.jaxbContext = jaxbContext;
        this.contextProperties = properties;
        if (properties != null) {
            String namespaceSeparator;
            this.attributePrefix = (String)properties.get("eclipselink.json.attribute-prefix");
            Object prefixMapperValue = properties.get("eclipselink.namespace-prefix-mapper");
            if (prefixMapperValue != null) {
                this.prefixMapper = prefixMapperValue instanceof Map ? new MapNamespacePrefixMapper((Map)prefixMapperValue) : (NamespacePrefixMapper)prefixMapperValue;
            }
            if (this.prefixMapper != null && (namespaceSeparator = (String)properties.get("eclipselink.json.namespace-separator")) != null) {
                this.NAMESPACE_SEPARATOR = namespaceSeparator;
            }
        }
    }

    public JsonSchema generateSchema(Class<?> rootClass) {
        XMLField field;
        JsonType rootType;
        this.rootClass = rootClass;
        this.schema = new JsonSchema();
        this.schema.setTitle(rootClass.getName());
        if (rootClass.isEnum()) {
            Class<?> generatedWrapper = this.jaxbContext.getClassToGeneratedClasses().get(rootClass.getName());
            if (generatedWrapper != null) {
                rootClass = generatedWrapper;
            } else {
                this.schema.setType(JsonType.STRING);
                return this.schema;
            }
        }
        if ((rootType = this.getJsonTypeForJavaType(rootClass)) != JsonType.OBJECT) {
            if (rootType == JsonType.BINARYTYPE) {
                this.schema.setAnyOf(this.getXopIncludeProperties());
                return this.schema;
            }
            this.schema.setType(rootType);
            return this.schema;
        }
        Map<String, Property> properties = null;
        if (rootClass.isArray() || this.isCollection(rootClass)) {
            this.schema.setType(JsonType.ARRAY);
            this.schema.setItems(new Property());
            Class itemType = Object.class;
            if (rootClass.isArray()) {
                itemType = rootClass.getComponentType();
            } else {
                Type pType = rootClass.getGenericSuperclass();
                if (pType instanceof ParameterizedType) {
                    itemType = (Class)((ParameterizedType)pType).getActualTypeArguments()[0];
                }
            }
            rootType = this.getJsonTypeForJavaType(itemType);
            this.schema.getItems().setType(rootType);
            if (rootType != JsonType.OBJECT) {
                return this.schema;
            }
            rootClass = itemType;
            properties = this.schema.getItems().getProperties();
        } else {
            this.schema.setType(JsonType.OBJECT);
            properties = this.schema.getProperties();
        }
        this.project = this.xmlContext.getSession(rootClass).getProject();
        XMLDescriptor descriptor = (XMLDescriptor)this.project.getDescriptor(rootClass);
        Boolean includeRoot = Boolean.TRUE;
        if (this.contextProperties != null && (includeRoot = (Boolean)this.contextProperties.get("eclipselink.json.include-root")) == null) {
            includeRoot = Boolean.TRUE;
        }
        if (Boolean.TRUE.equals(includeRoot) && (field = descriptor.getDefaultRootElementField()) != null) {
            this.rootProperty = new Property();
            this.rootProperty.setType(JsonType.OBJECT);
            this.rootProperty.setName(this.getNameForFragment(field.getXPathFragment()));
            properties.put(this.rootProperty.getName(), this.rootProperty);
            properties = this.rootProperty.getProperties();
        }
        boolean allowsAdditionalProperties = this.hasAnyMappings(descriptor);
        if (descriptor.hasInheritance()) {
            List<ClassDescriptor> descriptors = this.getAllDescriptorsForInheritance(descriptor);
            Property[] props = new Property[descriptors.size()];
            for (int i = 0; i < props.length; ++i) {
                XMLDescriptor nextDescriptor = (XMLDescriptor)descriptors.get(i);
                Property ref = new Property();
                ref.setRef(this.getReferenceForDescriptor(nextDescriptor, true));
                props[i] = ref;
            }
            if (this.rootProperty != null) {
                this.rootProperty.setAnyOf(props);
                this.rootProperty.setProperties(null);
                this.rootProperty.setType(null);
                this.rootProperty.setAdditionalProperties(null);
                this.rootProperty.setAdditionalProperties(null);
            } else {
                this.schema.setAnyOf(props);
                this.schema.setProperties(null);
                this.schema.setType(null);
                this.schema.setAdditionalProperties(null);
            }
        } else {
            JsonType type = this.populateProperties(properties, descriptor);
            if (type != null) {
                if (type == JsonType.BINARYTYPE) {
                    if (this.rootProperty != null) {
                        this.rootProperty.setAnyOf(this.getXopIncludeProperties());
                        this.rootProperty.setProperties(null);
                        this.rootProperty.setAdditionalProperties(null);
                        this.rootProperty.setType(null);
                    } else {
                        this.schema.setAnyOf(this.getXopIncludeProperties());
                        this.schema.setProperties(null);
                        this.schema.setType(null);
                        this.schema.setAdditionalProperties(null);
                    }
                } else if (type == JsonType.ENUMTYPE) {
                    if (this.rootProperty != null) {
                        this.rootProperty.setType(JsonType.STRING);
                        this.rootProperty.setProperties(null);
                        this.rootProperty.setEnumeration(this.getEnumeration(descriptor));
                    } else {
                        this.schema.setType(JsonType.STRING);
                        this.schema.setProperties(null);
                        this.schema.setEnumeration(this.getEnumeration(descriptor));
                    }
                } else if (this.rootProperty != null) {
                    this.rootProperty.setType(type);
                } else {
                    this.schema.setType(type);
                }
            } else if (this.rootProperty != null) {
                this.rootProperty.setAdditionalProperties(allowsAdditionalProperties);
            } else {
                this.schema.setAdditionalProperties(allowsAdditionalProperties);
            }
        }
        return this.schema;
    }

    private List<String> getEnumeration(XMLDescriptor desc) {
        return this.getEnumeration(this.getTextMapping(desc));
    }

    private List<String> getEnumeration(DatabaseMapping textMapping) {
        JAXBEnumTypeConverter converter = null;
        if (textMapping.isAbstractDirectMapping()) {
            converter = (JAXBEnumTypeConverter)((DirectMapping)textMapping).getConverter();
        } else if (textMapping.isAbstractCompositeDirectCollectionMapping()) {
            converter = (JAXBEnumTypeConverter)((DirectCollectionMapping)textMapping).getValueConverter();
        }
        if (converter == null) {
            return null;
        }
        ArrayList<String> enumeration = new ArrayList<String>();
        for (Object nextValue : converter.getAttributeToFieldValues().values()) {
            enumeration.add(nextValue.toString());
        }
        return enumeration;
    }

    private boolean hasAnyMappings(XMLDescriptor descriptor) {
        for (DatabaseMapping next : descriptor.getMappings()) {
            CompositeCollectionMapping ccm;
            if (next instanceof XMLAnyAttributeMapping || next instanceof XMLAnyObjectMapping || next instanceof XMLAnyCollectionMapping || next instanceof XMLFragmentCollectionMapping || next instanceof XMLFragmentMapping) {
                return true;
            }
            if (!(next instanceof CompositeCollectionMapping ? (ccm = (CompositeCollectionMapping)next).getReferenceDescriptor() == null && ((XMLField)ccm.getField()).isSelfField() : next instanceof CompositeObjectMapping && (ccm = (CompositeObjectMapping)next).getReferenceDescriptor() == null && ((XMLField)ccm.getField()).isSelfField())) continue;
            return true;
        }
        return false;
    }

    private JsonType populateProperties(Map<String, Property> properties, XMLDescriptor descriptor) {
        Vector mappings = descriptor.getMappings();
        if (mappings == null || mappings.isEmpty()) {
            return null;
        }
        if (this.isSimpleType(descriptor)) {
            DatabaseMapping mapping = this.getTextMapping(descriptor);
            if (mapping.isAbstractDirectMapping()) {
                DirectMapping directMapping = (DirectMapping)mapping;
                if (directMapping.getConverter() instanceof JAXBEnumTypeConverter) {
                    return JsonType.ENUMTYPE;
                }
                return this.getJsonTypeForJavaType(directMapping.getAttributeClassification());
            }
            if (mapping.isAbstractCompositeDirectCollectionMapping()) {
                DirectCollectionMapping directMapping = (DirectCollectionMapping)mapping;
                if (directMapping.getValueConverter() instanceof JAXBEnumTypeConverter) {
                    return JsonType.ENUMTYPE;
                }
                Class type = directMapping.getAttributeElementClass();
                if (type == null) {
                    type = CoreClassConstants.STRING;
                }
                return this.getJsonTypeForJavaType(type);
            }
            return JsonType.BINARYTYPE;
        }
        for (DatabaseMapping next : mappings) {
            Property prop;
            ChoiceObjectMapping coMapping;
            if (next instanceof ChoiceObjectMapping) {
                coMapping = (ChoiceObjectMapping)next;
                for (Object nestedMapping : coMapping.getChoiceElementMappingsByClass().values()) {
                    prop = this.generateProperty((Mapping)nestedMapping, descriptor, properties);
                    if (prop == null || properties.containsKey(prop.getName())) continue;
                    properties.put(prop.getName(), prop);
                }
                continue;
            }
            if (next instanceof ChoiceCollectionMapping) {
                coMapping = (ChoiceCollectionMapping)next;
                for (Object nestedMapping : coMapping.getChoiceElementMappingsByClass().values()) {
                    prop = this.generateProperty((Mapping)nestedMapping, descriptor, properties);
                    if (prop == null || properties.containsKey(prop.getName())) continue;
                    properties.put(prop.getName(), prop);
                }
                continue;
            }
            Property prop2 = this.generateProperty((Mapping)next, descriptor, properties);
            if (prop2 == null || properties.containsKey(prop2.getName())) continue;
            properties.put(prop2.getName(), prop2);
        }
        return null;
    }

    private DatabaseMapping getTextMapping(XMLDescriptor descriptor) {
        for (DatabaseMapping next : descriptor.getMappings()) {
            DirectMapping mapping;
            if (next.isAbstractDirectMapping() && ((XMLField)(mapping = (DirectMapping)next).getField()).getXPathFragment().nameIsText()) {
                return next;
            }
            if (next.isAbstractCompositeDirectCollectionMapping() && ((XMLField)(mapping = (DirectCollectionMapping)next).getField()).getXPathFragment().nameIsText()) {
                return next;
            }
            if (next instanceof BinaryDataMapping && ((XMLField)(mapping = (BinaryDataMapping)next).getField()).isSelfField()) {
                return next;
            }
            if (!(next instanceof BinaryDataCollectionMapping) || !((XMLField)(mapping = (BinaryDataCollectionMapping)next).getField()).isSelfField()) continue;
            return next;
        }
        return null;
    }

    private boolean isSimpleType(XMLDescriptor descriptor) {
        DatabaseMapping mapping = null;
        if (descriptor.getMappings().size() == 1) {
            mapping = (DatabaseMapping)descriptor.getMappings().get(0);
        } else if (descriptor.getMappings().size() == 2) {
            boolean hasInverseRef = false;
            for (DatabaseMapping next : descriptor.getMappings()) {
                if (next instanceof InverseReferenceMapping) {
                    hasInverseRef = true;
                    continue;
                }
                mapping = next;
            }
            if (!hasInverseRef) {
                return false;
            }
        } else {
            return false;
        }
        if (mapping.isAbstractDirectMapping() && ((XMLField)mapping.getField()).getXPathFragment().nameIsText()) {
            return true;
        }
        if (mapping.isAbstractCompositeDirectCollectionMapping() && ((XMLField)mapping.getField()).getXPathFragment().nameIsText()) {
            return true;
        }
        if (mapping instanceof BinaryDataMapping && ((XMLField)mapping.getField()).isSelfField()) {
            return true;
        }
        return mapping instanceof BinaryDataCollectionMapping && ((XMLField)mapping.getField()).isSelfField();
    }

    private Property generateProperty(Mapping next, XMLDescriptor descriptor, Map<String, Property> properties) {
        Property prop = null;
        if (next.isCollectionMapping()) {
            if (next instanceof CollectionReferenceMapping) {
                CollectionReferenceMapping mapping = (CollectionReferenceMapping)next;
                Set sourceFields = mapping.getSourceToTargetKeyFieldAssociations().keySet();
                XMLDescriptor reference = (XMLDescriptor)mapping.getReferenceDescriptor();
                for (XMLField nextField : sourceFields) {
                    XPathFragment frag = nextField.getXPathFragment();
                    String propertyName = this.getNameForFragment(frag);
                    XMLField targetField = (XMLField)mapping.getSourceToTargetKeyFieldAssociations().get(nextField);
                    Class<?> type = CoreClassConstants.STRING;
                    if (reference != null) {
                        type = this.getTypeForTargetField(targetField, reference);
                    }
                    if ((prop = properties.get(propertyName)) == null) {
                        prop = new Property();
                        prop.setName(propertyName);
                    }
                    Property nestedProperty = this.getNestedPropertyForFragment(frag, prop);
                    nestedProperty.setType(JsonType.ARRAY);
                    nestedProperty.setItem(new Property());
                    nestedProperty.getItem().setType(this.getJsonTypeForJavaType(type));
                    if (properties.containsKey(prop.getName())) continue;
                    properties.put(prop.getName(), prop);
                }
                return prop;
            }
            if (next.isAbstractCompositeCollectionMapping()) {
                CompositeCollectionMapping mapping = (CompositeCollectionMapping)next;
                XMLField field = (XMLField)mapping.getField();
                XPathFragment frag = field.getXPathFragment();
                String propName = this.getNameForFragment(frag);
                prop = properties.get(propName);
                if (prop == null) {
                    prop = new Property();
                    prop.setName(propName);
                }
                Property nestedProperty = this.getNestedPropertyForFragment(frag, prop);
                nestedProperty.setType(JsonType.ARRAY);
                nestedProperty.setItem(new Property());
                XMLDescriptor referenceDescriptor = (XMLDescriptor)mapping.getReferenceDescriptor();
                if (referenceDescriptor != null && referenceDescriptor.hasInheritance()) {
                    List<ClassDescriptor> descriptors = this.getAllDescriptorsForInheritance(referenceDescriptor);
                    Property[] props = new Property[descriptors.size()];
                    for (int i = 0; i < props.length; ++i) {
                        XMLDescriptor nextDescriptor = null;
                        nextDescriptor = (XMLDescriptor)descriptors.get(i);
                        Property ref = new Property();
                        ref.setRef(this.getReferenceForDescriptor(nextDescriptor, true));
                        props[i] = ref;
                    }
                    nestedProperty.getItem().setAnyOf(props);
                } else {
                    nestedProperty.getItem().setRef(this.getReferenceForDescriptor(referenceDescriptor, false));
                }
            } else {
                if (next.isAbstractCompositeDirectCollectionMapping()) {
                    Class type;
                    DirectCollectionMapping mapping = (DirectCollectionMapping)next;
                    XMLField field = (XMLField)mapping.getField();
                    XPathFragment frag = field.getXPathFragment();
                    List<String> enumeration = null;
                    if (mapping.getValueConverter() instanceof JAXBEnumTypeConverter) {
                        enumeration = this.getEnumeration((DatabaseMapping)next);
                    }
                    Object propertyName = this.getNameForFragment(frag);
                    if (frag.nameIsText()) {
                        propertyName = (String)this.contextProperties.get("eclipselink.json.value-wrapper");
                    }
                    if (frag.isAttribute() && this.attributePrefix != null) {
                        propertyName = this.attributePrefix + (String)propertyName;
                    }
                    if ((prop = properties.get(propertyName)) == null) {
                        prop = new Property();
                        prop.setName((String)propertyName);
                    }
                    Property nestedProperty = this.getNestedPropertyForFragment(frag, prop);
                    nestedProperty.setType(JsonType.ARRAY);
                    nestedProperty.setItem(new Property());
                    if (enumeration != null) {
                        nestedProperty.getItem().setEnumeration(enumeration);
                    }
                    if ((type = mapping.getAttributeElementClass()) == null) {
                        type = CoreClassConstants.STRING;
                    }
                    nestedProperty.getItem().setType(this.getJsonTypeForJavaType(type));
                    return prop;
                }
                if (next instanceof BinaryDataCollectionMapping) {
                    BinaryDataCollectionMapping mapping = (BinaryDataCollectionMapping)next;
                    XMLField field = (XMLField)mapping.getField();
                    XPathFragment frag = field.getXPathFragment();
                    Object propertyName = this.getNameForFragment(frag);
                    if (frag.isSelfFragment()) {
                        String valueWrapper;
                        propertyName = "value";
                        if (this.contextProperties != null && (valueWrapper = (String)this.contextProperties.get("eclipselink.json.value-wrapper")) != null) {
                            propertyName = valueWrapper;
                        }
                    }
                    if (frag.isAttribute() && this.attributePrefix != null) {
                        propertyName = this.attributePrefix + (String)propertyName;
                    }
                    if ((prop = properties.get(propertyName)) == null) {
                        prop = new Property();
                        prop.setName((String)propertyName);
                    }
                    Property nestedProperty = this.getNestedPropertyForFragment(frag, prop);
                    nestedProperty.setType(JsonType.ARRAY);
                    nestedProperty.setItem(new Property());
                    if (mapping.shouldInlineBinaryData()) {
                        nestedProperty.getItem().setType(JsonType.STRING);
                    } else {
                        nestedProperty.getItem().setAnyOf(this.getXopIncludeProperties());
                    }
                    return prop;
                }
            }
        } else {
            if (next.isAbstractDirectMapping()) {
                DirectMapping directMapping = (DirectMapping)next;
                XMLField field = (XMLField)directMapping.getField();
                XPathFragment frag = field.getXPathFragment();
                List<String> enumeration = null;
                if (directMapping.getConverter() instanceof JAXBEnumTypeConverter) {
                    enumeration = this.getEnumeration((DatabaseMapping)directMapping);
                }
                Object propertyName = this.getNameForFragment(frag);
                if (frag.nameIsText()) {
                    String valueWrapper;
                    propertyName = "value";
                    if (this.contextProperties != null && (valueWrapper = (String)this.contextProperties.get("eclipselink.json.value-wrapper")) != null) {
                        propertyName = valueWrapper;
                    }
                }
                if (frag.isAttribute() && this.attributePrefix != null) {
                    propertyName = this.attributePrefix + (String)propertyName;
                }
                if ((prop = properties.get(propertyName)) == null) {
                    prop = new Property();
                    prop.setName((String)propertyName);
                }
                Property nestedProperty = this.getNestedPropertyForFragment(frag, prop);
                if (enumeration != null) {
                    nestedProperty.setEnumeration(enumeration);
                }
                if (directMapping instanceof BinaryDataMapping) {
                    BinaryDataMapping binaryMapping = (BinaryDataMapping)directMapping;
                    if (binaryMapping.shouldInlineBinaryData() || binaryMapping.isSwaRef()) {
                        nestedProperty.setType(JsonType.STRING);
                    } else {
                        if (this.xopIncludeProp == null) {
                            this.initXopIncludeProp();
                        }
                        nestedProperty.setAnyOf(this.xopIncludeProp);
                    }
                } else {
                    nestedProperty.setType(this.getJsonTypeForJavaType(directMapping.getAttributeClassification()));
                }
                return prop;
            }
            if (next instanceof ObjectReferenceMapping) {
                ObjectReferenceMapping mapping = (ObjectReferenceMapping)next;
                Set sourceFields = mapping.getSourceToTargetKeyFieldAssociations().keySet();
                XMLDescriptor reference = (XMLDescriptor)mapping.getReferenceDescriptor();
                for (XMLField nextField : sourceFields) {
                    XPathFragment frag = nextField.getXPathFragment();
                    String propName = this.getNameForFragment(frag);
                    XMLField targetField = (XMLField)mapping.getSourceToTargetKeyFieldAssociations().get(nextField);
                    Class<?> type = CoreClassConstants.STRING;
                    if (reference != null) {
                        type = this.getTypeForTargetField(targetField, reference);
                    }
                    if ((prop = properties.get(propName)) == null) {
                        prop = new Property();
                        prop.setName(propName);
                    }
                    Property nestedProperty = this.getNestedPropertyForFragment(frag, prop);
                    nestedProperty.setType(this.getJsonTypeForJavaType(type));
                    if (properties.containsKey(prop.getName())) continue;
                    properties.put(prop.getName(), prop);
                }
                return prop;
            }
            if (next.isAbstractCompositeObjectMapping()) {
                CompositeObjectMapping mapping = (CompositeObjectMapping)next;
                XMLDescriptor nextDescriptor = (XMLDescriptor)mapping.getReferenceDescriptor();
                XMLField field = (XMLField)mapping.getField();
                XPathFragment firstFragment = field.getXPathFragment();
                if (firstFragment.isSelfFragment() || firstFragment.nameIsText()) {
                    if (nextDescriptor != null) {
                        this.populateProperties(properties, nextDescriptor);
                    }
                } else {
                    String propName = this.getNameForFragment(firstFragment);
                    prop = properties.get(propName);
                    if (prop == null) {
                        prop = new Property();
                        prop.setName(propName);
                    }
                    prop.setName(propName);
                    Property nestedProperty = this.getNestedPropertyForFragment(firstFragment, prop);
                    XMLDescriptor referenceDescriptor = (XMLDescriptor)mapping.getReferenceDescriptor();
                    if (referenceDescriptor != null && referenceDescriptor.hasInheritance()) {
                        List<ClassDescriptor> descriptors = this.getAllDescriptorsForInheritance(referenceDescriptor);
                        Property[] props = new Property[descriptors.size()];
                        for (int i = 0; i < props.length; ++i) {
                            XMLDescriptor nextDesc = (XMLDescriptor)descriptors.get(i);
                            Property ref = new Property();
                            ref.setRef(this.getReferenceForDescriptor(nextDesc, true));
                            props[i] = ref;
                        }
                        nestedProperty.setAnyOf(props);
                    } else {
                        nestedProperty.setRef(this.getReferenceForDescriptor(referenceDescriptor, false));
                    }
                }
            } else if (next instanceof BinaryDataMapping) {
                BinaryDataMapping binaryMapping = (BinaryDataMapping)next;
                XMLField field = (XMLField)binaryMapping.getField();
                XPathFragment frag = field.getXPathFragment();
                Object propertyName = this.getNameForFragment(frag);
                if (frag.isSelfFragment()) {
                    String valueWrapper;
                    propertyName = "value";
                    if (this.contextProperties != null && (valueWrapper = (String)this.contextProperties.get("eclipselink.json.value-wrapper")) != null) {
                        propertyName = valueWrapper;
                    }
                }
                if (frag.isAttribute() && this.attributePrefix != null) {
                    propertyName = this.attributePrefix + (String)propertyName;
                }
                if ((prop = properties.get(propertyName)) == null) {
                    prop = new Property();
                    prop.setName((String)propertyName);
                }
                Property nestedProperty = this.getNestedPropertyForFragment(frag, prop);
                if (binaryMapping.shouldInlineBinaryData() || binaryMapping.isSwaRef()) {
                    nestedProperty.setType(JsonType.STRING);
                } else {
                    if (this.xopIncludeProp == null) {
                        this.initXopIncludeProp();
                    }
                    nestedProperty.setAnyOf(this.xopIncludeProp);
                }
                return prop;
            }
        }
        return prop;
    }

    private String getNameForFragment(XPathFragment frag) {
        String prefix;
        String namespaceUri;
        Object name = frag.getLocalName();
        if (this.prefixMapper != null && (namespaceUri = frag.getNamespaceURI()) != null && namespaceUri.length() != 0 && (prefix = this.prefixMapper.getPreferredPrefix(namespaceUri, null, true)) != null) {
            name = prefix + this.NAMESPACE_SEPARATOR + (String)name;
        }
        return name;
    }

    private void initXopIncludeProp() {
        this.xopIncludeProp = new Property[2];
        Property p = new Property();
        p.setType(JsonType.STRING);
        this.xopIncludeProp[0] = p;
        this.xopIncludeProp[1] = p = new Property();
        p.setType(JsonType.OBJECT);
        Property includeProperty = new Property();
        includeProperty.setName("Include");
        includeProperty.setType(JsonType.OBJECT);
        p.getProperties().put(includeProperty.getName(), includeProperty);
        Property hrefProp = new Property();
        Object propName = "href";
        if (this.attributePrefix != null) {
            propName = this.attributePrefix + (String)propName;
        }
        hrefProp.setName((String)propName);
        hrefProp.setType(JsonType.STRING);
        includeProperty.getProperties().put((String)propName, hrefProp);
    }

    private String getReferenceForDescriptor(XMLDescriptor referenceDescriptor, boolean generateRoot) {
        if (referenceDescriptor == null) {
            return null;
        }
        String className = referenceDescriptor.getJavaClass().getSimpleName();
        String referenceName = DEFINITION_PATH + "/" + className;
        if (referenceDescriptor.getJavaClass() == this.rootClass && !generateRoot) {
            Object ref = "#";
            if (this.rootProperty != null) {
                ref = (String)ref + "/properties/" + this.rootProperty.getName();
            }
            return ref;
        }
        if (!this.schema.getDefinitions().containsKey(className)) {
            JsonType jType;
            Property definition = new Property();
            definition.setName(className);
            this.schema.getDefinitions().put(definition.getName(), definition);
            definition.setType(JsonType.OBJECT);
            if (referenceDescriptor.hasInheritance() && referenceDescriptor.getInheritancePolicy().hasClassIndicator()) {
                XMLField f = (XMLField)referenceDescriptor.getInheritancePolicy().getClassIndicatorField();
                Property indicatorProp = new Property();
                indicatorProp.setName(this.getNameForFragment(f.getXPathFragment()));
                indicatorProp.setType(JsonType.STRING);
                definition.getProperties().put(indicatorProp.getName(), indicatorProp);
            }
            if ((jType = this.populateProperties(definition.getProperties(), referenceDescriptor)) != null) {
                if (jType == JsonType.BINARYTYPE) {
                    definition.setAnyOf(this.getXopIncludeProperties());
                    definition.setProperties(null);
                    definition.setAdditionalProperties(null);
                    definition.setType(null);
                } else {
                    definition.setType(jType);
                    definition.setProperties(null);
                }
            }
            definition.setAdditionalProperties(this.hasAnyMappings(referenceDescriptor));
        }
        return referenceName;
    }

    private Class<?> getTypeForTargetField(XMLField targetField, XMLDescriptor reference) {
        for (DatabaseMapping next : reference.getMappings()) {
            DirectMapping directMapping;
            if (!next.isDirectToFieldMapping() || !(directMapping = (DirectMapping)next).getField().equals(targetField)) continue;
            return directMapping.getAttributeClassification();
        }
        return null;
    }

    private JsonType getJsonTypeForJavaType(Class<?> attributeClassification) {
        if (attributeClassification.isEnum()) {
            return JsonType.ENUMTYPE;
        }
        HashMap<Class, JsonType> types = JsonSchemaGenerator.getJavaTypeToJsonType();
        JsonType jsonType = types.get(attributeClassification);
        if (jsonType == null) {
            return JsonType.OBJECT;
        }
        return jsonType;
    }

    private static HashMap<Class, JsonType> getJavaTypeToJsonType() {
        if (javaTypeToJsonType == null) {
            JsonSchemaGenerator.initJavaTypeToJsonType();
        }
        return javaTypeToJsonType;
    }

    private static void initJavaTypeToJsonType() {
        javaTypeToJsonType = new HashMap();
        javaTypeToJsonType.put(CoreClassConstants.APBYTE, JsonType.ARRAY);
        javaTypeToJsonType.put(CoreClassConstants.BIGDECIMAL, JsonType.NUMBER);
        javaTypeToJsonType.put(CoreClassConstants.BIGINTEGER, JsonType.INTEGER);
        javaTypeToJsonType.put(CoreClassConstants.PBOOLEAN, JsonType.BOOLEAN);
        javaTypeToJsonType.put(CoreClassConstants.PBYTE, JsonType.NUMBER);
        javaTypeToJsonType.put(CoreClassConstants.CALENDAR, JsonType.STRING);
        javaTypeToJsonType.put(CoreClassConstants.PDOUBLE, JsonType.NUMBER);
        javaTypeToJsonType.put(CoreClassConstants.PFLOAT, JsonType.NUMBER);
        javaTypeToJsonType.put(CoreClassConstants.PINT, JsonType.INTEGER);
        javaTypeToJsonType.put(CoreClassConstants.PLONG, JsonType.NUMBER);
        javaTypeToJsonType.put(CoreClassConstants.PSHORT, JsonType.NUMBER);
        javaTypeToJsonType.put(CoreClassConstants.STRING, JsonType.STRING);
        javaTypeToJsonType.put(CoreClassConstants.CHAR, JsonType.STRING);
        javaTypeToJsonType.put(CoreClassConstants.ABYTE, JsonType.ARRAY);
        javaTypeToJsonType.put(CoreClassConstants.BOOLEAN, JsonType.BOOLEAN);
        javaTypeToJsonType.put(CoreClassConstants.BYTE, JsonType.NUMBER);
        javaTypeToJsonType.put(CoreClassConstants.CLASS, JsonType.STRING);
        javaTypeToJsonType.put(CoreClassConstants.GREGORIAN_CALENDAR, JsonType.STRING);
        javaTypeToJsonType.put(CoreClassConstants.DOUBLE, JsonType.NUMBER);
        javaTypeToJsonType.put(CoreClassConstants.FLOAT, JsonType.NUMBER);
        javaTypeToJsonType.put(CoreClassConstants.INTEGER, JsonType.INTEGER);
        javaTypeToJsonType.put(CoreClassConstants.LONG, JsonType.NUMBER);
        javaTypeToJsonType.put(CoreClassConstants.OBJECT, JsonType.OBJECT);
        javaTypeToJsonType.put(CoreClassConstants.SHORT, JsonType.NUMBER);
        javaTypeToJsonType.put(CoreClassConstants.UTILDATE, JsonType.STRING);
        javaTypeToJsonType.put(CoreClassConstants.SQLDATE, JsonType.STRING);
        javaTypeToJsonType.put(CoreClassConstants.TIME, JsonType.STRING);
        javaTypeToJsonType.put(CoreClassConstants.TIMESTAMP, JsonType.STRING);
        javaTypeToJsonType.put(CoreClassConstants.DURATION, JsonType.STRING);
        javaTypeToJsonType.put(Constants.QNAME_CLASS, JsonType.STRING);
        javaTypeToJsonType.put(Constants.URI, JsonType.STRING);
        javaTypeToJsonType.put(Constants.UUID, JsonType.STRING);
        javaTypeToJsonType.put(XMLBinaryDataHelper.getXMLBinaryDataHelper().DATA_HANDLER, JsonType.BINARYTYPE);
        javaTypeToJsonType.put(XMLBinaryDataHelper.getXMLBinaryDataHelper().IMAGE, JsonType.BINARYTYPE);
        javaTypeToJsonType.put(XMLBinaryDataHelper.getXMLBinaryDataHelper().SOURCE, JsonType.BINARYTYPE);
        javaTypeToJsonType.put(XMLBinaryDataHelper.getXMLBinaryDataHelper().MULTIPART, JsonType.BINARYTYPE);
    }

    private Property getNestedPropertyForFragment(XPathFragment frag, Property prop) {
        if (frag.getNextFragment() == null || frag.getNextFragment().nameIsText()) {
            return prop;
        }
        Map<String, Property> currentProperties = prop.getProperties();
        prop.setProperties(currentProperties);
        prop.setType(JsonType.OBJECT);
        frag = frag.getNextFragment();
        Object propertyName = this.getNameForFragment(frag);
        if (frag.isAttribute() && this.attributePrefix != null) {
            propertyName = this.attributePrefix + "propertyName";
        }
        while (frag != null && !frag.nameIsText()) {
            Property nestedProperty = prop.getProperty((String)propertyName);
            if (nestedProperty == null) {
                nestedProperty = new Property();
                nestedProperty.setName((String)propertyName);
            }
            currentProperties.put(nestedProperty.getName(), nestedProperty);
            if (frag.getNextFragment() == null || frag.getNextFragment().nameIsText()) {
                return nestedProperty;
            }
            nestedProperty.setType(JsonType.OBJECT);
            currentProperties = nestedProperty.getProperties();
            frag = frag.getNextFragment();
            propertyName = this.getNameForFragment(frag);
        }
        return null;
    }

    private Property[] getXopIncludeProperties() {
        if (this.xopIncludeProp == null) {
            this.initXopIncludeProp();
        }
        return this.xopIncludeProp;
    }

    private boolean isCollection(Class<?> type) {
        return CoreClassConstants.Collection_Class.isAssignableFrom(type) || CoreClassConstants.List_Class.isAssignableFrom(type) || CoreClassConstants.Set_Class.isAssignableFrom(type);
    }

    private List<ClassDescriptor> getAllDescriptorsForInheritance(XMLDescriptor descriptor) {
        ArrayList<ClassDescriptor> descriptors = new ArrayList<ClassDescriptor>();
        QNameInheritancePolicy policy = (QNameInheritancePolicy)descriptor.getInheritancePolicy();
        descriptors.add((ClassDescriptor)descriptor);
        descriptors.addAll(policy.getAllChildDescriptors());
        ClassDescriptor parent = policy.getParentDescriptor();
        while (parent != null) {
            descriptors.add(parent);
            parent = parent.getInheritancePolicy().getParentDescriptor();
        }
        return descriptors;
    }
}

