/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util;

import oracle.kv.Key;
import oracle.kv.KeyRange;
import oracle.kv.Value;
import oracle.kv.impl.param.ParameterListener;
import oracle.kv.impl.param.ParameterMap;

public class UserDataControl {
    public static final String HIDDEN = "[hidden]";
    private static ParameterListener PARAM_SETTER = new ParamSetter();
    private static volatile boolean hideKey = true;
    private static volatile boolean hideValue = true;

    private static void setKeyHiding(boolean shouldHide) {
        hideKey = shouldHide;
    }

    private static void setValueHiding(boolean shouldHide) {
        hideValue = shouldHide;
    }

    public static boolean hideUserData() {
        return hideKey || hideValue;
    }

    public static String displayKey(byte[] keyBytes) {
        if (keyBytes == null) {
            return "null";
        }
        return hideKey ? HIDDEN : Key.fromByteArray(keyBytes).toString();
    }

    public static String displayKey(Key key) {
        if (key == null) {
            return "null";
        }
        return hideKey ? HIDDEN : key.toString();
    }

    public static String displayKeyRange(KeyRange keyRange) {
        if (keyRange == null) {
            return "null";
        }
        return hideKey ? HIDDEN : keyRange.toString();
    }

    public static String displayValue(Value value, byte[] valueBytes) {
        if (value == null) {
            if (valueBytes == null) {
                return "null";
            }
            return hideValue ? HIDDEN : Value.fromByteArray(valueBytes).toString();
        }
        return hideValue ? HIDDEN : value.toString();
    }

    public static ParameterListener getParamListener() {
        return PARAM_SETTER;
    }

    private static class ParamSetter
    implements ParameterListener {
        private ParamSetter() {
        }

        @Override
        public void newParameters(ParameterMap oldMap, ParameterMap newMap) {
            boolean hideData = newMap.getOrDefault("hideUserData").asBoolean();
            UserDataControl.setKeyHiding(hideData);
            UserDataControl.setValueHiding(hideData);
        }
    }
}

