/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async.registry;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.async.DialogType;
import oracle.kv.impl.async.NetworkAddress;
import oracle.kv.impl.util.FastExternalizable;
import oracle.kv.impl.util.ObjectUtil;
import oracle.kv.impl.util.registry.ClearClientSocketFactory;
import oracle.kv.impl.util.registry.ClientSocketFactory;
import oracle.kv.impl.util.registry.ssl.SSLClientSocketFactory;

public class ServiceEndpoint
implements FastExternalizable {
    private final NetworkAddress address;
    private final DialogType dialogType;
    private final ClientSocketFactory clientSocketFactory;

    public ServiceEndpoint(NetworkAddress address, DialogType dialogType, ClientSocketFactory clientSocketFactory) {
        this.address = ObjectUtil.checkNull("address", address);
        this.dialogType = ObjectUtil.checkNull("dialogType", dialogType);
        this.clientSocketFactory = ObjectUtil.checkNull("clientSocketFactory", clientSocketFactory);
    }

    public ServiceEndpoint(DataInput in, short serialVersion) throws IOException {
        this.address = new NetworkAddress(in, serialVersion);
        this.dialogType = DialogType.readFastExternal(in, serialVersion);
        SocketFactoryType socketFactoryType = SocketFactoryType.readFastExternal(in, serialVersion);
        switch (socketFactoryType) {
            case CLEAR: {
                this.clientSocketFactory = new ClearClientSocketFactory(in, serialVersion);
                break;
            }
            case SSL: {
                this.clientSocketFactory = new SSLClientSocketFactory(in, serialVersion);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        this.address.writeFastExternal(out, serialVersion);
        this.dialogType.writeFastExternal(out, serialVersion);
        this.getSocketFactoryType().writeFastExternal(out, serialVersion);
        this.clientSocketFactory.writeFastExternal(out, serialVersion);
    }

    private SocketFactoryType getSocketFactoryType() {
        return this.clientSocketFactory instanceof SSLClientSocketFactory ? SocketFactoryType.SSL : SocketFactoryType.CLEAR;
    }

    public NetworkAddress getNetworkAddress() {
        return this.address;
    }

    public DialogType getDialogType() {
        return this.dialogType;
    }

    public ClientSocketFactory getClientSocketFactory() {
        return this.clientSocketFactory;
    }

    public boolean equals(Object object) {
        if (object instanceof ServiceEndpoint) {
            ServiceEndpoint endpoint = (ServiceEndpoint)object;
            return this.address.equals(endpoint.address) && this.dialogType.equals(endpoint.dialogType) && this.clientSocketFactory.equals(endpoint.clientSocketFactory);
        }
        return false;
    }

    public int hashCode() {
        int prime = 7;
        int value = 11;
        value = value * 7 + this.address.hashCode();
        value = value * 7 + this.dialogType.hashCode();
        value = value * 7 + this.clientSocketFactory.hashCode();
        return value;
    }

    public String toString() {
        return "ServiceEndpoint[address=" + this.address + " dialogType=" + this.dialogType + " clientSocketFactory=" + this.clientSocketFactory + "]";
    }

    public static enum SocketFactoryType implements FastExternalizable
    {
        CLEAR(0),
        SSL(1);

        private static final SocketFactoryType[] VALUES;

        private SocketFactoryType(int ordinal) {
            if (ordinal != this.ordinal()) {
                throw new IllegalArgumentException("Wrong ordinal");
            }
        }

        public static SocketFactoryType readFastExternal(DataInput in, short serialVersion) throws IOException {
            byte ordinal = in.readByte();
            try {
                return VALUES[ordinal];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IOException("Wrong value for SocketFactoryType: " + ordinal, e);
            }
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            out.writeByte(this.ordinal());
        }

        static {
            VALUES = SocketFactoryType.values();
        }
    }
}

