/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.util.PackedInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import oracle.kv.Depth;
import oracle.kv.Direction;
import oracle.kv.KeyValueVersion;
import oracle.kv.ValueVersion;
import oracle.kv.Version;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.KeySerializer;
import oracle.kv.impl.api.Request;
import oracle.kv.impl.api.StoreIteratorParams;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.MultiTableOperation;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.ops.ResultKey;
import oracle.kv.impl.api.ops.ResultKeyValueVersion;
import oracle.kv.impl.api.ops.TableIterate;
import oracle.kv.impl.api.ops.TableKeysIterate;
import oracle.kv.impl.api.parallelscan.PartitionScanIterator;
import oracle.kv.impl.api.table.RowImpl;
import oracle.kv.impl.api.table.TableAPIImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TableKey;
import oracle.kv.impl.api.table.TargetTables;
import oracle.kv.impl.async.AsyncTableIterator;
import oracle.kv.impl.async.IterationHandleNotifier;
import oracle.kv.impl.async.ResultHandler;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.util.contextlogger.LogContext;
import oracle.kv.query.ExecuteOptions;
import oracle.kv.stats.DetailedMetrics;
import oracle.kv.table.MultiGetResult;
import oracle.kv.table.MultiRowOptions;
import oracle.kv.table.PrimaryKey;
import oracle.kv.table.Row;
import oracle.kv.table.TableIteratorOptions;

public class TableScan {
    private TableScan() {
    }

    static AsyncTableIterator<Row> createTableIterator(final TableAPIImpl apiImpl, final TableKey key, MultiRowOptions getOptions, TableIteratorOptions iterateOptions, Set<Integer> partitions, IterationHandleNotifier iterHandleNotifier) {
        final TargetTables targetTables = TableAPIImpl.makeTargetTables(key.getTable(), getOptions);
        ExecuteOptions options = new ExecuteOptions();
        if (iterateOptions != null) {
            options.setMaxConcurrentRequests(iterateOptions.getMaxConcurrentRequests());
        }
        final StoreIteratorParams params = new StoreIteratorParams(TableAPIImpl.getDirection(iterateOptions, key), TableAPIImpl.getBatchSize(iterateOptions), key.getKeyBytes(), TableAPIImpl.makeKeyRange(key, getOptions), Depth.PARENT_AND_DESCENDANTS, TableAPIImpl.getConsistency(iterateOptions), TableAPIImpl.getTimeout(iterateOptions), TableAPIImpl.getTimeoutUnit(iterateOptions), partitions);
        if (key.getMajorKeyComplete()) {
            return TableScan.createPartitionRowIterator(apiImpl, params, key, targetTables, iterHandleNotifier);
        }
        return new PartitionScanIterator<Row>(apiImpl.getStore(), options, params, iterHandleNotifier){

            @Override
            protected TableIterate generateGetterOp(byte[] resumeKey) {
                return new TableIterate(params, targetTables, key.getMajorKeyComplete(), resumeKey, 1);
            }

            @Override
            protected void convertResult(Result result, List<Row> elementList) {
                TableScan.convertTableRowResults(apiImpl, key.getTable(), targetTables, result.getKeyValueVersionList(), elementList);
            }

            @Override
            protected int compare(Row one, Row two) {
                return ((RowImpl)one).compareKeys(two);
            }
        };
    }

    static MultiGetResult<Row> multiGet(TableAPIImpl apiImpl, TableKey key, byte[] continuationKey, MultiRowOptions getOptions, TableIteratorOptions iterateOptions, LogContext lc) {
        return new PartitionMultiGetHandler(apiImpl, key, continuationKey, getOptions, iterateOptions, lc).execute();
    }

    static void multiGetAsync(TableAPIImpl apiImpl, TableKey key, byte[] continuationKey, MultiRowOptions getOptions, TableIteratorOptions iterateOptions, ResultHandler<MultiGetResult<Row>> handler, LogContext lc) {
        new PartitionMultiGetHandler(apiImpl, key, continuationKey, getOptions, iterateOptions, lc).executeAsync(handler);
    }

    static MultiGetResult<PrimaryKey> multiGetKeys(TableAPIImpl apiImpl, TableKey key, byte[] continuationKey, MultiRowOptions getOptions, TableIteratorOptions iterateOptions, LogContext lc) {
        return new PartitionMultiGetKeysHandler(apiImpl, key, continuationKey, getOptions, iterateOptions, lc).execute();
    }

    static void multiGetKeysAsync(TableAPIImpl apiImpl, TableKey key, byte[] continuationKey, MultiRowOptions getOptions, TableIteratorOptions iterateOptions, ResultHandler<MultiGetResult<PrimaryKey>> handler, LogContext lc) {
        new PartitionMultiGetKeysHandler(apiImpl, key, continuationKey, getOptions, iterateOptions, lc).executeAsync(handler);
    }

    static AsyncTableIterator<PrimaryKey> createTableKeysIterator(TableAPIImpl apiImpl, final TableKey key, MultiRowOptions getOptions, TableIteratorOptions iterateOptions, IterationHandleNotifier iterHandleNotifier) {
        final TargetTables targetTables = TableAPIImpl.makeTargetTables(key.getTable(), getOptions);
        ExecuteOptions options = new ExecuteOptions();
        if (iterateOptions != null) {
            options.setMaxConcurrentRequests(iterateOptions.getMaxConcurrentRequests());
        }
        final StoreIteratorParams params = new StoreIteratorParams(TableAPIImpl.getDirection(iterateOptions, key), TableAPIImpl.getBatchSize(iterateOptions), key.getKeyBytes(), TableAPIImpl.makeKeyRange(key, getOptions), Depth.PARENT_AND_DESCENDANTS, TableAPIImpl.getConsistency(iterateOptions), TableAPIImpl.getTimeout(iterateOptions), TableAPIImpl.getTimeoutUnit(iterateOptions));
        if (key.getMajorKeyComplete()) {
            return TableScan.createPartitionKeyIterator(apiImpl, params, key, targetTables, iterHandleNotifier);
        }
        return new PartitionScanIterator<PrimaryKey>(apiImpl.getStore(), options, params, iterHandleNotifier){

            @Override
            protected TableKeysIterate generateGetterOp(byte[] resumeKey) {
                return new TableKeysIterate(params, targetTables, key.getMajorKeyComplete(), resumeKey, 1);
            }

            @Override
            protected void convertResult(Result result, List<PrimaryKey> elementList) {
                TableScan.convertTableKeyResults(key.getTable(), targetTables, result.getKeyList(), elementList);
            }

            @Override
            protected int compare(PrimaryKey one, PrimaryKey two) {
                return one.compareTo(two);
            }
        };
    }

    static AsyncTableIterator<KeyValueVersion> createTableKVIterator(TableAPIImpl apiImpl, final TableKey key, MultiRowOptions getOptions, TableIteratorOptions iterateOptions, Set<Integer> partitions) {
        final TargetTables targetTables = TableAPIImpl.makeTargetTables(key.getTable(), getOptions);
        ExecuteOptions options = new ExecuteOptions();
        if (iterateOptions != null) {
            options.setMaxConcurrentRequests(iterateOptions.getMaxConcurrentRequests());
        }
        final StoreIteratorParams params = new StoreIteratorParams(TableAPIImpl.getDirection(iterateOptions, key), TableAPIImpl.getBatchSize(iterateOptions), key.getKeyBytes(), TableAPIImpl.makeKeyRange(key, getOptions), Depth.PARENT_AND_DESCENDANTS, TableAPIImpl.getConsistency(iterateOptions), TableAPIImpl.getTimeout(iterateOptions), TableAPIImpl.getTimeoutUnit(iterateOptions), partitions);
        if (key.getMajorKeyComplete()) {
            throw new IllegalArgumentException("The major path cannot be complete for the key.");
        }
        return new PartitionScanIterator<KeyValueVersion>(apiImpl.getStore(), options, params){

            @Override
            protected TableIterate generateGetterOp(byte[] resumeKey) {
                return new TableIterate(params, targetTables, key.getMajorKeyComplete(), resumeKey, 1);
            }

            @Override
            protected void convertResult(Result result, List<KeyValueVersion> elementList) {
                List<ResultKeyValueVersion> byteKeyResults = result.getKeyValueVersionList();
                int cnt = byteKeyResults.size();
                if (cnt == 0) {
                    assert (!result.hasMoreElements());
                    return;
                }
                for (int i = 0; i < cnt; ++i) {
                    ResultKeyValueVersion entry = byteKeyResults.get(i);
                    KeySerializer keySerializer = this.storeImpl.getKeySerializer();
                    elementList.add(KVStoreImpl.createKeyValueVersion(keySerializer.fromByteArray(entry.getKeyBytes()), entry.getValue(), entry.getVersion(), entry.getExpirationTime()));
                }
            }

            @Override
            protected int compare(KeyValueVersion one, KeyValueVersion two) {
                return one.getKey().compareTo(two.getKey());
            }
        };
    }

    private static void convertTableRowResults(TableAPIImpl apiImpl, TableImpl table, TargetTables targetTables, List<ResultKeyValueVersion> byteKeyResults, List<Row> rowResults) {
        if (byteKeyResults.isEmpty()) {
            return;
        }
        for (ResultKeyValueVersion entry : byteKeyResults) {
            rowResults.add(TableScan.convertToRow(apiImpl, entry, table, targetTables));
        }
    }

    private static Row[] convertTableRowResults(TableAPIImpl apiImpl, TableImpl table, TargetTables targetTables, List<ResultKeyValueVersion> byteKeyResults) {
        if (byteKeyResults.isEmpty()) {
            return null;
        }
        Row[] rows = new Row[byteKeyResults.size()];
        int i = 0;
        for (ResultKeyValueVersion entry : byteKeyResults) {
            rows[i++] = TableScan.convertToRow(apiImpl, entry, table, targetTables);
        }
        return rows;
    }

    private static Row convertToRow(TableAPIImpl apiImpl, ResultKeyValueVersion rkvv, TableImpl table, TargetTables targetTables) {
        RowImpl fullKey;
        if (targetTables.hasAncestorTables()) {
            table = table.getTopLevelTable();
        }
        if ((fullKey = table.createRowFromKeyBytes(rkvv.getKeyBytes())) != null) {
            Version version = rkvv.getVersion();
            assert (version != null);
            ValueVersion vv = new ValueVersion(rkvv.getValue(), version);
            return apiImpl.getRowFromValueVersion(vv, fullKey, rkvv.getExpirationTime(), false);
        }
        return null;
    }

    private static void convertTableKeyResults(TableImpl table, TargetTables targetTables, List<ResultKey> byteKeyResults, List<PrimaryKey> keyResults) {
        if (byteKeyResults.isEmpty()) {
            return;
        }
        for (ResultKey entry : byteKeyResults) {
            keyResults.add(TableScan.convertToPrimaryKey(table, targetTables, entry));
        }
    }

    private static PrimaryKey[] convertTableKeyResults(TableImpl table, TargetTables targetTables, List<ResultKey> byteKeyResults) {
        if (byteKeyResults.isEmpty()) {
            return null;
        }
        PrimaryKey[] keyResults = new PrimaryKey[byteKeyResults.size()];
        int i = 0;
        for (ResultKey entry : byteKeyResults) {
            keyResults[i++] = TableScan.convertToPrimaryKey(table, targetTables, entry);
        }
        return keyResults;
    }

    private static PrimaryKey convertToPrimaryKey(TableImpl table, TargetTables targetTables, ResultKey byteKeyResult) {
        if (targetTables.hasAncestorTables()) {
            table = table.getTopLevelTable();
        }
        return table.createPrimaryKeyFromResultKey(byteKeyResult);
    }

    private static AsyncTableIterator<Row> createPartitionRowIterator(final TableAPIImpl apiImpl, final StoreIteratorParams params, TableKey key, final TargetTables targetTables, IterationHandleNotifier iterHandleNotifier) {
        KVStoreImpl store = apiImpl.getStore();
        byte[] parentKeyBytes = store.getKeySerializer().toByteArray(key.getKey());
        PartitionId partitionId = store.getDispatcher().getPartitionId(parentKeyBytes);
        Set<Integer> partitions = params.getPartitions();
        if (partitions != null && !partitions.contains(partitionId.getPartitionId())) {
            return new EmptyTableIterator<Row>(iterHandleNotifier);
        }
        final TableImpl table = key.getTable();
        return new MultiGetIteratorWrapper<Row>(store, partitionId, params, iterHandleNotifier){

            @Override
            TableIterate createOp() {
                return new TableIterate(params, targetTables, true, this.resumeKey, 1);
            }

            Row[] processResult(Result result) {
                this.moreElements = result.hasMoreElements();
                List<ResultKeyValueVersion> byteKeyResults = result.getKeyValueVersionList();
                if (byteKeyResults.isEmpty()) {
                    assert (!this.moreElements);
                    return null;
                }
                this.resumeKey = byteKeyResults.get(byteKeyResults.size() - 1).getKeyBytes();
                return TableScan.convertTableRowResults(apiImpl, table, targetTables, byteKeyResults);
            }
        };
    }

    private static AsyncTableIterator<PrimaryKey> createPartitionKeyIterator(TableAPIImpl apiImpl, final StoreIteratorParams params, TableKey key, final TargetTables targetTables, IterationHandleNotifier iterHandleNotifier) {
        KVStoreImpl store = apiImpl.getStore();
        byte[] parentKeyBytes = store.getKeySerializer().toByteArray(key.getKey());
        PartitionId partitionId = store.getDispatcher().getPartitionId(parentKeyBytes);
        Set<Integer> partitions = params.getPartitions();
        if (partitions != null && !partitions.contains(partitionId.getPartitionId())) {
            return new EmptyTableIterator<PrimaryKey>(iterHandleNotifier);
        }
        final TableImpl table = key.getTable();
        return new MultiGetIteratorWrapper<PrimaryKey>(store, partitionId, params, iterHandleNotifier){

            @Override
            TableKeysIterate createOp() {
                return new TableKeysIterate(params, targetTables, true, this.resumeKey, 1);
            }

            PrimaryKey[] processResult(Result result) {
                this.moreElements = result.hasMoreElements();
                List<ResultKey> byteKeyResults = result.getKeyList();
                if (byteKeyResults.isEmpty()) {
                    assert (!this.moreElements);
                    return null;
                }
                this.resumeKey = byteKeyResults.get(byteKeyResults.size() - 1).getKeyBytes();
                return TableScan.convertTableKeyResults(table, targetTables, byteKeyResults);
            }
        };
    }

    private static class EmptyTableIterator<E>
    extends BasicMultiGetIteratorWrapper<E> {
        EmptyTableIterator(IterationHandleNotifier iterHandlerNotifier) {
            super(iterHandlerNotifier);
        }

        @Override
        E[] getMoreElements() {
            return null;
        }

        @Override
        boolean hasMoreElements() {
            return false;
        }

        @Override
        void getMoreElementsAsync(ResultHandler<E[]> handler) {
            handler.onResult(null, null);
        }
    }

    private static abstract class BasicPartitionMultiGetHandler<T extends Row> {
        final TableAPIImpl apiImpl;
        final KVStoreImpl store;
        final PartitionId[] partitionIds;
        final TableKey key;
        final boolean singlePartition;
        final byte[] continuationKey;
        final TargetTables targetTables;
        final StoreIteratorParams params;
        final int batchResultSize;
        final int maxReadKB;
        final LogContext lc;
        final List<T> rows = new ArrayList<T>();
        byte[] resumeKey = null;
        private PartitionId partition;
        private int numRead = 0;
        private int readKB = 0;
        private int writeKB = 0;
        private byte[] contdKey = null;

        BasicPartitionMultiGetHandler(TableAPIImpl apiImpl, TableKey key, byte[] continuationKey, MultiRowOptions getOptions, TableIteratorOptions iterateOptions, LogContext lc) {
            this.apiImpl = apiImpl;
            this.store = apiImpl.getStore();
            Set pids = this.store.getTopology().getPartitionMap().getAllIds();
            this.partitionIds = pids.toArray(new PartitionId[pids.size()]);
            this.key = key;
            this.singlePartition = key.getMajorKeyComplete();
            this.continuationKey = continuationKey;
            this.targetTables = TableAPIImpl.makeTargetTables(key.getTable(), getOptions);
            this.params = new StoreIteratorParams(Direction.FORWARD, TableAPIImpl.getBatchSize(iterateOptions), TableAPIImpl.getMaxReadKB(iterateOptions), key.getKeyBytes(), TableAPIImpl.makeKeyRange(key, getOptions), Depth.PARENT_AND_DESCENDANTS, TableAPIImpl.getConsistency(iterateOptions), TableAPIImpl.getTimeout(iterateOptions), TableAPIImpl.getTimeoutUnit(iterateOptions), null);
            this.batchResultSize = this.params.getBatchSize();
            this.maxReadKB = this.params.getMaxReadKB();
            this.lc = lc;
        }

        abstract InternalOperation createIterateOp(int var1);

        abstract void convertToResults(Result var1);

        MultiGetResult<T> execute() {
            Request request;
            Result result;
            this.initIteration();
            while (!this.processResult(result = this.store.executeRequest(request = this.createRequest()))) {
            }
            return this.createResult();
        }

        private void initIteration() {
            if (this.continuationKey != null) {
                int pid = PackedInteger.readInt(this.continuationKey, 0);
                if (pid < 1 || pid > this.partitionIds.length) {
                    throw new IllegalArgumentException("Invalid partition id in continuation key: " + pid);
                }
                this.partition = new PartitionId(pid);
                int idLen = PackedInteger.getReadIntLength(this.continuationKey, 0);
                if (this.continuationKey.length > idLen) {
                    this.resumeKey = Arrays.copyOfRange(this.continuationKey, idLen, this.continuationKey.length);
                }
            } else {
                this.partition = this.singlePartition ? this.getPartitionId(this.key) : this.getNextPartition(null);
            }
        }

        private Request createRequest() {
            int emptyReadFactor = this.singlePartition || this.numRead == 0 && this.partition.getPartitionId() == this.partitionIds.length ? 1 : 0;
            InternalOperation op = this.createIterateOp(emptyReadFactor);
            return this.store.makeReadRequest(op, this.partition, this.params.getConsistency(), this.params.getTimeout(), this.params.getTimeoutUnit(), this.lc);
        }

        private boolean processResult(Result result) {
            this.numRead += result.getNumRecords();
            this.readKB += result.getReadKB();
            this.writeKB += result.getWriteKB();
            if (result.getNumRecords() > 0) {
                this.convertToResults(result);
                this.resumeKey = result.getPrimaryResumeKey();
            }
            if (result.hasMoreElements()) {
                this.contdKey = BasicPartitionMultiGetHandler.genContinuationKey(this.partition, this.resumeKey);
                return true;
            }
            if (this.singlePartition) {
                this.partition = null;
                return true;
            }
            this.partition = this.getNextPartition(this.partition);
            if (this.partition == null) {
                return true;
            }
            if (this.maxReadKB != 0) {
                if (this.readKB >= this.maxReadKB) {
                    this.contdKey = BasicPartitionMultiGetHandler.genContinuationKey(this.partition, null);
                    return true;
                }
                this.params.setMaxReadKB(this.maxReadKB - this.readKB);
            }
            if (this.batchResultSize != 0) {
                if (this.numRead >= this.batchResultSize) {
                    this.contdKey = BasicPartitionMultiGetHandler.genContinuationKey(this.partition, null);
                    return true;
                }
                this.params.setBatchSize(this.batchResultSize - this.numRead);
            }
            if (this.resumeKey != null) {
                this.resumeKey = null;
            }
            return false;
        }

        private MultiGetResult<T> createResult() {
            return new MultiGetResult<T>(this.rows, this.contdKey, this.readKB, this.writeKB);
        }

        void executeAsync(final ResultHandler<MultiGetResult<T>> handler) {
            this.initIteration();
            class ExecuteAsyncHandler
            implements ResultHandler<Result> {
                ExecuteAsyncHandler() {
                }

                void execute() {
                    BasicPartitionMultiGetHandler.this.store.executeRequest(BasicPartitionMultiGetHandler.this.createRequest(), this);
                }

                @Override
                public void onResult(Result result, Throwable exception) {
                    if (exception != null) {
                        handler.onResult(null, exception);
                    } else if (BasicPartitionMultiGetHandler.this.processResult(result)) {
                        handler.onResult(BasicPartitionMultiGetHandler.this.createResult(), null);
                    } else {
                        this.execute();
                    }
                }
            }
            new ExecuteAsyncHandler().execute();
        }

        private static byte[] genContinuationKey(PartitionId partitionId, byte[] resumeKey) {
            int pid = partitionId.getPartitionId();
            int pidLen = PackedInteger.getWriteIntLength(pid);
            int len = pidLen + (resumeKey != null ? resumeKey.length : 0);
            byte[] bytes = new byte[len];
            PackedInteger.writeInt(bytes, 0, pid);
            if (resumeKey != null) {
                System.arraycopy(resumeKey, 0, bytes, pidLen, resumeKey.length);
            }
            return bytes;
        }

        private PartitionId getPartitionId(TableKey tKey) {
            return this.store.getTopology().getPartitionId(this.store.getKeySerializer().toByteArray(tKey.getKey()));
        }

        private PartitionId getNextPartition(PartitionId partitionId) {
            if (partitionId == null) {
                return this.partitionIds[0];
            }
            if (partitionId.getPartitionId() == this.partitionIds.length) {
                return null;
            }
            return this.partitionIds[partitionId.getPartitionId()];
        }
    }

    private static abstract class BasicMultiGetIteratorWrapper<E>
    implements AsyncTableIterator<E> {
        private final IterationHandleNotifier iterHandleNotifier;
        private E[] elements = null;
        private int nextElement = 0;
        private volatile boolean closed;
        private volatile Throwable closeException;

        BasicMultiGetIteratorWrapper(IterationHandleNotifier iterHandleNotifier) {
            this.iterHandleNotifier = iterHandleNotifier;
        }

        abstract E[] getMoreElements();

        abstract boolean hasMoreElements();

        abstract void getMoreElementsAsync(ResultHandler<E[]> var1);

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            if (this.elements != null && this.nextElement < this.elements.length) {
                return true;
            }
            this.elements = this.getMoreElements();
            if (this.elements == null) {
                return false;
            }
            assert (this.elements.length > 0);
            this.nextElement = 0;
            return true;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.elements[this.nextElement++];
        }

        @Override
        public synchronized void close() {
            this.closed = true;
        }

        @Override
        public List<DetailedMetrics> getPartitionMetrics() {
            return Collections.emptyList();
        }

        @Override
        public List<DetailedMetrics> getShardMetrics() {
            return Collections.emptyList();
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public Throwable getCloseException() {
            return this.closeException;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E nextLocal() {
            E next;
            assert (!Thread.holdsLock(this));
            if (this.closed) {
                return null;
            }
            BasicMultiGetIteratorWrapper basicMultiGetIteratorWrapper = this;
            synchronized (basicMultiGetIteratorWrapper) {
                if (this.elements != null && this.nextElement < this.elements.length) {
                    next = this.elements[this.nextElement++];
                    if (this.nextElement < this.elements.length) {
                        return next;
                    }
                } else {
                    next = null;
                }
            }
            class NextLocalResultHandler
            implements ResultHandler<E[]> {
                NextLocalResultHandler() {
                }

                @Override
                public void onResult(E[] newElements, Throwable exception) {
                    BasicMultiGetIteratorWrapper.this.handleNewElementsResult(newElements, exception);
                }
            }
            this.getMoreElementsAsync(new NextLocalResultHandler());
            return next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handleNewElementsResult(E[] newElements, Throwable exception) {
            assert (!Thread.holdsLock(this));
            BasicMultiGetIteratorWrapper basicMultiGetIteratorWrapper = this;
            synchronized (basicMultiGetIteratorWrapper) {
                if (exception != null) {
                    if (!this.closed) {
                        this.closeException = exception;
                        this.closed = true;
                    }
                } else {
                    this.elements = newElements;
                    if (this.elements == null) {
                        this.closed = true;
                    }
                }
            }
            this.iterHandleNotifier.notifyNext();
        }
    }

    private static abstract class MultiGetIteratorWrapper<E>
    extends BasicMultiGetIteratorWrapper<E> {
        private final KVStoreImpl store;
        private final PartitionId partitionId;
        private final StoreIteratorParams params;
        private volatile boolean executingRequest;
        boolean moreElements = true;
        byte[] resumeKey = null;

        MultiGetIteratorWrapper(KVStoreImpl store, PartitionId partitionId, StoreIteratorParams params, IterationHandleNotifier iterHandlerNotifier) {
            super(iterHandlerNotifier);
            this.store = store;
            this.partitionId = partitionId;
            this.params = params;
        }

        @Override
        E[] getMoreElements() {
            if (!this.moreElements) {
                return null;
            }
            return this.processResult(this.store.executeRequest(this.createRequest()));
        }

        @Override
        boolean hasMoreElements() {
            return this.moreElements;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void getMoreElementsAsync(final ResultHandler<E[]> handler) {
            Request request;
            assert (!Thread.holdsLock(this));
            if (this.executingRequest) {
                return;
            }
            MultiGetIteratorWrapper multiGetIteratorWrapper = this;
            synchronized (multiGetIteratorWrapper) {
                Request request2 = request = this.moreElements ? this.createRequest() : null;
                if (request != null) {
                    this.executingRequest = true;
                }
            }
            if (request == null) {
                handler.onResult(null, null);
                return;
            }
            this.store.executeRequest(request, new ResultHandler<Result>(){

                @Override
                public void onResult(Result result, Throwable exception) {
                    executingRequest = false;
                    if (exception != null) {
                        handler.onResult(null, exception);
                    } else {
                        this.handleResultCompleted(handler, result);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handleResultCompleted(ResultHandler<E[]> handler, Result result) {
            E[] elements;
            assert (!Thread.holdsLock(this));
            MultiGetIteratorWrapper multiGetIteratorWrapper = this;
            synchronized (multiGetIteratorWrapper) {
                elements = this.processResult(result);
            }
            handler.onResult(elements, null);
        }

        abstract MultiTableOperation createOp();

        abstract E[] processResult(Result var1);

        private Request createRequest() {
            return this.store.makeReadRequest((InternalOperation)this.createOp(), this.partitionId, this.params.getConsistency(), this.params.getTimeout(), this.params.getTimeoutUnit(), null);
        }
    }

    private static class PartitionMultiGetKeysHandler
    extends BasicPartitionMultiGetHandler<PrimaryKey> {
        PartitionMultiGetKeysHandler(TableAPIImpl apiImpl, TableKey key, byte[] continuationKey, MultiRowOptions getOptions, TableIteratorOptions iterateOptions, LogContext lc) {
            super(apiImpl, key, continuationKey, getOptions, iterateOptions, lc);
        }

        @Override
        InternalOperation createIterateOp(int readEmptyFactor) {
            return new TableKeysIterate(this.params, this.targetTables, this.key.getMajorKeyComplete(), this.resumeKey, readEmptyFactor);
        }

        @Override
        void convertToResults(Result result) {
            TableScan.convertTableKeyResults(this.key.getTable(), this.targetTables, result.getKeyList(), this.rows);
        }
    }

    private static class PartitionMultiGetHandler
    extends BasicPartitionMultiGetHandler<Row> {
        PartitionMultiGetHandler(TableAPIImpl apiImpl, TableKey key, byte[] continuationKey, MultiRowOptions getOptions, TableIteratorOptions iterateOptions, LogContext lc) {
            super(apiImpl, key, continuationKey, getOptions, iterateOptions, lc);
        }

        @Override
        InternalOperation createIterateOp(int readEmptyFactor) {
            return new TableIterate(this.params, this.targetTables, this.key.getMajorKeyComplete(), this.resumeKey, readEmptyFactor);
        }

        @Override
        void convertToResults(Result result) {
            TableScan.convertTableRowResults(this.apiImpl, this.key.getTable(), this.targetTables, result.getKeyValueVersionList(), this.rows);
        }
    }
}

