/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import oracle.kv.LoginCredentials;
import oracle.kv.impl.util.FastExternalizable;
import oracle.kv.impl.util.ObjectUtil;
import oracle.kv.impl.util.SerializationUtil;

public class PasswordCredentials
implements FastExternalizable,
LoginCredentials,
Serializable {
    private static final long serialVersionUID = 1L;
    private String username;
    private char[] password;

    public PasswordCredentials(String username, char[] password) throws IllegalArgumentException {
        if (username == null) {
            throw new IllegalArgumentException("The username argument must not be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("The password argument must not be null");
        }
        this.username = username;
        this.password = Arrays.copyOf(password, password.length);
    }

    public PasswordCredentials(DataInput in, short serialVersion) throws IOException {
        this.username = SerializationUtil.readNonNullString(in, serialVersion);
        this.password = new char[SerializationUtil.readNonNullSequenceLength(in)];
        for (int i = 0; i < this.password.length; ++i) {
            this.password[i] = in.readChar();
        }
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        SerializationUtil.writeNonNullString(out, serialVersion, this.username);
        SerializationUtil.writeNonNullSequenceLength(out, this.password.length);
        for (char c : this.password) {
            out.writeChar(c);
        }
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public char[] getPassword() {
        return Arrays.copyOf(this.password, this.password.length);
    }

    public void clear() {
        Arrays.fill(this.password, ' ');
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        try {
            ObjectUtil.checkNull("username", this.username);
            ObjectUtil.checkNull("password", this.password);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Invalid field: " + e.getMessage(), e);
        }
    }
}

