/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.workbenchintegration;

import org.eclipse.persistence.sequencing.DefaultSequence;
import org.eclipse.persistence.sequencing.NativeSequence;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sequencing.TableSequence;
import org.eclipse.persistence.sequencing.UnaryTableSequence;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeProject;
import org.eclipse.persistence.testing.tests.workbenchintegration.WorkbenchIntegrationSystemHelper;

public class SequencingWorkbenchIntegrationTest
extends AutoVerifyTestCase {
    static int PROJECT_XML = 1;
    static int PROJECT_CLASS_GENERATED = 2;
    static String fileName = "SequencingMWIntegrationEmployeeProject";
    int mode;
    Project originalProject;
    Project project;

    public static SequencingWorkbenchIntegrationTest projectXML() {
        return new SequencingWorkbenchIntegrationTest(PROJECT_XML);
    }

    public static SequencingWorkbenchIntegrationTest projectClassGenerated() {
        return new SequencingWorkbenchIntegrationTest(PROJECT_CLASS_GENERATED);
    }

    SequencingWorkbenchIntegrationTest(int mode) {
        this.mode = mode;
        String strMode = null;
        if (mode == PROJECT_XML) {
            strMode = " XMLProj";
        } else if (mode == PROJECT_CLASS_GENERATED) {
            strMode = " ProjClassGen";
        }
        this.setName(this.getName() + strMode);
    }

    protected void setup() throws Exception {
        this.originalProject = new EmployeeProjectAmended();
        if (this.mode == PROJECT_XML) {
            this.project = WorkbenchIntegrationSystemHelper.buildProjectXML(this.originalProject, fileName);
        } else if (this.mode == PROJECT_CLASS_GENERATED) {
            this.project = WorkbenchIntegrationSystemHelper.buildProjectClass(this.originalProject, fileName);
        } else {
            throw new TestWarningException("Invalid mode");
        }
    }

    protected void verify() {
        DatabaseLogin originalLogin = this.originalProject.getLogin();
        DatabaseLogin login = this.project.getLogin();
        if (!originalLogin.getDefaultSequence().equals((Object)login.getDefaultSequence())) {
            throw new TestErrorException("Default sequence has changed");
        }
        if (login.getDatasourcePlatform().getSequences() == null) {
            throw new TestErrorException("Sequences are missing");
        }
        if (originalLogin.getDatasourcePlatform().getSequences().size() != login.getDatasourcePlatform().getSequences().size()) {
            throw new TestErrorException("Number of sequences has changed");
        }
        for (Sequence sequence : originalLogin.getDatasourcePlatform().getSequences().values()) {
            if (sequence.equals((Object)login.getSequence(sequence.getName()))) continue;
            throw new TestErrorException("Sequence " + sequence.getName() + " has changed");
        }
    }

    static class EmployeeProjectAmended
    extends EmployeeProject {
        EmployeeProjectAmended() {
        }

        @Override
        public void applyLogin() {
            super.applyLogin();
            DatabaseLogin login = this.getLogin();
            login.setDefaultSequence((Sequence)new TableSequence("", 25, "MY_SEQUENCE", "MY_SEQ_NAME", "MY_SEQ_COUNT"));
            login.addSequence((Sequence)new DefaultSequence("EMP_SEQ", 30));
            login.addSequence((Sequence)new NativeSequence("PROJ_SEQ", 35));
            login.addSequence((Sequence)new UnaryTableSequence("ADDRESS_SEQ", 40));
        }
    }
}

