/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpql;

import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.models.employee.domain.Project;
import org.eclipse.persistence.testing.tests.jpql.JPQLTestCase;

public class ComplexInheritanceTest
extends JPQLTestCase {
    public ComplexInheritanceTest() {
        this.setDescription("Test that EJBQL finder works across inheritance hierarchy");
    }

    @Override
    public void setup() {
        String projectName = null;
        this.getAbstractSession().addAlias("ProjectBaseClass", this.getSession().getDescriptor(Project.class));
        Project project = null;
        Vector projects = this.getSomeProjects();
        for (int i = 0; i < projects.size() && !((project = (Project)projects.elementAt(i)) instanceof LargeProject); ++i) {
        }
        projectName = project.getName();
        ReadObjectQuery roq = new ReadObjectQuery();
        ExpressionBuilder eb = new ExpressionBuilder();
        Expression whereClause = eb.get("name").equal((Object)projectName);
        roq.setSelectionCriteria(whereClause);
        roq.setReferenceClass(LargeProject.class);
        LargeProject proj = (LargeProject)this.getSession().executeQuery((DatabaseQuery)roq);
        if (proj == null) {
            this.setOriginalOject(new Vector(0));
        } else {
            this.setOriginalOject(proj);
        }
        String ejbql = "SELECT OBJECT(project) FROM ProjectBaseClass project WHERE project.name = \"" + projectName + "\"";
        this.setEjbqlString(ejbql);
        this.setReferenceClass(LargeProject.class);
    }

    @Override
    public void reset() {
        this.getAbstractSession().getAliasDescriptors().remove("ProjectBaseClass");
        super.reset();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }
}

