/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.events;

import org.eclipse.persistence.descriptors.DescriptorEventListener;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.events.Customer;
import org.eclipse.persistence.testing.tests.events.UpdateAttributeEventListener;

public class UpdateAttributeTest
extends AutoVerifyTestCase {
    public DescriptorEventListener listener = new UpdateAttributeEventListener();
    public Customer customer;

    public void setup() throws Throwable {
        super.setup();
        this.customer = Customer.example1();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.registerObject((Object)this.customer);
        uow.commit();
        this.getSession().getDescriptor(Customer.class).getEventManager().addListener(this.listener);
    }

    public void test() {
        try {
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            Customer clone = (Customer)uow.readObject(Customer.class);
            clone.name = "99999";
            uow.commit();
        }
        catch (DatabaseException ex) {
            throw new TestErrorException("Duplicate column names mean bug 4436710 is still broken");
        }
    }

    public void reset() throws Throwable {
        super.reset();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.deleteObject((Object)this.customer);
        uow.commit();
        this.getSession().getDescriptor(Customer.class).getEventManager().removeListener(this.listener);
    }
}

