/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.nosql.adapters.sdk;

import jakarta.resource.ResourceException;
import jakarta.resource.cci.Connection;
import jakarta.resource.cci.ConnectionFactory;
import jakarta.resource.cci.ConnectionSpec;
import jakarta.resource.cci.RecordFactory;
import jakarta.resource.cci.ResourceAdapterMetaData;
import java.io.IOException;
import javax.naming.Reference;
import oracle.nosql.driver.AuthorizationProvider;
import oracle.nosql.driver.NoSQLHandle;
import oracle.nosql.driver.NoSQLHandleConfig;
import oracle.nosql.driver.NoSQLHandleFactory;
import oracle.nosql.driver.iam.SignatureProvider;
import oracle.nosql.driver.kv.StoreAccessTokenProvider;
import oracle.nosql.driver.ops.Request;
import org.eclipse.persistence.internal.nosql.adapters.sdk.OracleNoSQLAdapterMetaData;
import org.eclipse.persistence.internal.nosql.adapters.sdk.OracleNoSQLConnection;
import org.eclipse.persistence.internal.nosql.adapters.sdk.OracleNoSQLJCAConnectionSpec;
import org.eclipse.persistence.internal.nosql.adapters.sdk.OracleNoSQLRecordFactory;

public class OracleNoSQLConnectionFactory
implements ConnectionFactory {
    public Connection getConnection() throws ResourceException {
        return this.getConnection(new OracleNoSQLJCAConnectionSpec());
    }

    public Connection getConnection(ConnectionSpec spec) throws ResourceException {
        OracleNoSQLJCAConnectionSpec connectionSpec = (OracleNoSQLJCAConnectionSpec)spec;
        NoSQLHandle noSQLHandle = null;
        try {
            NoSQLHandleConfig config = new NoSQLHandleConfig(connectionSpec.getEndPoint());
            config.setAuthorizationProvider(this.getAuthorizationProvider(config, connectionSpec));
            noSQLHandle = NoSQLHandleFactory.createNoSQLHandle((NoSQLHandleConfig)config);
        }
        catch (Exception exception) {
            throw new ResourceException(exception.toString(), (Throwable)exception);
        }
        return new OracleNoSQLConnection(noSQLHandle, connectionSpec);
    }

    public ResourceAdapterMetaData getMetaData() {
        return new OracleNoSQLAdapterMetaData();
    }

    public RecordFactory getRecordFactory() {
        return new OracleNoSQLRecordFactory();
    }

    public Reference getReference() {
        return new Reference(this.getClass().getName());
    }

    public void setReference(Reference reference) {
    }

    private AuthorizationProvider getAuthorizationProvider(NoSQLHandleConfig config, OracleNoSQLJCAConnectionSpec connectionSpec) {
        Object authorizationProvider = null;
        try {
            block1 : switch (connectionSpec.getService()) {
                case CLOUD: {
                    switch (connectionSpec.getAuthPrincipalType()) {
                        case USER: {
                            authorizationProvider = new SignatureProvider();
                            break block1;
                        }
                        case INSTANCE: {
                            if (connectionSpec.getCompartment() == null) {
                                throw new IllegalArgumentException("Compartment is required for Instance/Resource Principal authorization");
                            }
                            authorizationProvider = SignatureProvider.createWithInstancePrincipal();
                            break block1;
                        }
                        case RESOURCE: {
                            if (connectionSpec.getCompartment() == null) {
                                throw new IllegalArgumentException("Compartment is required for Instance/Resource Principal authorization");
                            }
                            authorizationProvider = SignatureProvider.createWithResourcePrincipal();
                        }
                    }
                    break;
                }
                case ON_PREMISE: {
                    authorizationProvider = new StoreAccessTokenProvider();
                    break;
                }
                case CLOUD_SIMULATOR: {
                    authorizationProvider = new AuthorizationProvider(){

                        public String getAuthorizationString(Request request) {
                            return "Bearer cloudsim";
                        }

                        public void close() {
                        }
                    };
                }
            }
        }
        catch (IOException ioe) {
            System.err.println("Unable to configure authentication: " + ioe);
        }
        return authorizationProvider;
    }
}

