/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.nosql.adapters.mongo;

import com.mongodb.MongoClient;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import org.bson.BsonReader;
import org.bson.BsonTimestamp;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.codecs.BsonTypeClassMap;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.DocumentCodecProvider;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;

public class MongoCodecs {
    private static volatile CodecRegistry codecRegistry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CodecRegistry codecRegistry() {
        if (codecRegistry != null) return codecRegistry;
        Class<MongoCodecs> clazz = MongoCodecs.class;
        synchronized (MongoCodecs.class) {
            if (codecRegistry != null) return codecRegistry;
            HashMap<BsonType, Class> replacements = new HashMap<BsonType, Class>();
            replacements.put(BsonType.TIMESTAMP, Timestamp.class);
            replacements.put(BsonType.BINARY, byte[].class);
            BsonTypeClassMap bsonTypeClassMap = new BsonTypeClassMap(replacements);
            DocumentCodecProvider documentCodecProvider = new DocumentCodecProvider(bsonTypeClassMap);
            codecRegistry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{CodecRegistries.fromCodecs((Codec[])new Codec[]{new TimestampCodec(), new DateCodec(), new TimeCodec()}), CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{documentCodecProvider}), MongoClient.getDefaultCodecRegistry()});
            // ** MonitorExit[var0] (shouldn't be in output)
            return codecRegistry;
        }
    }

    static class TimeCodec
    implements Codec<Time> {
        TimeCodec() {
        }

        public void encode(BsonWriter writer, Time value, EncoderContext encoderContext) {
            writer.writeDateTime(value.getTime());
        }

        public Time decode(BsonReader reader, DecoderContext decoderContext) {
            return new Time(reader.readDateTime());
        }

        public Class<Time> getEncoderClass() {
            return Time.class;
        }
    }

    static class DateCodec
    implements Codec<Date> {
        DateCodec() {
        }

        public void encode(BsonWriter writer, Date value, EncoderContext encoderContext) {
            writer.writeDateTime(value.getTime());
        }

        public Date decode(BsonReader reader, DecoderContext decoderContext) {
            return new Date(reader.readDateTime());
        }

        public Class<Date> getEncoderClass() {
            return Date.class;
        }
    }

    public static class TimestampCodec
    implements Codec<Timestamp> {
        public void encode(BsonWriter writer, Timestamp value, EncoderContext encoderContext) {
            writer.writeTimestamp(new BsonTimestamp((int)(value.getTime() / 1000L), 0));
        }

        public Timestamp decode(BsonReader reader, DecoderContext decoderContext) {
            return new Timestamp((long)reader.readTimestamp().getTime() * 1000L);
        }

        public Class<Timestamp> getEncoderClass() {
            return Timestamp.class;
        }
    }
}

