/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.mappings.AggregateCollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.tests.validation.EmployeeWithProblems;
import org.eclipse.persistence.testing.tests.validation.ExceptionTestSaveDescriptor;

public class ReferenceDescriptorIsNotAggreagteCollectionTest
extends ExceptionTestSaveDescriptor {
    public ReferenceDescriptorIsNotAggreagteCollectionTest() {
        this.setDescription("This tests Reference Descriptor Is Not Aggregate Collection (TL-ERROR 153) ");
    }

    @Override
    protected void setup() {
        this.expectedException = DescriptorException.referenceDescriptorIsNotAggregateCollection(null, null);
        super.setup();
    }

    public void test() {
        try {
            ((DatabaseSession)this.getSession()).addDescriptor((ClassDescriptor)this.buildEmployeeDescriptor());
        }
        catch (EclipseLinkException exception) {
            this.caughtException = exception;
        }
    }

    public RelationalDescriptor buildEmployeeDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(EmployeeWithProblems.class);
        descriptor.addTableName("EMPLOYEE");
        descriptor.addTableName("SALARY");
        descriptor.addPrimaryKeyFieldName("EMPLOYEE.EMP_ID");
        descriptor.useFullIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteFullIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("EMP_ID");
        descriptor.setSequenceNumberName("EMP_SEQ");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        AggregateCollectionMapping addressesMapping = new AggregateCollectionMapping();
        addressesMapping.setAttributeName("addressesWithProblems");
        addressesMapping.setReferenceClass(Address.class);
        addressesMapping.setUsesIndirection(false);
        addressesMapping.setIsPrivateOwned(true);
        addressesMapping.setIsReadOnly(false);
        descriptor.addMapping((DatabaseMapping)addressesMapping);
        return descriptor;
    }
}

