/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.QueryByExamplePolicy;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class QBESpecialOperators
extends TestCase {
    public Employee employee;
    public QueryByExamplePolicy policy;

    public QBESpecialOperators() {
        this.setDescription("To test the Query By Example Policy by using specail operators for comparison.");
    }

    public void setup() {
        this.employee = new Employee();
        this.policy = new QueryByExamplePolicy();
        this.employee.setFirstName("J__l");
        this.employee.setLastName("M%");
        this.employee.setSalary(60000);
        this.policy.addSpecialOperation(Integer.class, "lessThan");
        this.policy.addSpecialOperation(String.class, "like");
    }

    public void test() {
        ReadObjectQuery query = new ReadObjectQuery();
        query.setReferenceClass(Employee.class);
        query.setExampleObject((Object)this.employee);
        query.setQueryByExamplePolicy(this.policy);
        Employee emp = new Employee();
        emp = (Employee)this.getSession().executeQuery((DatabaseQuery)query);
        if (emp.getFirstName().charAt(0) != 'J' && emp.getFirstName().charAt(3) == 'l' && emp.getLastName().charAt(0) == 'M') {
            throw new TestErrorException("Error in using specail operators.");
        }
        if (emp.getSalary() >= 60000) {
            throw new TestErrorException("Error is using spcial operators.");
        }
    }
}

