/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework.naming;

import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class InitialContextImpl
implements Context {
    Hashtable env;
    static Hashtable stringNamespace = new Hashtable();
    static Hashtable namespace = new Hashtable();

    public InitialContextImpl() {
    }

    public InitialContextImpl(Hashtable env) {
        this.env = env;
    }

    public Object internalLookup(Object name) {
        Object obj = stringNamespace.get(name);
        if (obj == null) {
            obj = namespace.get(name);
        }
        if (obj == null) {
            return null;
        }
        return obj;
    }

    @Override
    public Object lookup(String name) throws NamingException {
        Object obj = this.internalLookup(name);
        if (obj == null) {
            throw new NameNotFoundException(name);
        }
        return obj;
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        Object obj = this.internalLookup(name);
        if (obj == null) {
            throw new NameNotFoundException(name.toString());
        }
        return obj;
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        if (this.internalLookup(name) != null) {
            throw new NameAlreadyBoundException(name);
        }
        this.rebind(name, obj);
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        if (this.internalLookup(name) != null) {
            throw new NameAlreadyBoundException(name.toString());
        }
        this.rebind(name, obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        stringNamespace.put(name, obj);
        this.rebind(new CompositeName(name), obj);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        namespace.put(name, obj);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.env;
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public void unbind(Name name) throws NamingException {
        namespace.remove(name);
    }

    @Override
    public void unbind(String name) throws NamingException {
        stringNamespace.remove(name);
        this.unbind(new CompositeName(name));
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return null;
    }

    public NamingEnumeration list(String name) throws NamingException {
        return null;
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return null;
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return null;
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return null;
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return null;
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return null;
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return null;
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return null;
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return null;
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        return null;
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return null;
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return null;
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return null;
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return null;
    }
}

