/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.validation.ExceptionTest;

public class NoSuchMethodWhileInitializingAttributesInMethodAccessor_GetTest
extends ExceptionTest {
    ClassDescriptor orgDescriptor;
    IntegrityChecker orgIntegrityChecker;

    public NoSuchMethodWhileInitializingAttributesInMethodAccessor_GetTest() {
        this.setDescription("This tests No Such (Get) Method While Initializing Attributes In Method Accessor(TL-ERROR 60) ");
    }

    protected void setup() {
        this.expectedException = DescriptorException.noSuchMethodWhileInitializingAttributesInMethodAccessor(null, null, null);
        this.orgDescriptor = ((DatabaseSession)this.getSession()).getDescriptor(Employee.class);
        this.orgIntegrityChecker = this.getSession().getIntegrityChecker();
    }

    @Override
    public void reset() {
        ((DatabaseSession)this.getSession()).getDescriptors().remove(Employee.class);
        if (this.orgDescriptor != null) {
            ((DatabaseSession)this.getSession()).addDescriptor(this.orgDescriptor);
        }
        if (this.orgIntegrityChecker != null) {
            this.getSession().setIntegrityChecker(this.orgIntegrityChecker);
        }
    }

    public void test() {
        try {
            this.getSession().setIntegrityChecker(new IntegrityChecker());
            this.getSession().getIntegrityChecker().dontCatchExceptions();
            ((DatabaseSession)this.getSession()).addDescriptor((ClassDescriptor)this.descriptor());
        }
        catch (EclipseLinkException exception) {
            this.caughtException = exception;
        }
    }

    public RelationalDescriptor descriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Employee.class);
        descriptor.addTableName("EMPLOYEE");
        descriptor.addPrimaryKeyFieldName("EMPLOYEE.EMP_ID");
        descriptor.useFullIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteFullIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("EMP_ID");
        descriptor.setSequenceNumberName("EMP_SEQ");
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping firstNameMapping = new DirectToFieldMapping();
        firstNameMapping.setAttributeName("firstName");
        firstNameMapping.setFieldName("EMPLOYEE.F_NAME");
        firstNameMapping.setSetMethodName("setFirstName");
        firstNameMapping.setGetMethodName("getFirstName_BAD");
        descriptor.addMapping((DatabaseMapping)firstNameMapping);
        return descriptor;
    }
}

