/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork.writechanges;

import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class AcquireNestedUnitOfWork_WriteChanges_TestCase
extends AutoVerifyTestCase {
    protected Exception exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        UnitOfWork nestedUow = uow.acquireUnitOfWork();
        try {
            nestedUow.writeChanges();
        }
        catch (Exception e) {
            this.exception = e;
        }
        finally {
            nestedUow.release();
            uow.release();
        }
    }

    public void verify() {
        if (this.exception == null) {
            throw new TestErrorException("Exception not thrown attempting to writeChanges in a nested UnitOfWork.");
        }
        if (!(this.exception instanceof ValidationException)) {
            throw new TestErrorException("Wrong exception type thrown.", (Throwable)this.exception);
        }
        ValidationException ve = (ValidationException)((Object)this.exception);
        if (ve.getErrorCode() != 7126) {
            throw new TestErrorException("Wrong exception thrown.", (Throwable)ve);
        }
    }

    public void reset() {
        this.exception = null;
    }
}

