/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.tableswithspacesmodel;

import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestSystem;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.EmployeePopulator;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;
import org.eclipse.persistence.testing.models.employee.domain.Project;
import org.eclipse.persistence.testing.tests.tableswithspacesmodel.EmployeeWithSpacesProject;
import org.eclipse.persistence.testing.tests.tableswithspacesmodel.EmployeeWithSpacesTableCreator;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public class EmployeeWithSpacesSystem
extends TestSystem {
    public EmployeeWithSpacesSystem() {
        this.project = new EmployeeWithSpacesProject();
    }

    public void addDescriptors(DatabaseSession session) {
        session.addDescriptors(this.project);
    }

    public void createTables(DatabaseSession session) {
        if (session.getPlatform().isSymfoware()) {
            return;
        }
        String startQuoteChar = session.getPlatform().getStartDelimiter();
        String endQuoteChar = session.getPlatform().getEndDelimiter();
        new EmployeeWithSpacesTableCreator(startQuoteChar, endQuoteChar).replaceTables(session);
    }

    public DatabaseSession login() {
        DatabaseSession session = this.project.createDatabaseSession();
        session.login();
        return session;
    }

    public static void modifyPhoneDescriptor(ClassDescriptor descriptor) {
        descriptor.addDirectQueryKey("id", "EMP_ID");
        ReadAllQuery query = new ReadAllQuery();
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression exp = builder.get("id").equal(builder.getParameter("ID"));
        query.setReferenceClass(PhoneNumber.class);
        query.setSelectionCriteria(exp.and(builder.get("areaCode").equal((Object)"613")));
        query.addArgument("ID");
        descriptor.getQueryManager().removeQuery("localNumbers");
        descriptor.getQueryManager().addQuery("localNumbers", (DatabaseQuery)query);
    }

    public void populate(DatabaseSession session) {
        if (session.getPlatform().isSymfoware()) {
            throw new TestWarningException("Test system EmployeeWithSpacesSystem is not supported on Symfoware, it does not allow spaces in tables or columns.");
        }
        EmployeePopulator system = new EmployeePopulator();
        UnitOfWork unitOfWork = session.acquireUnitOfWork();
        system.buildExamples();
        Vector allObjects = new Vector();
        PopulationManager.getDefaultManager().addAllObjectsForClass(Employee.class, allObjects);
        PopulationManager.getDefaultManager().addAllObjectsForAbstractClass(Project.class, (Session)session, allObjects);
        unitOfWork.registerAllObjects(allObjects);
        unitOfWork.commit();
    }
}

